COMMENT |
============================================================================
  
  MD5.ASM v2.1.0, Message Digest 5 Transform (20 January 1995)
  (C) Copyright 1994-1995 Robert Rothenburg Walking-Owl
  
    History: 1.0    Original release (23 Sep 94)
             2.0    ASM code rewritten (Jan 95).
             2.1.0  ASM code written to use MDContext record, for 
                    "compatability" with C implementations.
  
  The author can be contacted via e-mail at <rrothenb@ic.sunysb.edu>
  or surface mail at P.O.Box 1327, Stony Brook, NY, 11790 USA.
  
== License and (Non)Warranty Information ===================================

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or 
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
============================================================================
| Note: source has been assembled successfully with TASM 3.2

; - MD5 Assembly Options (Conditional Defines): ----------------------------

__CONTEXT           EQU       1     ; Use MDContext structure

; Miscellaneous optimizations:

__LOCALVARS         EQU         1   ; Locals in STACK (otherwise in CODE)
__NOPROCS           EQU         1   ; Use macros not procs for F-I funcs.
__FASTERMETHOD      EQU         1   ; Optimized calculations for F and G (*)
__COPYINIT          EQU         1   ; 
__FASTCALLS         EQU         1   ;

__NOSTOR            EQU         1   ; Copy A,B,C,D regs. as block (faster?)
;;__SAVEEBX         EQU         1   ; Misc. optimization for F and G func(?)
__MISCOPT           EQU         1   ; Misc. optimization for H and I func
                    
; (*) __FASTERMETHOD is based on recommendations in NIST SHA specification.

; - MD5 Unconditional Defines: ---------------------------------------------

A         EQU       <DWORD PTR es: [di]>     ; chaining variables
B         EQU       <DWORD PTR es: [di][4]>  ;
C         EQU       <DWORD PTR es: [di][8]>  ;
D         EQU       <DWORD PTR es: [di][12]> ;

X         EQU       <DWORD PTR ds: [si]>    ; X[0..63]

        IFDEF   __CONTEXT
ctxlobits EQU       <DWORD PTR es: [di][16]> ; low  no. bits count
ctxhibits EQU       <DWORD PTR es: [di][20]> ; high  "   "     "
ctxinput  EQU       <DWORD PTR es: [di][24]> ; context input buffer
ctxlofin  EQU       <DWORD PTR es: [di][80]> ; 
ctxhifin  EQU       <DWORD PTR es: [di][84]>

; MDContext structure is as follows:
;
;   unsigned long buf[4]                ; 16 bytes, current hash value
;   unsigned long bits[2]               ; current count of bits
;   unsigned char in[64]                ; current buffer
;
; Note that you could improve the speed of hasing by using 8k buffers (with
; appropriate modifications to MD5Update and MD5Final), however this is not
; the standard method of using message digest contexts. Unless you're hash-
; ing hundreds of megabytes the difference is hardly noticeable.

        ENDIF
                    
; - Miscellaneous macros: --------------------------------------------------

STOR      MACRO     dest, src
           mov      eax,  src
          IFDEF     __LOCALVARS
            mov     dest, eax
          ELSE        
            mov     cs: dest, eax
          ENDIF       
         ENDM        

ADDD     MACRO      i, j      ; eax=j; i=i+eax
           mov      eax, j
           add      i, eax
         ENDM        
                    
      IFDEF     __CONTEXT
MCPY     MACRO                    
           LOCAL        @0
           cld
           shr          cx,     1
           jnc          @0
           movsb
 @0:       rep          movsw
         ENDM

MSET     MACRO             
           LOCAL        @0
           xor          ax,     ax
           shr          cx,     1
           jnc          @0
           stosb
 @0:       rep          stosw
         ENDM
      
XFORM    MACRO         
           pusha
           push        es
           add         di,     24
           push        di
           push        es
           push        dx
          IFDEF      __FASTCALLS  
           push        cs
           mov         ax, OFFSET MD5Transform
           call        ax
          ELSE
           call        cs: MD5Transform
          ENDIF
           popa
         ENDM
      ENDIF
                    
                    DOSSEG
                    .MODEL      LARGE
                    .386

                    .CODE

; - Auxiliary function F(x,y,z)=xy v not(x)z -------------------------------

; According to MD5-A specs, we could use add instead of or, however there is                
; no difference in processor speed that it should matter which one is used.

; if __FASTERMETHOD is defined, F(x,y,z)=z xor (x)(y xor z)

; result = eax, x = ebx, y = ecx, z = edx

                    IFDEF          __NOPROCS
F                     MACRO     
                    ELSE        
F                     PROC      NEAR
                    ENDIF       
                    IFDEF          __FASTERMETHOD
                      mov         eax,      ecx
                      xor         eax,      edx
                      and         eax,      ebx
                      xor         eax,      edx
                    ELSE        
                      mov         eax,      ebx
                      and         eax,      ecx
                      IFDEF          __SAVEEBX
                        push        ebx
                      ENDIF       
                      not         ebx
                      and         ebx,      edx
                      or          eax,      ebx
                      IFDEF          __SAVEEBX
                        pop         ebx
                      ENDIF       
                    ENDIF       
                    IFDEF          __NOPROCS
                      ENDM        
                    ELSE        
                      ret         
F                     ENDP      
                    ENDIF       

; -------------------------------------------------------------------------
; FF(a,b,c,d,X[k],s,t) denotes a = b + ((a + F(b,c,d) + X[k] + t) <<< s)
; -------------------------------------------------------------------------

FF                    MACRO     a, b, c, d, X, s, t
                      mov         ebx,      b
                      mov         ecx,      c
                      mov         edx,      d
                      IFDEF          __NOPROCS
                        F           
                      ELSE        
                        call        F
                      ENDIF       
                      add         eax,      a
                      add       eax,      X
                      add   eax,  t
                      rol       eax,  s
                        IFDEF   __SAVEEBX or  __FASTERMETHOD
                       ; Note: IFDEF .. or .. may give MASM 5.0 problems
                          add       eax,  ebx
                        ELSE
                          add       eax,  b
                        ENDIF       
                      mov         a,        eax
                    ENDM        
                    
S11                     EQU     7
S12                     EQU     12
S13                     EQU     17
S14                     EQU     22

; - Auxiliary function G(x,y,z)=xz v y not(z) ------------------------------
                    
                    IFDEF          __NOPROCS
G                     MACRO     
                    ELSE        
G                     PROC      NEAR
                    ENDIF       
                    mov         eax,        ebx
                    and         eax,        edx
                    IFDEF          __SAVEEBX
                      push        edx
                    ENDIF       
                    not         edx
                    and         edx,        ecx
                    or          eax,        edx
                    IFDEF          __SAVEEBX
                      pop         edx
                    ENDIF       
                    IFDEF          __NOPROCS
                    ENDM        
                    ELSE        
                      ret         
G                     ENDP      
                    ENDIF       
; --------------------------------------------------------------------------
; GG(a,b,c,d,X[k],s,t) denotes a = b + ((a + G(b,c,d) + X[k] + t) <<< s)
; --------------------------------------------------------------------------

GG                  MACRO       a, b, c, d, X, s, t
                    mov         ebx,        b
                    mov         ecx,        c
                    mov         edx,        d
                    IFDEF          __NOPROCS
                      G           
                    ELSE        
                      call        G
                    ENDIF       
                    add       eax, a
                    add       eax, X
                    add   eax,  t
                    rol       eax, s
                    IFDEF          __SAVEEBX
                      add       eax,      ebx
                    ELSE        
                      add       eax, b
                    ENDIF       
                    mov         a,  eax
                  ENDM        

S21               EQU           5
S22               EQU           9
S23               EQU           14
S24               EQU           20

; - Auxiliary function H(x,y,z)=x xor y xor z ------------------------------
                    
                    IFDEF          __NOPROCS
H                      MACRO     
                    ELSE        
H                      PROC      NEAR
                    ENDIF       
                    mov         eax,        ebx
                    xor         eax,        ecx
                    xor         eax,        edx
                    IFDEF          __NOPROCS
                    ENDM        
                    ELSE        
                      ret         
H                     ENDP      
                    ENDIF       

; --------------------------------------------------------------------------
; HH(a,b,c,d,X[k],s,t) denotes a = b + ((a + H(b,c,d) + X[k] + t) <<< s)
; --------------------------------------------------------------------------

HH                  MACRO       a, b, c, d, X, s, t
                      mov       ebx, b
                      mov       ecx, c
                      mov       edx, d
                    IFDEF       __NOPROCS
                      H            
                    ELSE        
                      call      H 
                    ENDIF       
                      add       eax, a
                      add       eax, X
                      add       eax, t
                      rol       eax, s
                    IFDEF          __MISCOPT
                      add       eax, ebx
                    ELSE        
                      add       eax, b
                    ENDIF       
                      mov       a, eax
                    ENDM        
                    
S31                   EQU     4
S32                   EQU     11
S33                   EQU     16
S34                   EQU     23

; - Auxiliary function I(x,y,z)=y xor (x v not(z)) -------------------------
                    
                    IFDEF          __NOPROCS
I                     MACRO     
                    ELSE        
I                     PROC      NEAR
                    ENDIF       
                    mov         eax,        edx
                    not         eax
                    or          eax,        ebx
                    xor         eax,        ecx
                    IFDEF          __NOPROCS
                    ENDM        
                    ELSE        
                      ret         
I                     ENDP      
                    ENDIF       

; --------------------------------------------------------------------------
; II(a,b,c,d,X[k],s,t) denotes a = b + ((a + I(b,c,d) + X[k] + t) <<< s)
; --------------------------------------------------------------------------

II                  MACRO       a, b, c, d, X, s, t
                    mov         ebx,        b
                    mov         ecx,        c
                    mov         edx,        d
                  IFDEF          __NOPROCS
                    I           
                  ELSE        
                    call        I
                  ENDIF       
                    add         eax, a
                    add         eax, X
                    add         eax, t
                    rol         eax, s
                 IFDEF          __MISCOPT
                    add         eax, ebx
                 ELSE        
                    add         eax, b
                 ENDIF       
                    mov         a,  eax
                  ENDM        

S41               EQU           6
S42               EQU           10
S43               EQU           15
S44               EQU           21

; - Constant Definitions for MagicConstantTable ----------------------------
; "Here the additive constants t are chosen as follows: In step i, the
;  additive constant is the integer part of 4294967296 times abs(sin(i)),
;  where i is in radians." [MD5-A]

const01             EQU       3614090360
const02             EQU       3905402710 
const03             EQU        606105819  
const04             EQU       3250441966  
const05             EQU       4118548399 
const06             EQU       1200080426 
const07             EQU       2821735955 
const08             EQU       4249261313
const09             EQU       1770035416 
const10             EQU       2336552879
const11             EQU       4294925233
const12             EQU       2304563134 
const13             EQU       1804603682 
const14             EQU       4254626195 
const15             EQU       2792965006 
const16             EQU       1236535329 
const17             EQU       4129170786 
const18             EQU       3225465664 
const19             EQU        643717713   
const20             EQU       3921069994 
const21             EQU       3593408605
const22             EQU         38016083  
const23             EQU       3634488961 
const24             EQU       3889429448 
const25             EQU        568446438  
const26             EQU       3275163606 
const27             EQU       4107603335  
const28             EQU       1163531501  
const29             EQU       2850285829  
const30             EQU       4243563512 
const31             EQU       1735328473 
const32             EQU       2368359562 
const33             EQU       4294588738  
const34             EQU       2272392833 
const35             EQU       1839030562  
const36             EQU       4259657740 
const37             EQU       2763975236 
const38             EQU       1272893353
const39             EQU       4139469664   
const40             EQU       3200236656     
const41             EQU        681279174    
const42             EQU       3936430074    
const43             EQU       3572445317   
const44             EQU         76029189    
const45             EQU       3654602809    
const46             EQU       3873151461  
const47             EQU        530742520     
const48             EQU       3299628645         
const49             EQU       4096336452        
const50             EQU       1126891415       
const51             EQU       2878612391           
const52             EQU       4237533241      
const53             EQU       1700485571   
const54             EQU       2399980690 
const55             EQU       4293915773  
const56             EQU       2240044497   
const57             EQU       1873313359  
const58             EQU       4264355552   
const59             EQU       2734768916   
const60             EQU       1309151649  
const61             EQU       4149444226 
const62             EQU       3174756917  
const63             EQU        718787259    
const64             EQU       3951481745  

; - Temporary Registers: ---------------------------------------------------
                    
                    IFNDEF      __LOCALVARS
AA                    LABEL     DWORD
                      DD          (?)
BB                    LABEL     DWORD
                      DD          (?)
CC                    LABEL     DWORD
                      DD          (?)
DD0                   LABEL     DWORD
                      DD          (?)
                    ENDIF       

; - Initializate Digest: ---------------------------------------------------
                 
                 IFNDEF __TRANSFORMONLY
; if __TRANSFORMONLY defined, no MD5Init routine will assembled.
                    PUBLIC      PASCAL MD5Init
MD5Init             PROC        PASCAL FAR digest: DWORD
                    IFDEF     __COPYINIT
                      push      ds
                      mov       ax,       cs
                      mov       ds,       ax
                      mov       si,       OFFSET initial_values
                    ENDIF       
                    les         di,       digest
                    IFNDEF    __COPYINIT
                      mov       A,      67452301h
                      mov       B,     0EFCDAB89h
                      mov       C,      98BADCFEh
                      mov       D,      10325476h
                     IFDEF    __CONTEXT 
                      mov     ctxlobits, 0
                      mov     ctxhibits, 0  
                     ENDIF
                    ELSE 
                     IFDEF    __CONTEXT 
                      mov       cx,     6
                     ELSE
                      mov       cx,     4
                     ENDIF
                      cld         
                      rep         movsd
                      pop         ds
                    ENDIF       
                    ret        
                    
                    IFDEF       __COPYINIT or __CONTEXT
initial_values      LABEL     DWORD
  DD                  67452301h
  DD                 0EFCDAB89h
  DD                  98BADCFEh
  DD                  10325476h
IFDEF __CONTEXT
  DD  2 DUP (?)         
ENDIF
                    ENDIF

MD5Init             ENDP

; - Update Context Buffer: -------------------------------------------------

                    PUBLIC      PASCAL MD5Update
MD5Update           PROC        PASCAL FAR ctx: DWORD, buff: DWORD, len: WORD
                    push        ds
                    lds         si,     buff
                    les         di,     ctx
 @0:                cmp         len,    0
                    jz          SHORT   @3
                    mov         eax,    ctxlobits
                    shr         eax,    3
                    and         ax,     3Fh
                    mov         cx,     40h
                    sub         cx,     ax
                    cmp         cx,     len
                    jna         SHORT @1
                    mov         cx,    len
 @1:                sub         len,   cx
                    mov         bx,    ax
                    mov         ax,    cx
                    and         eax,   0FFFFh
                    shl         eax,    3
                    add         ctxlobits, eax
                    adc         ctxhibits, 0  
                    mov         dx,     di
                    add         di,     24
                    add         di,     bx
                    add         bx,     cx
                    MCPY
                    mov         di,     dx
                    cmp         bx,     40h
                    jnz         SHORT @2
                    XFORM
 @2:                jmp         SHORT @0
 @3:                   
                    pop          ds
                    ret
MD5Update           ENDP

; - Wrap-up Context Buffer: ------------------------------------------------

                    PUBLIC      PASCAL MD5Final
MD5Final            PROC        PASCAL FAR digest: DWORD, ctx: DWORD
                    push        ds
                    les         di,     ctx
                    mov         eax,    ctxlobits
                    shr         eax,    3
                    and         ax,     3Fh
                    mov         bx,     ax
                    mov         dx,     di
                    add         di,     24
                    add         di,     bx
                    mov         al,     80h
                    cld
                    stosb
                    inc         bx
                    mov         cx,     40h
                    sub         cx,     bx
                    cmp         bx,     38h
                    jb          SHORT @4
                    MSET
                    mov         di,     dx
                    XFORM
                    add         di,     24
                    mov         cx,     38h             
 @4:                MSET
                    mov         di,     dx
                    STOR        ctxlofin, ctxlobits
                    STOR        ctxhifin, ctxhibits
                    XFORM
                    mov         si,     di
                    mov         ax,     es
                    mov         ds,     ax
                    les         di,     digest
                    mov         cx,     16
                    MCPY
                    mov         es,     ax        ; wipe buffer in case
                    mov         di,     dx        ; there is anything
                    mov         cx,     (16+8+64) ; sensitive
                    MSET
                    pop         ds
                    ret
MD5Final            ENDP

                 ENDIF

; - MD5 Transformation: ----------------------------------------------------

                    PUBLIC      PASCAL MD5Transform
MD5Transform        PROC        PASCAL FAR hashdata: DWORD,digest: DWORD
                  IFDEF          __LOCALVARS
                    LOCAL       AA: DWORD, BB: DWORD, CC: DWORD, DD0: DWORD
                  ENDIF       
                    push        ds
                    IFDEF          __NOSTOR
                      lds         si,       digest
                      IFDEF          __LOCALVARS
                        lea         di,     OFFSET AA
                        mov         ax,     ss
                      ELSE        
                        mov         di,     OFFSET AA
                        mov         ax,     cs
                      ENDIF       
                      mov         es,       ax
                      mov         cx,       4
                      cld         
                      rep         movsd
                    ENDIF       
                    lds         si,         hashdata      ; *data[64]
                    les         di,         digest        ; *hash[16]
                    IFNDEF         __NOSTOR
                      STOR        AA,       A             ;
                      STOR        BB,       B
                      STOR        CC,       C
                      STOR        DD0,      D
                    ENDIF
; -Round 1 -----------------------------------------------------------------
                    FF          A, B, C, D, X.[4*0], S11, const01
                    FF          D, A, B, C, X.[4*1], S12, const02
                    FF          C, D, A, B, X.[4*2], S13, const03
                    FF          B, C, D, A, X.[4*3], S14, const04
                    FF          A, B, C, D, X.[4*4], S11, const05
                    FF          D, A, B, C, X.[4*5], S12, const06
                    FF          C, D, A, B, X.[4*6], S13, const07
                    FF          B, C, D, A, X.[4*7], S14, const08
                    FF          A, B, C, D, X.[4*8], S11, const09
                    FF          D, A, B, C, X.[4*9], S12, const10
                    FF          C, D, A, B, X.[4*10], S13, const11
                    FF          B, C, D, A, X.[4*11], S14, const12
                    FF          A, B, C, D, X.[4*12], S11, const13
                    FF          D, A, B, C, X.[4*13], S12, const14
                    FF          C, D, A, B, X.[4*14], S13, const15
                    FF          B, C, D, A, X.[4*15], S14, const16
; - Round 2 ----------------------------------------------------------------
                    GG          A, B, C, D, X.[4*1], S21, const17
                    GG          D, A, B, C, X.[4*6], S22, const18
                    GG          C, D, A, B, X.[4*11], S23, const19
                    GG          B, C, D, A, X.[4*0], S24, const20
                    GG          A, B, C, D, X.[4*5], S21, const21
                    GG          D, A, B, C, X.[4*10], S22, const22
                    GG          C, D, A, B, X.[4*15], S23, const23
                    GG          B, C, D, A, X.[4*4], S24, const24
                    GG          A, B, C, D, X.[4*9], S21, const25
                    GG          D, A, B, C, X.[4*14], S22, const26
                    GG          C, D, A, B, X.[4*3], S23, const27
                    GG          B, C, D, A, X.[4*8], S24, const28
                    GG          A, B, C, D, X.[4*13], S21, const29
                    GG          D, A, B, C, X.[4*2], S22, const30
                    GG          C, D, A, B, X.[4*7], S23, const31
                    GG          B, C, D, A, X.[4*12], S24, const32
; - Round 3 ----------------------------------------------------------------
                    HH          A, B, C, D, X.[4*5], S31, const33
                    HH          D, A, B, C, X.[4*8], S32, const34
                    HH          C, D, A, B, X.[4*11], S33, const35
                    HH          B, C, D, A, X.[4*14], S34, const36
                    HH          A, B, C, D, X.[4*1], S31, const37
                    HH          D, A, B, C, X.[4*4], S32, const38
                    HH          C, D, A, B, X.[4*7], S33, const39
                    HH          B, C, D, A, X.[4*10], S34, const40
                    HH          A, B, C, D, X.[4*13], S31, const41
                    HH          D, A, B, C, X.[4*0], S32, const42
                    HH          C, D, A, B, X.[4*3], S33, const43
                    HH          B, C, D, A, X.[4*6], S34, const44
                    HH          A, B, C, D, X.[4*9], S31, const45
                    HH          D, A, B, C, X.[4*12], S32, const46
                    HH          C, D, A, B, X.[4*15], S33, const47
                    HH          B, C, D, A, X.[4*2], S34, const48
; - Round 4 ----------------------------------------------------------------
                    II          A, B, C, D, X.[4*0], S41, const49
                    II          D, A, B, C, X.[4*7], S42, const50
                    II          C, D, A, B, X.[4*14], S43, const51
                    II          B, C, D, A, X.[4*5], S44, const52
                    II          A, B, C, D, X.[4*12], S41, const53
                    II          D, A, B, C, X.[4*3], S42, const54
                    II          C, D, A, B, X.[4*10], S43, const55
                    II          B, C, D, A, X.[4*1], S44, const56
                    II          A, B, C, D, X.[4*8], S41, const57
                    II          D, A, B, C, X.[4*15], S42, const58
                    II          C, D, A, B, X.[4*6], S43, const59
                    II          B, C, D, A, X.[4*13], S44, const60
                    II          A, B, C, D, X.[4*4], S41, const61
                    II          D, A, B, C, X.[4*11], S42, const62
                    II          C, D, A, B, X.[4*2], S43, const63
                    II          B, C, D, A, X.[4*9], S44, const64
; --------------------------------------------------------------------------
                    ADDD        A, AA   ;
                    ADDD        B, BB
                    ADDD        C, CC
                    ADDD        D, DD0
                    pop         ds      ;
                    ret         
MD5Transform        ENDP

                  END         
