{============================================================================

  MD4.PAS v2.2, Message Digest 5 Cipher Transform (20 January 1995)
  (C) Copyright 1994-1995 Robert Rothenburg Walking-Owl

    History: 1.0    Original release (Oct 94)
             2.0    ASM and PAS code rewritten entirely for OOP (Jan 95).
             2.1    MD4 object optimized for speed.
             2.1.1  Fixed bug in MD4 object Final routine.
             2.2.0  ASM code written to use MDContext record. OOP abandoned
                    for "compatability" with C implementations.

  Requires MD4.ASM v2.2.0 or later (for 386 machines). Units may work for
  earlier versions of Turbo Pascal which support objects.

  The author can be contacted via e-mail at <rrothenb@ic.sunysb.edu>
  or surface mail at P.O.Box 1327, Stony Brook, NY, 11790 USA.
  
== License and (Non)Warranty Information ===================================

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or 
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
===========================================================================}
unit MD4;
{$undef __ExtdendedMD4}

interface

type

  MDContext = record
      buf:  Array [0..15] of Byte; { MD4 Context  }
      bits: Array [0..7] of Byte;  { bit-count    }
      inb:  Array [0..63] of Byte; { input buffer }
    end;
{$ifdef __ExtdendedMD4}
  MDContext256 = record
      buf:  Array [0..32] of Byte; { MD4 Context  }
      bits: Array [0..7] of Byte;  { bit-count    }
      inb:  Array [0..63] of Byte; { input buffer }
    end;
{$endif}

procedure MD4Init(var ctx: MDContext); far;
procedure MD4Update(var ctx: MDContext; var buff; len: word); far;
procedure MD4Final(var digest; var ctx: MDContext); far;
procedure MD4Transform(var inb, buf); far;

procedure MD4File(var f: file; var digest);  { Assumes file is open }
procedure MD4Buff(var buff; len: word; var digest);

{$ifdef __ExtdendedMD4}
procedure MD4_256Init(var ctx: MDContext256); far;
procedure MD4_256Update(var ctx: MDContext256; var buff; len: word); far;
procedure MD4_256Final(var digest; var ctx: MDContext256); far;
procedure MD4_256Transform(var inb, buf); far;

procedure MD4_256File(var f: file; var digest);  { Assumes file is open }
procedure MD4_256Buff(var buff; len: word; var digest);
{$endif}

implementation

procedure MD4Init(var ctx: MDContext); external; {$l MD4}
procedure MD4Update(var ctx: MDContext; var buff; len: word); external;
procedure MD4Final(var digest; var ctx: MDContext); external;
procedure MD4Transform(var inb, buf); external;

procedure MD4File(var f: file; var digest); { MD4 of file }
var
  ctx: MDContext;
  i:   Word;
  inb: Array [0..4195] of Byte;
begin
  MD4Init(ctx);
  repeat
    BlockRead(f,inb,SizeOf(inb),i);
    if i<>0 then MD4Update(ctx,inb,i);
  until (i=0);
  MD4Final(digest,ctx);
end;

procedure MD4Buff(var buff; len: word; var digest); { MD4 of buffer }
var
  ctx: MDContext;
begin
  MD4Init(ctx);
  MD4Update(ctx,buff,len);
  MD4Final(digest,ctx);
end;

{$ifdef __ExtdendedMD4}
procedure MD4_256Init(var ctx: MDContext256); external; {$l MD4_256}
procedure MD4_256Update(var ctx: MDContext256; var buff; len: word); external;
procedure MD4_256Final(var digest; var ctx: MDContext256); external;
procedure MD4_256Transform(var inb, buf); external;

procedure MD4_256File(var f: file; var digest); { MD4_256 of file }
var
  ctx: MDContext256;
  i:   Word;
  inb: Array [0..4195] of Byte;
begin
  MD4_256Init(ctx);
  repeat
    BlockRead(f,inb,SizeOf(inb),i);
    if i<>0 then MD4_256Update(ctx,inb,i);
  until (i=0);
  MD4_256Final(digest,ctx);
end;

procedure MD4_256Buff(var buff; len: word; var digest); { MD4_256 of buffer }
var
  ctx: MDContext256;
begin
  MD4_256Init(ctx);
  MD4_256Update(ctx,buff,len);
  MD4_256Final(digest,ctx);
end;
{$endif}

end.



