{============================================================================

  HAVAL.PAS v1.0, Haval Message Digest Transform (22 January 1995)
  (C) Copyright 1995 Robert Rothenburg Walking-Owl

    History: 1.0    Original release (Jan 95)

  The author can be contacted via e-mail at <rrothenb@ic.sunysb.edu>
  or surface mail at P.O.Box 1327, Stony Brook, NY, 11790 USA.
  
== License and (Non)Warranty Information ===================================

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or 
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
===========================================================================}
unit Haval;

interface

type

  HavalState = record
      buf:  Array [0..31] of Byte;  { Haval Context  }
      bits: Array [0..7] of Byte;   { bit-count    }
      inb:  Array [0..127] of Byte; { input buffer }
    end;

procedure HavalInit(var ctx: HavalState); far;
procedure HavalUpdate(var ctx: HavalState; var buff; len: word); far;
procedure HavalFinal(var digest; fptlen: word; var ctx: HavalState); far;
procedure HavalTransform(var inb, buf); far;

procedure HavalFile(var f: file; var digest; fptlen: word);
procedure HavalBuff(var buff; len: word; var digest; fptlen: word);

{ Note: "fptlen" = fingerprint length in bits, either 128, 160, 192, 224 or }
{       256 bits.  The value will differ depending on the number of passes  }
{       the HavalTransform makes (which at the moment is hardcoded into the }
{       software--future variations may allow for the number of passes to   }
{       be given at run time...                                             }

implementation

procedure HavalInit(var ctx: HavalState); external; {$l Haval}
procedure HavalUpdate(var ctx: HavalState; var buff; len: word); external;
procedure HavalFinal(var digest; fptlen: word; var ctx: HavalState); external;
procedure HavalTransform(var inb, buf); external;

procedure HavalFile(var f: file; var digest; fptlen: word); { Haval of file }
var
  ctx: HavalState;
  i:   Word;
  inb: Array [0..4195] of Byte;
begin
  HavalInit(ctx);
  repeat
    BlockRead(f,inb,SizeOf(inb),i);
    if i<>0 then HavalUpdate(ctx,inb,i);
  until (i=0);
  HavalFinal(digest,fptlen,ctx);
end;

procedure HavalBuff(var buff; len: word; var digest; fptlen: word); { Haval of buffer }
var
  ctx: HavalState;
begin
  HavalInit(ctx);
  HavalUpdate(ctx,buff,len);
  HavalFinal(digest,fptlen,ctx);
end;

end.



