; =========================================================================
; MemFill.Asm (c) Copyright 1994 Robert Rothenburg Walking-Owl (27 Nov 94)
; =========================================================================
; 32-bit memory fill routine for Turbo Pascal as a fast replacement for                    
; the FillChar() procedure. (Derived from the FastMem.Pas 3.2b unit.)
                    
                    .386        
                    
threshold           equ         8

code                segment     byte public use16
                    assume      cs: code

; =========================================================================
; procedure MemFill(var block; size: word; chr: byte);
; =========================================================================
                    public      memfill
memfill             proc        far
                    push        bp
                    mov         bp,         sp
                    les         di,         [bp+0ah]
                    mov         cx,         [bp+08h]
                    mov         al,         [bp+06h]
                    mov         ah,         al
                    call        _fill
                    pop         bp
                    ret         08h
memfill             endp        

; =========================================================================
; Fill routine       
; =========================================================================
                    public      _fill
_fill               proc        near
                    cld                                     ;
                    mov         ah,         al              ;
                    cmp         cx,         threshold
                    jnb         short fill32
fill16:             
                    shr         cx,         1
                    rep         stosw
                    adc         cx,         0
                    rep         stosb
                    ret         
fill32:             
                    test        di,         11b             ;
                    jz          short aligned_fill
;                   push        dx
                    mov         dx,         cx
                    mov         cx,         di
                    and         cx,         11b
                    neg         cx
                    add         cx,         4
                    sub         dx,         cx
                    rep         stosb
                    mov         cx,         dx
;                   pop         dx
aligned_fill:       
                    mov         dx,         ax
                    shl         eax,        16
                    mov         ax,         dx
                    shr         cx,         1
                    jnc         short noodb
                    stosb       
noodb:              shr         cx, 1
                    jnc         short noodw
                    stosw       
noodw:              rep         stosd
                    ret         
_fill               endp        
code                ends        
                  end         

