#include "x8.h"

#define rho_len 19
#define pi_len 17
#define e_len 23

extern BYTE pi_3[];
extern BYTE e_2[];
extern BYTE rho_1[];

void fill_S(BYTE PTR table, BYTE *perm, int len);
unsigned bdiv(BYTE PTR bint, unsigned d, int len);
void makeroundkeys(BYTE PTR table,BYTE PTR roundkeys,int roundcnt);

void setpassword(int method,BYTE PTR table,BYTE PTR roundkeys,
					char *password,int passsize,int roundcnt)
{
int i,j,k;
BYTE PTR temp;
char zero=0;

/* use the inverse as temporary storage */
temp=&table[table_size];
/* if the key is length zero password[0]=0 required */
if (passsize==0) password=&zero;

/* create initial table permutation as pseudo random number */
for (i=0,j=0,k=0; i<table_size; i++)
	{
	temp[i]=pi_3[j++]^e_2[k++];
	if (j==pi_len) j=0;
	if (k==e_len) k=0;
	}
/* use the initial permutation to fill the table */
fill_S(table,temp,table_size);
if (method==m_M8)makeroundkeys(table,roundkeys,roundcnt);

/* make the password and length into a permutation/psuedo random number */
for (i=1,j=0,k=1,temp[0]=passsize^rho_1[0]; i<256; i++)
	{
	temp[i]=((BYTE)password[j++])^rho_1[k++];
	if (j>=passsize) j=0;	/* if the passsize=0, always use password[0] */
	if (k==rho_len) k=0;
	}
/* encrypt the psuedo random key with initial table */
encrypt(method,table,roundkeys,temp,table_size,roundcnt);
/* use the encrypted key to fill the real array */
fill_S(table,temp,table_size);
if (method==m_M8)makeroundkeys(table,roundkeys,roundcnt);

/* invert the table */
for (i=0;i<table_size;i++)
	temp[table[i]]=i;
}

/* fill the table from a permutation using the swap shuffling method */
/* all permutations are possible */
void fill_S(BYTE PTR table, BYTE PTR perm, int len)
{
int i;
BYTE temp;
unsigned m;

/* create the initial table */
for (i=0;i<table_size;i++) table[i]=i;
/* for each element */
for (i=table_size;i>1;i--)
	{
	m=bdiv(perm,i,len);		/* get the permutation */
	while (perm[len-1]==0) len--;		/* shorten perm length to discard zeros */
	temp=table[table_size-i];			/* swap element i and m */
	/* element m is from the elements i and up */
	table[table_size-i]=table[table_size-i+m];
	table[table_size-i+m]=temp;
	}
}

/* divide bint by d using long division method */
/* bint consists of len bytes */
/* result in bint */
/* remainder returned */
/* MUCH faster in assembly */
unsigned bdiv(BYTE PTR bint, unsigned d, int len)
{
int i;
unsigned m=0,u;

for (i=len-1;i>=0;i--)
	{
	u = (m<<8) + bint[i];
	m = u%d;
	bint[i]=u/d;
	}
return m;
}

void makeroundkeys(BYTE PTR table,BYTE PTR roundkeys,int roundcnt)
{
int i;

for (i=0;i<roundcnt;i++)
	{
	roundkeys[i<<1]=table[table[i]^e_2[0]];
	roundkeys[(i<<1)+1]=table[table[i]^e_2[1]];
	}
}
