/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */

#include "StrngLst.h"
#include "IniFile.h"
#include <stdlib.h>
#include <stdio.h>


int main(int argc, char *argv[]) {
  int i;
  int j;
  StringList sl;
  FILE * inif;
  int val;

  fprintf(stdout, "Testing string-list.  First with duplicates allowed...\n");

  sl.Sorted = true;
  sl.DuplicatesAllowed = true;

  sl.AddItem("One");
  sl.AddItem("Two");
  sl.AddItem("Three");
  sl.AddItem("Four");
  sl.AddItem("Five");
  sl.AddItem("Six");
  sl.AddItem("Seven");
  sl.AddItem("Eight");
  sl.AddItem("Nine");
  sl.AddItem("Ten");
  sl.AddItem("Eleven");
  sl.AddItem("Twelve");
  sl.AddItem("Thirteen");
  sl.AddItem("Fourteen");
  sl.AddItem("Five");
  sl.AddItem("Fourteen");
  sl.AddItem("Fifteen");
  sl.AddItem("Sixteen");
  sl.AddItem("Seventeen");
  sl.AddItem("Eighteen");
  sl.AddItem("Nineteen");
  sl.AddItem("Twenty");

  for (i=0; i<sl.Count(); i++) {
    fprintf(stdout, "%d: %s\n", i, sl[i]);
  };

  fprintf(stdout, "IndexOf \"One\": %d\n", sl.IndexOf("One"));
  if (sl.IndexOf("One") != 11) goto fail;
  
  fprintf(stdout, "IndexOf \"Two\": %d\n", sl.IndexOf("Two"));
  if (sl.IndexOf("Two") != 21) goto fail;

  fprintf(stdout, "IndexOf \"Three\": %d\n", sl.IndexOf("Three"));
  if (sl.IndexOf("Three") != 18) goto fail;

  fprintf(stdout, "IndexOf \"Four\": %d\n", sl.IndexOf("Four"));
  if (sl.IndexOf("Four") != 6) goto fail;

  fprintf(stdout, "IndexOf \"Five\": %d\n", sl.IndexOf("Five"));
  if (sl.IndexOf("Five") != 4) goto fail;

  fprintf(stdout, "IndexOf \"Six\": %d\n", sl.IndexOf("Six"));
  if (sl.IndexOf("Six") != 14) goto fail;

  fprintf(stdout, "IndexOf \"Seven\": %d\n", sl.IndexOf("Seven"));
  if (sl.IndexOf("Seven") != 12) goto fail;

  fprintf(stdout, "IndexOf \"Eight\": %d\n", sl.IndexOf("Eight"));
  if (sl.IndexOf("Eight") != 0) goto fail;

  fprintf(stdout, "IndexOf \"Nine\": %d\n", sl.IndexOf("Nine"));
  if (sl.IndexOf("Nine") != 9) goto fail;

  fprintf(stdout, "IndexOf \"Ten\": %d\n", sl.IndexOf("Ten"));
  if (sl.IndexOf("Ten") != 16) goto fail;

  fprintf(stdout, "IndexOf \"Eleven\": %d\n", sl.IndexOf("Eleven"));
  if (sl.IndexOf("Eleven") != 2) goto fail;

  fprintf(stdout, "IndexOf \"Twelve\": %d\n", sl.IndexOf("Twelve"));
  if (sl.IndexOf("Twelve") != 19) goto fail;

  fprintf(stdout, "IndexOf \"Thirteen\": %d\n", sl.IndexOf("Thirteen"));
  if (sl.IndexOf("Thirteen") != 17) goto fail;

  fprintf(stdout, "IndexOf \"Fourteen\": %d\n", sl.IndexOf("Fourteen"));
  if (sl.IndexOf("Fourteen") != 7) goto fail;

  fprintf(stdout, "IndexOf \"Fifteen\": %d\n", sl.IndexOf("Fifteen"));
  if (sl.IndexOf("Fifteen") != 3) goto fail;

  fprintf(stdout, "IndexOf \"Sixteen\": %d\n", sl.IndexOf("Sixteen"));
  if (sl.IndexOf("Sixteen") != 15) goto fail;

  fprintf(stdout, "IndexOf \"Seventeen\": %d\n", sl.IndexOf("Seventeen"));
  if (sl.IndexOf("Seventeen") != 13) goto fail;

  fprintf(stdout, "IndexOf \"Eighteen\": %d\n", sl.IndexOf("Eighteen"));
  if (sl.IndexOf("Eighteen") != 1) goto fail;

  fprintf(stdout, "IndexOf \"Nineteen\": %d\n", sl.IndexOf("Nineteen"));
  if (sl.IndexOf("Nineteen") != 10) goto fail;

  fprintf(stdout, "IndexOf \"Twenty\": %d\n", sl.IndexOf("Twenty"));
  if (sl.IndexOf("Twenty") != 20) goto fail;


  fprintf(stdout, "\n\n");
  fprintf(stdout, "Now, suppressing duplicates...\n");
 
    sl.DuplicatesAllowed = false;

  for (i=0; i<sl.Count(); i++) {
    fprintf(stdout, "%d: %s\n", i, sl[i]);
  };


  
  fprintf(stdout, "IndexOf \"One\": %d\n", sl.IndexOf("One"));
  if (sl.IndexOf("One") != 9) goto fail;
  
  fprintf(stdout, "IndexOf \"Two\": %d\n", sl.IndexOf("Two"));
  if (sl.IndexOf("Two") != 19) goto fail;

  fprintf(stdout, "IndexOf \"Three\": %d\n", sl.IndexOf("Three"));
  if (sl.IndexOf("Three") != 16) goto fail;

  fprintf(stdout, "IndexOf \"Four\": %d\n", sl.IndexOf("Four"));
  if (sl.IndexOf("Four") != 5) goto fail;

  fprintf(stdout, "IndexOf \"Five\": %d\n", sl.IndexOf("Five"));
  if (sl.IndexOf("Five") != 4) goto fail;

  fprintf(stdout, "IndexOf \"Six\": %d\n", sl.IndexOf("Six"));
  if (sl.IndexOf("Six") != 12) goto fail;

  fprintf(stdout, "IndexOf \"Seven\": %d\n", sl.IndexOf("Seven"));
  if (sl.IndexOf("Seven") != 10) goto fail;

  fprintf(stdout, "IndexOf \"Eight\": %d\n", sl.IndexOf("Eight"));
  if (sl.IndexOf("Eight") != 0) goto fail;

  fprintf(stdout, "IndexOf \"Nine\": %d\n", sl.IndexOf("Nine"));
  if (sl.IndexOf("Nine") != 7) goto fail;

  fprintf(stdout, "IndexOf \"Ten\": %d\n", sl.IndexOf("Ten"));
  if (sl.IndexOf("Ten") != 14) goto fail;

  fprintf(stdout, "IndexOf \"Eleven\": %d\n", sl.IndexOf("Eleven"));
  if (sl.IndexOf("Eleven") != 2) goto fail;

  fprintf(stdout, "IndexOf \"Twelve\": %d\n", sl.IndexOf("Twelve"));
  if (sl.IndexOf("Twelve") != 17) goto fail;

  fprintf(stdout, "IndexOf \"Thirteen\": %d\n", sl.IndexOf("Thirteen"));
  if (sl.IndexOf("Thirteen") != 15) goto fail;

  fprintf(stdout, "IndexOf \"Fourteen\": %d\n", sl.IndexOf("Fourteen"));
  if (sl.IndexOf("Fourteen") != 6) goto fail;

  fprintf(stdout, "IndexOf \"Fifteen\": %d\n", sl.IndexOf("Fifteen"));
  if (sl.IndexOf("Fifteen") != 3) goto fail;

  fprintf(stdout, "IndexOf \"Sixteen\": %d\n", sl.IndexOf("Sixteen"));
  if (sl.IndexOf("Sixteen") != 13) goto fail;

  fprintf(stdout, "IndexOf \"Seventeen\": %d\n", sl.IndexOf("Seventeen"));
  if (sl.IndexOf("Seventeen") != 11) goto fail;

  fprintf(stdout, "IndexOf \"Eighteen\": %d\n", sl.IndexOf("Eighteen"));
  if (sl.IndexOf("Eighteen") != 1) goto fail;

  fprintf(stdout, "IndexOf \"Nineteen\": %d\n", sl.IndexOf("Nineteen"));
  if (sl.IndexOf("Nineteen") != 8) goto fail;

  fprintf(stdout, "IndexOf \"Twenty\": %d\n", sl.IndexOf("Twenty"));
  if (sl.IndexOf("Twenty") != 18) goto fail;


  fprintf(stdout, "\n\n");
  
  fprintf(stdout, "Testing inifile...\n");
  {
    StringList sl1, sl2;
    inif = fopen("C:\\TEMP\\Test.INI", "wt");
    fprintf(inif, "First=1\n");
    fprintf(inif, "[MultiplyOne]\n");
    fprintf(inif, "VarOne=1\n");
    fprintf(inif, "VarTwo=2\n");
    fprintf(inif, "VarThree=3\n");
    fprintf(inif, "VarFour=4\n");
    fprintf(inif, "[MultiplyTwo]\n");
    fprintf(inif, "VarOne=1\n");
    fprintf(inif, "VarTwo=2\n");
    fprintf(inif, "VarThree=3\n");
    fprintf(inif, "VarFour=4\n");
    fprintf(inif, "VarFive=5\n");
    fclose(inif);

    IniFile ini("C:\\TEMP\\Test.INI", true);

    ini.getSections(sl1);

    for (i=0; i< sl1.Count(); i++) {
      fprintf(stdout, "Section %d: %s\n", i, sl1[i]);
      ini.getKeys(sl1[i], sl2);
      for (j=0; j< sl2.Count(); j++) {
        fprintf(stdout, "  Var %d: %s\n", j, sl2[j]);
      };
    };

    ini.writeInteger("MultiplyTwo", "VarOne", 2);
    ini.writeInteger("MultiplyTwo", "VarTwo", 4);
    ini.writeInteger("MultiplyTwo", "VarThree", 6);
    ini.writeInteger("MultiplyTwo", "VarFour", 8);
    ini.writeInteger("MultiplyTwo", "VarFive", 10);
    ini.writeInteger("MultiplyTwo", "VarSix", 12);
   
    ini.writeInteger("MultiplyThree", "VarOne", 3);
    ini.writeInteger("MultiplyThree", "VarTwo", 6);
    ini.writeInteger("MultiplyThree", "VarThree", 9);
    ini.writeInteger("MultiplyThree", "VarFour", 12);
    ini.writeInteger("MultiplyThree", "VarFive", 15);
    ini.writeInteger("MultiplyThree", "VarSix", 18);


    if (!ini.readInteger("MultiplyThree", "VarFive", val)) {
      fprintf(stderr, "No value for [MultiplyThree]:VarFive!\n");
      goto fail;
    };
    fprintf(stdout, "[MultiplyThree]:VarFive = %d\n", val);
    if (val != 15) goto fail;


    if (!ini.readInteger("MultiplyOne", "VarOne", val)) {
      fprintf(stderr, "No value for [MultiplyOne]:VarOne!\n");
      goto fail;
    };
    fprintf(stdout, "[MultiplyOne]:VarOne = %d\n", val);
    if (val != 1) goto fail;

    if (!ini.readInteger("MultiplyTwo", "VarOne", val)) {
      fprintf(stderr, "No value for [MultiplyTwo]:VarOne!\n");
      goto fail;
    };
    fprintf(stdout, "[MultiplyTwo]:VarOne = %d\n", val);
    if (val != 2) goto fail;





  };


success:
  fprintf(stdout, "All tests succeeeded\n\n");
  
  return EXIT_SUCCESS;

fail:

  fflush(stdout);
  fprintf(stderr, "Test failed\n");
  return EXIT_FAILURE;
}
