/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */

#include <sys/types.h>
#include <stdlib.h>
#include <stdio.h>
#include <memory.h>
#include <malloc.h>
#include <string.h>
#include <platform.h>
#include <time.h>
#include <miscmsg.h>
#include <tid.h>
#include <JonahIni.h>

#define SEPERATOR_CHAR  ':'
#define UNSPEC_ID       0
#define BUFFER_SZ_INC   16

//
// Transactions IDs are in the format of:
//      time:ee-objstore-key:ee-objstore-key:ra-objstore-key:ca-objstore-key

uint32
tid_create(uint32 ee_key, uint32 ra_key, uint32 ca_key, 
           unsigned char **tid, uint32 *len)
{
  char          *bigtemp;
  char          *temp;
  time_t        now;

  if ((bigtemp = (char *) malloc(BUFSIZ)) == NULL) {
    throw "Out of memory in tid_create";
  }
  now = time(NULL);
  sprintf(bigtemp, "%u%c%u%c%u%c%u", now, SEPERATOR_CHAR, ee_key, 
          SEPERATOR_CHAR, ra_key, SEPERATOR_CHAR,  ca_key);
  if ((temp = (char *) malloc(strlen(bigtemp) + 1)) == NULL) {
    throw "Out of memory in tid_create";
  }
  strcpy(temp, bigtemp);
  free(bigtemp);
  *tid = (unsigned char *) temp;
  *len = strlen(temp)+1;
  return 0;
}

void
tid_release(unsigned char *tid)
{
  if (tid)
    free(tid);
}

uint32
tid_get_value(unsigned char *tid, tidval_t key, uint32 *value)
{
  uint32        ts, ee, ra, ca;
  if (sscanf((char *) tid, "%d:%d:%d:%d", &ts, &ee, &ra, &ca) != 4) {
    return MISC_MALFORMED_TID;
  }
  switch(key) {
  case TID_TIME:
    *value = ts;
    break;
  case TID_EE:
    *value = ee;
    break;
  case TID_RA:
    *value = ra;
    break;
  case TID_CA:
    *value = ca;
    break;
  default:
    return -1; // XXX
  }
  return 0;
}

uint32
tid_get_key(unsigned char *tid, uint32 *objsid)
{
  uint32        ts, ee, ra, ca;

  if (sscanf((char *) tid, "%d:%d:%d:%d", &ts, &ee, &ra, &ca) != 4) {
    return MISC_MALFORMED_TID;
  }
  if (IniAmICA()) {
    *objsid = ca;
  } else if (IniAmIRA()) {
    *objsid = ra;
  } else {
    *objsid = ee;
  }
  return 0;
}


// Add a new object store key to the transaction ID.
// if there is not a 0 in our field return an error.
// This call well change the contents of tid.

uint32
tid_add_key(unsigned char *tid, uint32 id, unsigned char **newtid, uint32 *len)
{
  char          *tmp;
  char          sbuf[32];
  uint32        ts, ee, ra, ca;

  if (tid == NULL) {
    return MISC_NULL_TID;
  }
  sprintf(sbuf, "%%d%c%%d%c%%d%c%%d", SEPERATOR_CHAR, SEPERATOR_CHAR, 
          SEPERATOR_CHAR);
  if (sscanf((char *) tid, sbuf, &ts, &ee, &ra, &ca) != 4) {
    return MISC_MALFORMED_TID;
  }
  if (IniAmICA()) {
    if (ca == UNSPEC_ID) {
      ca = id;
    } else {
      return MISC_ADD_ID_NOT_EMPTY;
    }
  } else if (IniAmIRA()) {
    if (ra == UNSPEC_ID) {
      ra = id;
    } else {
      return MISC_ADD_ID_NOT_EMPTY;
    }
  } else if (ee == UNSPEC_ID) {
      ee = id;
  } else {
      return MISC_ADD_ID_NOT_EMPTY;
  }
  if ((tmp = (char *) malloc(strlen((char *) tid) + BUFFER_SZ_INC)) == NULL) {
    throw "Out of memory in tid_add_id";
  }
  sprintf(tmp, "%d%c%d%c%d%c%d", ts, SEPERATOR_CHAR, ee, SEPERATOR_CHAR, 
          ra, SEPERATOR_CHAR,  ca);
  *newtid = (unsigned char *)tmp;
  *len = strlen(tmp) +1;
  return 0;
}
