/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */

//
// ASN.1 class defintions for PKIX messages
//

#ifndef _PKIX_MSGS_H_
#define _PKIX_MSGS_H_

#define PKIX_VERSION1	1
#pragma warning(disable:4251) // XXX
#include <asnbase.h>
#include <asnstrng.h>
#include <asnnames.h>
#include <x509.h>
#include <pkcs.h>

typedef x509_certificate	Certificate;
typedef Certificate		OOBCert;
typedef Certificate		CertAnnContent;
typedef asn_null 		PKIConfirmContent;
typedef asn_bitstring		PKIProtection;
typedef asn_any			NestedMessageContent;
typedef asn_bitstring		UniqueIdentifier;
typedef asn_octetstring		KeyIdentifier;
typedef asn_UTF8String		PKIFreeText;
typedef asn_UTF8String		RegToken;
typedef asn_UTF8String		UTF8Pairs;
typedef asn_octetstring		PKIFailureInfo;

typedef asn_octetstring		KeyGenParameters;
typedef SubjectPublicKeyInfo	ProtocolEncrKey;

typedef enum {ENCRCERT, CHALLENGERESP}				submsg_t;
typedef enum {DONTPUBLISH, PLEASEPUBLISH}			pubaction_t;
typedef enum {DONTCARE, X500, WEB, LDAP}			pubmethod_t;
typedef enum {GRANTED, GRANTED_WITH_MODS, REJECTION, WAITING, REVOCATION_WARNING,
	      REVOCATION_NOTIFICATION, KEY_UPDATE_WARNING}	pkistatus_t;

class EXPORTCLASS SubsequentMessage : public asn_integer {
public:
  SubsequentMessage(security_t s = ASN_PUBLIC) : asn_integer(s) {
    strcpy(objType, "SubseqMsg");
  };
  virtual int set_value(submsg_t v) {
    switch (v) {
      case ENCRCERT : return asn_integer::set_value(0l);
      case CHALLENGERESP : return asn_integer::set_value(1l);
    };
    return ASN_INVALID_VALUE;
  };

  virtual int get_value(submsg_t &v) {
    long vi; int res;
    res = asn_integer::get_value(vi);
    if (res != 0) return res;
    switch(vi) {
    case 0:
      v = ENCRCERT;
      break;
    case 1:
      v = CHALLENGERESP; 
      break;
    default:
      return ASN_INVALID_VALUE;
    };
    return 0;
  };
};

class EXPORTCLASS Action : public asn_integer {
public:
  Action(security_t s = ASN_PUBLIC) : asn_integer(s) {
    strcpy(objType, "Action");
  };
  virtual int set_value(pubaction_t v) {
    switch (v) {
      case DONTPUBLISH : return asn_integer::set_value(0l);
      case PLEASEPUBLISH : return asn_integer::set_value(1l);
    };
    return ASN_INVALID_VALUE;
  };

  virtual int get_value(pubaction_t &v) {
    long vi; int res;
    res = asn_integer::get_value(vi);
    if (res != 0) return res;
    switch(vi) {
      case 0 : v = DONTPUBLISH; return 0;
      case 1 : v = PLEASEPUBLISH; return 0;
       };
    return ASN_INVALID_VALUE;
  };
};

class EXPORTCLASS PubMethod : public asn_integer {
public:
  PubMethod(security_t s = ASN_PUBLIC) : asn_integer(s) {
    strcpy(objType, "PubMethod");
  };
  virtual int set_value(pubmethod_t v) {
    switch (v) {
      case DONTCARE : return asn_integer::set_value(0l);
      case X500 : return asn_integer::set_value(1l);
      case WEB : return asn_integer::set_value(2l);
      case LDAP : return asn_integer::set_value(3l);
    };
    return ASN_INVALID_VALUE;
  };

  virtual int get_value(pubmethod_t &v) {
    long vi; int res;
    res = asn_integer::get_value(vi);
    if (res != 0) return res;
    switch(vi) {
      case 0 : v = DONTCARE; return 0;
      case 1 : v = X500; return 0;
      case 2 : v = WEB; return 0;
      case 3 : v = LDAP; return 0;
       };
    return ASN_INVALID_VALUE;
  };
};

class EXPORTCLASS SinglePubInfo : public asn_sequence {
public:
  PubMethod	pubMethod;
  GeneralName	pubLocation;
  SinglePubInfo(security_t s = ASN_PUBLIC) : asn_sequence(s) {
    strcpy(objType, "SinglePubInfo");
    pubLocation.set_optional();
    register_child(&pubMethod);
    register_child(&pubLocation);
  };
};

template class EXPORTCLASS asn_sequenceof<SinglePubInfo>;
class EXPORTCLASS PubInfos : public asn_sequenceof<SinglePubInfo> {
public:
  PubInfos(security_t s = ASN_PUBLIC) : asn_sequenceof<SinglePubInfo> (s) {
    strcpy(objType, "PubInfos");
  };
};

class EXPORTCLASS PKIPublicationInfo : public asn_sequence {
public:
  Action	action;
  PubInfos	pubInfos;
  PKIPublicationInfo(security_t s = ASN_PUBLIC) : asn_sequence(s) {
    strcpy(objType, "PKIPubInfo");
    pubInfos.set_optional();
    register_child(&action);
    register_child(&pubInfos);
  };
};


class EXPORTCLASS  PBMParameter : public asn_sequence {
public:
  asn_octetstring	salt;
  AlgorithmIdentifier	owf;
  asn_integer		iterationCount;
  AlgorithmIdentifier	mac;
  PBMParameter(security_t s = ASN_PUBLIC) : asn_sequence(s) {
      strcpy(objType, "PBMParam");
      register_child(&salt);
      register_child(&owf);
      register_child(&iterationCount);
      register_child(&mac);
  };
};

class EXPORTCLASS DHBMParameter : public asn_sequence {
public:
  AlgorithmIdentifier	owf;
  AlgorithmIdentifier	mac;
  DHBMParameter(security_t s = ASN_PUBLIC) : asn_sequence(s) {
    strcpy(objType, "DHBMParam");
    register_child(&owf);
    register_child(&mac);
  };
};

class EXPORTCLASS PKIStatus : public asn_integer {
public:
  PKIStatus(security_t s = ASN_PUBLIC) : asn_integer(s) {
    strcpy(objType, "PKIstatus");
  };
  virtual int set_value(pkistatus_t v) {
    switch (v) {
    case GRANTED: 
      return asn_integer::set_value(0l);
    case GRANTED_WITH_MODS: 
      return asn_integer::set_value(1l);
    case REJECTION: 
      return asn_integer::set_value(2l);
    case WAITING: 
      return asn_integer::set_value(3l);
    case REVOCATION_WARNING: 
      return asn_integer::set_value(4l);
    case REVOCATION_NOTIFICATION: 
      return asn_integer::set_value(5l);
    case KEY_UPDATE_WARNING: 
      return asn_integer::set_value(6l);
    default:
      return ASN_INVALID_VALUE;
    };
  };
  virtual int get_value(pkistatus_t &v) {
    long vi; int res;
    res = asn_integer::get_value(vi);
    if (res != 0) return res;
    switch(vi) {
    case 0:
      v = GRANTED;
      break;
    case 1:
      v = GRANTED_WITH_MODS;
      break;
    case 2:
      v = REJECTION;
      break;
    case 3:
      v = WAITING;
      break;
    case 4:
      v = REVOCATION_WARNING;
      break;
    case 5:
      v = REVOCATION_NOTIFICATION;
      break;
    case 6:
      v = KEY_UPDATE_WARNING;
      break;
    default:
      return ASN_INVALID_VALUE;
    };
    return 0;
  };
};

class EXPORTCLASS PKIStatusInfo : public asn_sequence {
public:
  PKIStatus		status;
  PKIFreeText		statusString;
  PKIFailureInfo	failInfo;
  PKIStatusInfo(security_t s = ASN_PUBLIC) : asn_sequence(s) {
    strcpy(objType, "PKIStatusInfo");
    statusString.set_optional();
    failInfo.set_optional();
    register_child(&status);
    register_child(&statusString);
    register_child(&failInfo);
  };
};

template class EXPORTCLASS asn_sequenceof<PKIStatusInfo>;
class EXPORTCLASS PKIStatusInfos : public asn_sequenceof<PKIStatusInfo> {
public:
  PKIStatusInfos(security_t s = ASN_PUBLIC) : asn_sequenceof<PKIStatusInfo> (s) {
    strcpy(objType, "PKIStatInfos");
  };
};


class EXPORTCLASS CertId : public asn_sequence {
public:
  GeneralName		issuer;
  asn_integer		serial;
  CertId(security_t s = ASN_PUBLIC) : asn_sequence(s) {
    strcpy(objType, "CertId");
    register_child(&issuer);
    register_child(&serial);
  };
};

template class EXPORTCLASS asn_sequenceof<CertId>;
class EXPORTCLASS CertIds : public asn_sequenceof<CertId> {
public:
  CertIds(security_t s = ASN_PUBLIC) : asn_sequenceof<CertId> (s) {
    strcpy(objType, "CertIds");
  };
};

class EXPORTCLASS OOBCertHash : public asn_sequence { 
public:
  asn_explicit<AlgorithmIdentifier, CLASS_CONTEXT_SPECIFIC, 0>	hashAlg;
  asn_explicit<CertId, CLASS_CONTEXT_SPECIFIC, 1> 		certId;
  asn_bitstring							hashVal;
  OOBCertHash(security_t s = ASN_PUBLIC) : asn_sequence(s) {
    strcpy(objType, "OOBCertHash");
    hashAlg.set_optional();
    certId.set_optional();
    register_child(&hashAlg);
    register_child(&certId);
    register_child(&hashVal);
  };
};


class EXPORTCLASS Random : public asn_sequence { 
public:
  asn_integer		integer;
  GeneralName		sender;
  Random(security_t s = ASN_PUBLIC) : asn_sequence(s) {
    strcpy(objType, "Random");
    register_child(&integer);
    register_child(&sender);
  };
};

class EXPORTCLASS Challenge : public asn_sequence { 
public:
  AlgorithmIdentifier	owf;
  asn_octetstring	witness;
  asn_octetstring	challenge;
  Random		Rand;
  Challenge(security_t s = ASN_PUBLIC) : asn_sequence(s) {
    strcpy(objType, "Challenge");
    owf.set_optional();
    register_child(&owf);
    register_child(&witness);
    register_child(&challenge);
    register_child(&Rand);
  };
};

template class EXPORTCLASS asn_sequenceof<Challenge>;
class EXPORTCLASS POPODecKeyChallContent : public asn_sequenceof<Challenge> {
public:
  POPODecKeyChallContent(security_t s = ASN_PUBLIC) : asn_sequenceof<Challenge> (s) {
    strcpy(objType, "POPODKChalCont");
  };
};

class EXPORTCLASS POPODecKeyRespContent : public asn_sequenceof<asn_integer> {
public:
  POPODecKeyRespContent(security_t s = ASN_PUBLIC) : asn_sequenceof<asn_integer> (s) {
    strcpy(objType, "POPODKRespCont");
  };
};


class EXPORTCLASS Certificates : public asn_sequenceof<Certificate> {
public:
  Certificates(security_t s = ASN_PUBLIC) : asn_sequenceof<Certificate> (s) {
    strcpy(objType, "Certificates");
  };
};

class EXPORTCLASS EncryptedValue : public asn_sequence {
public:
  asn_explicit<AlgorithmIdentifier, CLASS_CONTEXT_SPECIFIC, 0>	intendedAlg;
  asn_explicit<AlgorithmIdentifier, CLASS_CONTEXT_SPECIFIC, 1>	symmAlg;
  asn_explicit<asn_bitstring, CLASS_CONTEXT_SPECIFIC, 2>	encSymmKey;
  asn_explicit<AlgorithmIdentifier, CLASS_CONTEXT_SPECIFIC, 3>	keyAlg;
  asn_explicit<asn_octetstring, CLASS_CONTEXT_SPECIFIC, 4>	valueHint;
  asn_bitstring							encValue;
  EncryptedValue(security_t s = ASN_PUBLIC) : asn_sequence(s) {
    strcpy(objType, "EncValue");
    intendedAlg.set_optional();
    symmAlg.set_optional();
    keyAlg.set_optional();
    valueHint.set_optional();
    register_child(&intendedAlg);
    register_child(&symmAlg);
    register_child(&keyAlg);
    register_child(&valueHint);
    register_child(&encValue);
  };
};

class EXPORTCLASS CertOrEncCert : public asn_choice {
public:
  asn_explicit<Certificate, CLASS_CONTEXT_SPECIFIC, 0>	   certificate;
  asn_explicit<EncryptedValue, CLASS_CONTEXT_SPECIFIC, 1>  encryptedCert;
  CertOrEncCert(security_t s = ASN_PUBLIC) {
    strcpy(objType, "CertorEncCert");
    register_child(&certificate);
    register_child(&encryptedCert);
  };
};

class EXPORTCLASS CertifiedKeyPair : public asn_sequence { 
public:
  CertOrEncCert		certOrEncCert;
  asn_explicit<EncryptedValue, CLASS_CONTEXT_SPECIFIC, 0>     privateKey;
  asn_explicit<PKIPublicationInfo, CLASS_CONTEXT_SPECIFIC, 1> publicationInfo;
  CertifiedKeyPair(security_t s = ASN_PUBLIC) : asn_sequence(s) {
    strcpy(objType, "CertKeypair");
    privateKey.set_optional();
    publicationInfo.set_optional();
    register_child(&certOrEncCert);
    register_child(&privateKey);
    register_child(&publicationInfo);
  };
};

template class EXPORTCLASS asn_sequenceof<CertifiedKeyPair>;
class EXPORTCLASS CertifiedKeyPairs : public asn_sequenceof<CertifiedKeyPair> {
public:
  CertifiedKeyPairs(security_t s = ASN_PUBLIC) : asn_sequenceof<CertifiedKeyPair> (s) {
    strcpy(objType, "CertKeypairs");
  };
};

class EXPORTCLASS CertResponse : public asn_sequence { 
public:
  asn_integer		certReqId;
  PKIStatusInfo		status;
  CertifiedKeyPair	certifiedKeyPair;
  asn_octetstring	rspInfo;
  CertResponse(security_t s = ASN_PUBLIC) : asn_sequence(s) {
    strcpy(objType, "CertResponse");
    certifiedKeyPair.set_optional();
    rspInfo.set_optional();
    register_child(&certReqId);
    register_child(&status);
    register_child(&certifiedKeyPair);
    register_child(&rspInfo);
  };
};

template class EXPORTCLASS asn_sequenceof<CertResponse>;
class EXPORTCLASS CertResponses : public asn_sequenceof<CertResponse> {
public:
  CertResponses(security_t s = ASN_PUBLIC) : asn_sequenceof<CertResponse> (s) {
    strcpy(objType, "CertResponses");
  };
};

class EXPORTCLASS CertRepMessage : public asn_sequence { 
public:
  asn_explicit<Certificates, CLASS_CONTEXT_SPECIFIC, 1>	caPubs;
  CertResponses						response;
  CertRepMessage(security_t s = ASN_PUBLIC) : asn_sequence(s) {
    strcpy(objType, "CertRepMsg");
    caPubs.set_optional();
    register_child(&caPubs);
    register_child(&response);
  };
};

class EXPORTCLASS KeyRecRepContent : public asn_sequence { 
public:
  PKIStatusInfo		status;
  asn_explicit<Certificate, CLASS_CONTEXT_SPECIFIC, 0>	     newSigCert;
  asn_explicit<Certificates, CLASS_CONTEXT_SPECIFIC, 1>      caCerts;
  asn_explicit<CertifiedKeyPairs, CLASS_CONTEXT_SPECIFIC, 2> keyPairHist;
  KeyRecRepContent(security_t s = ASN_PUBLIC) : asn_sequence(s) {
    strcpy(objType, "CertRecRepCtnt");
    newSigCert.set_optional();
    caCerts.set_optional();
    keyPairHist.set_optional();
    register_child(&status);
    register_child(&newSigCert);
    register_child(&caCerts);
    register_child(&keyPairHist);
  };
};

class EXPORTCLASS OptionalValidity : public asn_sequence {
public:
  asn_explicit<Time, CLASS_CONTEXT_SPECIFIC, 0>		notBefore;
  asn_explicit<Time, CLASS_CONTEXT_SPECIFIC, 1>		notAfter;
  OptionalValidity(security_t s = ASN_PUBLIC) : asn_sequence(s) {
    strcpy(objType, "OptValidity");
    notBefore.set_optional();
    notAfter.set_optional();
    register_child(&notBefore);
    register_child(&notAfter);
  };
};

class EXPORTCLASS CertTemplate : public asn_sequence {
public:
  asn_explicit<asn_integer, CLASS_CONTEXT_SPECIFIC, 0> 		version;
  asn_explicit<asn_integer, CLASS_CONTEXT_SPECIFIC, 1>		serialNumber;
  asn_explicit<AlgorithmIdentifier, CLASS_CONTEXT_SPECIFIC, 2>	signingAlg;
  asn_explicit<asn_x500name, CLASS_CONTEXT_SPECIFIC, 3>		issuer;
  asn_explicit<OptionalValidity, CLASS_CONTEXT_SPECIFIC, 4>	validity;
  asn_explicit<asn_x500name, CLASS_CONTEXT_SPECIFIC, 5>		subject;
  asn_explicit<SubjectPublicKeyInfo, CLASS_CONTEXT_SPECIFIC, 6>	publicKey;
  asn_explicit<UniqueIdentifier, CLASS_CONTEXT_SPECIFIC, 7>	issuerUID;
  asn_explicit<UniqueIdentifier, CLASS_CONTEXT_SPECIFIC, 8>	subjectUID;
  asn_explicit<x509_Extensions, CLASS_CONTEXT_SPECIFIC, 9>	extensions;
  CertTemplate(security_t s = ASN_PUBLIC) : asn_sequence(s) {
    strcpy(objType, "CertTemplate");
    version.set_optional();
    serialNumber.set_optional();
    signingAlg.set_optional();
    issuer.set_optional();
    validity.set_optional();
    subject.set_optional();
    publicKey.set_optional();
    issuerUID.set_optional();
    subjectUID.set_optional();
    extensions.set_optional();
    register_child(&version);
    register_child(&serialNumber);
    register_child(&signingAlg);
    register_child(&issuer);
    register_child(&validity);
    register_child(&subject);
    register_child(&publicKey);
    register_child(&issuerUID);
    register_child(&subjectUID);
    register_child(&extensions);
  };
};

class EXPORTCLASS RevDetails : public asn_sequence {
public:
  CertTemplate		certDetails;
  ReasonFlags		revocationReason;
  asn_generalizedtime	badSinceDate;
  x509_Extensions	crlEntryDetails;
  RevDetails(security_t s = ASN_PUBLIC) : asn_sequence(s) {
    strcpy(objType, "RevDetails");
    revocationReason.set_optional();
    badSinceDate.set_optional();
    crlEntryDetails.set_optional();
    register_child(&certDetails);
    register_child(&revocationReason);
    register_child(&badSinceDate);
    register_child(&crlEntryDetails);
  };
};

template class EXPORTCLASS asn_sequenceof<RevDetails>;
class EXPORTCLASS RevReqContent : public asn_sequenceof<RevDetails> {
public:
  RevReqContent(security_t s = ASN_PUBLIC) : asn_sequenceof<RevDetails> (s) {
    strcpy(objType, "RevReqContent");
  };
};


template class EXPORTCLASS asn_sequenceof<CertificateList>;
class EXPORTCLASS CRLAnnContent : public asn_sequenceof<CertificateList> {
public:
  CRLAnnContent(security_t s = ASN_PUBLIC) : asn_sequenceof<CertificateList> (s) {
    strcpy(objType, "CRLAnnCntnt");
  };
};
typedef CRLAnnContent CertificateLists;

class EXPORTCLASS RevRepContent : public asn_sequence {
public:
  PKIStatusInfos						status;
  asn_explicit<CertIds, CLASS_CONTEXT_SPECIFIC, 0>		revCerts;
  asn_explicit<CertificateLists, CLASS_CONTEXT_SPECIFIC, 1>	crls;
  RevRepContent(security_t s = ASN_PUBLIC) : asn_sequence(s) {
    strcpy(objType, "RevRepCntnt");
    revCerts.set_optional();
    crls.set_optional();
    register_child(&status);
    register_child(&revCerts);
    register_child(&crls);
  };
};

class EXPORTCLASS CAKeyUpdAnnContent : public asn_sequence {
public:
  Certificate	oldWithNew;
  Certificate	newWithOld;
  Certificate	newWithNew;
  CAKeyUpdAnnContent(security_t s = ASN_PUBLIC) : asn_sequence(s) {
    strcpy(objType, "CAKeyUpdAnnCnt");
    register_child(&oldWithNew);
    register_child(&newWithOld);
    register_child(&newWithNew);
  };
};

class EXPORTCLASS RevAnnContent : public asn_sequence {
public:
  PKIStatus		status;
  CertId		certId;
  asn_generalizedtime	willBeRevokedAt;
  asn_generalizedtime	badSinceDate;
  x509_Extensions	crlDetails;
  RevAnnContent(security_t s = ASN_PUBLIC) : asn_sequence(s) {
    strcpy(objType, "RevAnnContent");
    crlDetails.set_optional();
    register_child(&status);
    register_child(&certId);
    register_child(&willBeRevokedAt);
    register_child(&badSinceDate);
    register_child(&crlDetails);
  };
};


class EXPORTCLASS InfoTypeAndValue : public asn_sequence {
public:
  asn_oid	infoType;
  asn_any	infoValue;
  InfoTypeAndValue(security_t s = ASN_PUBLIC) : asn_sequence(s) {
    strcpy(objType, "InfoType&Value");
    infoValue.set_optional();
    register_child(&infoType);
    register_child(&infoValue);
  };
};

typedef InfoTypeAndValue GenMsgContent;
typedef InfoTypeAndValue GenRepContent;

template class EXPORTCLASS asn_sequenceof<InfoTypeAndValue>;
class EXPORTCLASS InfoTypesAndValues : public asn_sequenceof<InfoTypeAndValue> {
public:
  InfoTypesAndValues(security_t s = ASN_PUBLIC) : asn_sequenceof<InfoTypeAndValue> (s) {
    strcpy(objType, "InfoTypes&Vals");
  };
};

class EXPORTCLASS ErrorMsgContent : public asn_sequence {
public:
  PKIStatusInfo		pKIStatusInfo;
  asn_integer		errorCode;
  PKIFreeText		errorDetails;
  ErrorMsgContent(security_t s = ASN_PUBLIC) : asn_sequence(s) {
    strcpy(objType, "ErrorMsgCntnt");
    errorCode.set_optional();
    errorDetails.set_optional();
    register_child(&pKIStatusInfo);
    register_child(&errorCode);
    register_child(&errorDetails);
  };
};


class EXPORTCLASS EncryptedKey : public asn_choice {
public:
  EncryptedValue						encryptedValue;
  asn_explicit<EnvelopedData, CLASS_CONTEXT_SPECIFIC, 0>	envelopedData;
  EncryptedKey(security_t s = ASN_PUBLIC) : asn_choice(s) {
    strcpy(objType, "EncryptedKey");
    register_child(&encryptedValue);
    register_child(&envelopedData);
  };
};

class EXPORTCLASS PKIArchiveOptions : public asn_choice {
public:
  asn_explicit<EncryptedKey, CLASS_CONTEXT_SPECIFIC, 0>		encryptedPrivKey;
  asn_explicit<KeyGenParameters, CLASS_CONTEXT_SPECIFIC, 1>	keyGenParameters;
  asn_explicit<asn_boolean, CLASS_CONTEXT_SPECIFIC, 2> 		archiveReGenPrivKey;
  PKIArchiveOptions(security_t s = ASN_PUBLIC) : asn_choice(s) {
    strcpy(objType, "PKIArchOptions");
    register_child(&encryptedPrivKey);
    register_child(&keyGenParameters);
    register_child(&archiveReGenPrivKey);
  };
};

class EXPORTCLASS AttributeTypeAndValue : public asn_sequence {
public:
  asn_oid	type;
  asn_any	value;
  AttributeTypeAndValue(security_t s = ASN_PUBLIC) : asn_sequence(s) {
    strcpy(objType, "AttrType&Value");
    register_child(&type);
    register_child(&value);
  };
};

template class EXPORTCLASS asn_sequenceof<AttributeTypeAndValue>;
class EXPORTCLASS AttributeTypesAndValues : public asn_sequenceof<AttributeTypeAndValue> {
public:
  AttributeTypesAndValues(security_t s = ASN_PUBLIC) : asn_sequenceof<AttributeTypeAndValue> (s) {
    strcpy(objType, "AttrTypes&Vals");
  };
};

typedef AttributeTypesAndValues Controls;

class EXPORTCLASS PKMACValue : public asn_sequence {
public:
  AlgorithmIdentifier		algId;
  asn_bitstring			value;
  PKMACValue(security_t s = ASN_PUBLIC) : asn_sequence(s) {
    strcpy(objType, "PKMACValue");
    register_child(&algId);
    register_child(&value);
  };
};


class EXPORTCLASS AuthInfo : public asn_choice {
public:
  asn_explicit<GeneralName, CLASS_CONTEXT_SPECIFIC, 0>	sender;
  PKMACValue						publicKeyMac;
  AuthInfo(security_t s = ASN_PUBLIC) : asn_choice(s) {
    strcpy(objType, "AuthInfo");
    register_child(&sender);
    register_child(&publicKeyMac);
  };
};


class EXPORTCLASS POPOSigningKeyInput : public asn_sequence {
public:
  AuthInfo		authInfo;
  SubjectPublicKeyInfo	publicKey;
  POPOSigningKeyInput(security_t s = ASN_PUBLIC) : asn_sequence(s) {
    strcpy(objType, "POPOSignKeyIn");
    register_child(&authInfo);
    register_child(&publicKey);
  };
};

class EXPORTCLASS POPOSigningKey : public asn_sequence {
public:
  asn_explicit<POPOSigningKeyInput, CLASS_CONTEXT_SPECIFIC, 0>	poposkInput;
  AlgorithmIdentifier					algorithmIdentifier;
  asn_bitstring							signature;
  POPOSigningKey(security_t s = ASN_PUBLIC) : asn_sequence(s) {
    strcpy(objType, "POPOSigningKey");
    poposkInput.set_optional();
    register_child(&poposkInput);
    register_child(&algorithmIdentifier);
    register_child(&signature);
  };
};

class EXPORTCLASS POPOPrivKey : public asn_choice {
public:
  asn_explicit<asn_bitstring, CLASS_CONTEXT_SPECIFIC, 0>     thisMessage;
  asn_explicit<SubsequentMessage, CLASS_CONTEXT_SPECIFIC, 1> subsequentMessage;
  asn_explicit<asn_bitstring, CLASS_CONTEXT_SPECIFIC, 2>     dhMac;
  POPOPrivKey(security_t s = ASN_PUBLIC) : asn_choice(s) {
    strcpy(objType, "POPOPrivKey");
    register_child(&thisMessage);
    register_child(&subsequentMessage);
    register_child(&dhMac);
  };
};


class EXPORTCLASS ProofOfPossesion : public asn_choice {
public:
  asn_explicit<asn_null, CLASS_CONTEXT_SPECIFIC, 0>	       raVerified;
  asn_explicit<POPOSigningKey, CLASS_CONTEXT_SPECIFIC, 1>      signature;
  asn_explicit<POPOPrivKey, CLASS_CONTEXT_SPECIFIC, 2>	       keyEncipherment;
  asn_explicit<POPOPrivKey, CLASS_CONTEXT_SPECIFIC, 3>	       keyAgreement;
  ProofOfPossesion(security_t s = ASN_PUBLIC) : asn_choice(s) {
    strcpy(objType, "PoPosession");
    register_child(&raVerified);
    register_child(&signature);
    register_child(&keyEncipherment);
    register_child(&keyAgreement);
  };
};


class EXPORTCLASS CertRequest : public asn_sequence {
public:
  asn_integer		certReqId;	
  CertTemplate		certTemplate;
  Controls		controls;
  CertRequest(security_t s = ASN_PUBLIC) : asn_sequence(s) {
    strcpy(objType, "CertRequest");
    controls.set_optional();
    register_child(&certReqId);
    register_child(&certTemplate);
    register_child(&controls);
  };
};

typedef CertRequest	CertReq;

class EXPORTCLASS CertReqMsg : public asn_sequence {
public:
  CertRequest			certReq;
  ProofOfPossesion		pop;
  AttributeTypesAndValues	regInfo;
  CertReqMsg(security_t s = ASN_PUBLIC) : asn_sequence(s) {
    strcpy(objType, "CertReqMsg");
    pop.set_optional();
    regInfo.set_optional();
    register_child(&certReq);
    register_child(&pop);
    register_child(&regInfo);
  };
};

template class EXPORTCLASS asn_sequenceof<CertReqMsg>;
class EXPORTCLASS CertReqMessages : public asn_sequenceof<CertReqMsg> {
public:
  CertReqMessages(security_t s = ASN_PUBLIC) : asn_sequenceof<CertReqMsg> (s) {
    strcpy(objType, "CertReqMsgs");
  };
};

class EXPORTCLASS PKIHeader : public asn_sequence {
public:
  asn_integer		pvno;
  GeneralName		sender;
  GeneralName       	recipient;
  asn_explicit<asn_generalizedtime, CLASS_CONTEXT_SPECIFIC, 0> messageTime;
  asn_explicit<AlgorithmIdentifier, CLASS_CONTEXT_SPECIFIC, 1> protectionAlg;
  asn_explicit<KeyIdentifier, CLASS_CONTEXT_SPECIFIC, 2> senderKID;
  asn_explicit<KeyIdentifier, CLASS_CONTEXT_SPECIFIC, 3> recipKID;
  asn_explicit<asn_octetstring, CLASS_CONTEXT_SPECIFIC, 4> transactionID;
  asn_explicit<asn_octetstring, CLASS_CONTEXT_SPECIFIC, 5> senderNonce;
  asn_explicit<asn_octetstring, CLASS_CONTEXT_SPECIFIC, 6> recipNonce;
  asn_explicit<PKIFreeText, CLASS_CONTEXT_SPECIFIC, 7> freeText;
  asn_explicit<InfoTypesAndValues, CLASS_CONTEXT_SPECIFIC, 8> generalInfo;
  PKIHeader(security_t s = ASN_PUBLIC) : asn_sequence(s) {
    strcpy(objType, "PKIHeader");
    messageTime.set_optional();
    protectionAlg.set_optional();
    senderKID.set_optional();
    recipKID.set_optional();
    transactionID.set_optional();
    senderNonce.set_optional();
    recipNonce.set_optional();
    freeText.set_optional();
    generalInfo.set_optional();
    register_child(&pvno);
    register_child(&sender);
    register_child(&recipient);
    register_child(&messageTime);
    register_child(&protectionAlg);
    register_child(&senderKID);
    register_child(&recipKID);
    register_child(&transactionID);
    register_child(&senderNonce);
    register_child(&recipNonce);
    register_child(&freeText);
    register_child(&generalInfo);
  };
};

#define PKIX_BODY_IR		0
#define PKIX_BODY_IP		1
#define PKIX_BODY_CR		2
#define PKIX_BODY_CP		3
#define PKIX_BODY_P10CR		4
#define PKIX_BODY_POPDECC	5
#define PKIX_BODY_POPDECR	6
#define PKIX_BODY_KUR		7
#define PKIX_BODY_KUP		8
#define PKIX_BODY_KRR		9
#define PKIX_BODY_KRP		10
#define PKIX_BODY_RR		11
#define PKIX_BODY_RP		12
#define PKIX_BODY_CCR		13
#define PKIX_BODY_CCP		14
#define PKIX_BODY_CKUANN	15
#define PKIX_BODY_CANN		16
#define PKIX_BODY_RANN		17
#define PKIX_BODY_CRLANN	18
#define PKIX_BODY_CONF		19
#define PKIX_BODY_NESTED	20
#define PKIX_BODY_GENM		21
#define PKIX_BODY_GENP		22
#define PKIX_BODY_ERROR		23

class EXPORTCLASS PKIBody : public asn_choice {
public:
    asn_explicit<CertReqMessages, CLASS_CONTEXT_SPECIFIC, 0>	ir;
    asn_explicit<CertRepMessage, CLASS_CONTEXT_SPECIFIC, 1> 	ip;
    asn_explicit<CertReqMessages, CLASS_CONTEXT_SPECIFIC, 2>	cr;
    asn_explicit<CertRepMessage, CLASS_CONTEXT_SPECIFIC, 3> 	cp;
    asn_explicit<CertificationRequest, CLASS_CONTEXT_SPECIFIC, 4>     p10cr;
    asn_explicit<POPODecKeyChallContent, CLASS_CONTEXT_SPECIFIC, 5>   popdecc;
    asn_explicit<POPODecKeyRespContent, CLASS_CONTEXT_SPECIFIC, 6>    popdecr;
    asn_explicit<CertReqMessages, CLASS_CONTEXT_SPECIFIC, 7> 	kur;
    asn_explicit<CertRepMessage, CLASS_CONTEXT_SPECIFIC, 8> 	kup;
    asn_explicit<CertReqMessages, CLASS_CONTEXT_SPECIFIC, 9> 	krr;
    asn_explicit<KeyRecRepContent, CLASS_CONTEXT_SPECIFIC, 10> 	krp;
    asn_explicit<RevReqContent, CLASS_CONTEXT_SPECIFIC, 11> 	rr;
    asn_explicit<RevRepContent, CLASS_CONTEXT_SPECIFIC, 12> 	rp;
    asn_explicit<CertReqMessages, CLASS_CONTEXT_SPECIFIC, 13> 	ccr;
    asn_explicit<CertRepMessage, CLASS_CONTEXT_SPECIFIC, 14> 	ccp;
    asn_explicit<CAKeyUpdAnnContent, CLASS_CONTEXT_SPECIFIC, 15>      ckuann;
    asn_explicit<CertAnnContent, CLASS_CONTEXT_SPECIFIC, 16> 	cann;
    asn_explicit<RevAnnContent, CLASS_CONTEXT_SPECIFIC, 17> 	rann;
    asn_explicit<CRLAnnContent, CLASS_CONTEXT_SPECIFIC, 18> 	crlann;
    asn_explicit<PKIConfirmContent, CLASS_CONTEXT_SPECIFIC, 19> conf;
    asn_explicit<NestedMessageContent, CLASS_CONTEXT_SPECIFIC, 20>    nested;
    asn_explicit<GenMsgContent, CLASS_CONTEXT_SPECIFIC, 21> 	genm;
    asn_explicit<GenRepContent, CLASS_CONTEXT_SPECIFIC, 22> 	genp;
    asn_explicit<ErrorMsgContent, CLASS_CONTEXT_SPECIFIC, 23> 	error;
    PKIBody(security_t s = ASN_PUBLIC) : asn_choice(s) {
      strcpy(objType, "PKIBody");
      register_child(&ir);
      register_child(&ip);
      register_child(&cr);
      register_child(&cp);
      register_child(&p10cr);
      register_child(&popdecc);
      register_child(&popdecr);
      register_child(&kur);
      register_child(&kup);
      register_child(&krr);
      register_child(&krp);
      register_child(&rr);
      register_child(&rp);
      register_child(&ccr);
      register_child(&ccp);
      register_child(&ckuann);
      register_child(&cann);
      register_child(&rann);
      register_child(&crlann);
      register_child(&conf);
      register_child(&nested);
      register_child(&genm);
      register_child(&genp);
      register_child(&error);
    };
};

class EXPORTCLASS ProtectedPart : public asn_sequence {
public:
    PKIHeader	header;
    PKIBody	body;
    ProtectedPart(security_t s = ASN_PUBLIC) : asn_sequence(s) {
      strcpy(objType, "ProtectedPart");
      register_child(&header);
      register_child(&body);
    };
};

class EXPORTCLASS PKIMessage : public asn_sequence {
public:
  PKIHeader	header;
  PKIBody       body;
  asn_explicit<PKIProtection, CLASS_CONTEXT_SPECIFIC, 0> protection;
  asn_explicit<Certificates, CLASS_CONTEXT_SPECIFIC, 1> extraCerts;
  PKIMessage(security_t s = ASN_PUBLIC) : asn_sequence(s) {
    strcpy(objType, "PKIMessage");
    protection.set_optional();
    extraCerts.set_optional();
    register_child(&header);
    register_child(&body);
  };
};


#endif
