/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */

#ifndef __OBJECTDEFS_H__
#define __OBJECTDEFS_H__ 1
#pragma warning(disable:4251) // XXX
#include <pkix_messages.h>
#include <prereg.h>

#define OBJ_MSG_PREREG          0
#define OBJ_MSG_IREQ 	        1
#define OBJ_MSG_CERTREQ         2
#define OBJ_MSG_IREP            3
#define OBJ_MSG_CERTREP         4
#define OBJ_MSG_REVREQ          5
#define OBJ_MSG_REVREP          6

class EXPORTCLASS ObjStorePKIXMsg : public asn_choice {
public:
  asn_explicit<PreRegRecord, CLASS_CONTEXT_SPECIFIC, 0>		regrec;
  asn_explicit<CertReqMessages, CLASS_CONTEXT_SPECIFIC, 1>	ireq;
  asn_explicit<CertReqMessages, CLASS_CONTEXT_SPECIFIC, 2>	certreq;
  asn_explicit<CertRepMessage, CLASS_CONTEXT_SPECIFIC, 3> 	irep;
  asn_explicit<CertRepMessage, CLASS_CONTEXT_SPECIFIC, 4> 	certrep;
  asn_explicit<RevReqContent, CLASS_CONTEXT_SPECIFIC, 5> 	revreq;
  asn_explicit<RevRepContent, CLASS_CONTEXT_SPECIFIC, 6> 	revrep;
  ObjStorePKIXMsg(security_t s = ASN_PUBLIC) : asn_choice(s) {
    register_child(&regrec);
    register_child(&ireq);
    register_child(&certreq);
    register_child(&irep);
    register_child(&certrep);
    register_child(&revreq);
    register_child(&revrep);
  };
};

class EXPORTCLASS KeyData : public asn_sequence {
public:
  AlgorithmIdentifier		protectionAlg;
  asn_octetstring		key;
  KeyData(security_t s = ASN_PUBLIC) : asn_sequence(s) {
    register_child(&protectionAlg);
    register_child(&key);
  };
};

typedef asn_octetstring	ImportedKey;

class EXPORTCLASS CAGeneratedKey : public asn_sequence {
public:
  asn_explicit<asn_integer, CLASS_CONTEXT_SPECIFIC, 0>	numBits;
  asn_explicit<asn_oid, CLASS_CONTEXT_SPECIFIC, 0>	keyAlg;
  CAGeneratedKey(security_t s = ASN_PUBLIC) : asn_sequence(s) {
    numBits.set_optional();
    keyAlg.set_optional();
    register_child(&numBits);
    register_child(&keyAlg);
  };
};

class EXPORTCLASS EEGeneratedKey : public asn_sequence {
public:
  asn_integer	numBits;
  asn_oid	keyAlg;
  EEGeneratedKey(security_t s = ASN_PUBLIC) : asn_sequence(s) {
    register_child(&numBits);
    register_child(&keyAlg);
  };
};

class EXPORTCLASS keygen_options : public asn_choice {
public:
  asn_explicit<EEGeneratedKey, CLASS_CONTEXT_SPECIFIC, 0>	ee;
  asn_explicit<CAGeneratedKey, CLASS_CONTEXT_SPECIFIC, 1>	ca;
  asn_explicit<ImportedKey, CLASS_CONTEXT_SPECIFIC, 2>		imported;
  keygen_options(security_t s = ASN_PUBLIC) : asn_choice(s) {
    register_child(&ee);
    register_child(&ca);
    register_child(&imported);
  };
};

class EXPORTCLASS ObjStoreData : public asn_sequence {
public:
  asn_explicit<GeneralName, CLASS_CONTEXT_SPECIFIC, 0>		sender;
  asn_explicit<GeneralName, CLASS_CONTEXT_SPECIFIC, 1> 		recipient;
  asn_explicit<asn_octetstring, CLASS_CONTEXT_SPECIFIC,2>	recipientURL;
  asn_explicit<asn_octetstring, CLASS_CONTEXT_SPECIFIC,3>	transactionID;
  asn_explicit<KeyData, CLASS_CONTEXT_SPECIFIC, 4> 		keyData;
  asn_explicit<asn_integer, CLASS_CONTEXT_SPECIFIC, 5>		pollReference;
  asn_explicit<asn_integer, CLASS_CONTEXT_SPECIFIC, 6>		pollTime;
  asn_explicit<asn_integer, CLASS_CONTEXT_SPECIFIC, 7>		lastPoll;
  asn_explicit<asn_integer, CLASS_CONTEXT_SPECIFIC, 8>		pollErrorCount;
  asn_explicit<asn_integer, CLASS_CONTEXT_SPECIFIC, 9>		pollError;
  asn_explicit<asn_octetstring, CLASS_CONTEXT_SPECIFIC, 11>	pkcs12Export;
  asn_explicit<asn_octetstring, CLASS_CONTEXT_SPECIFIC, 12>	vscExport;
  asn_explicit<asn_octetstring, CLASS_CONTEXT_SPECIFIC, 13>	tokenExport;
  asn_explicit<keygen_options, CLASS_CONTEXT_SPECIFIC, 14>	keygen;
  asn_explicit<asn_UTF8String, CLASS_CONTEXT_SPECIFIC, 15>	friendlyName;
  asn_explicit<x509_certificate, CLASS_CONTEXT_SPECIFIC, 16>	certificate;
  asn_explicit<ObjStorePKIXMsg,CLASS_CONTEXT_SPECIFIC, 17>	msg;
  ObjStoreData(security_t s = ASN_PUBLIC) : asn_sequence(s) {
    sender.set_optional();
    keyData.set_optional();
    msg.set_optional();
    pollReference.value.set_default_value(0);
    pollTime.value.set_default_value(0);
    lastPoll.value.set_default_value(0);
    pollErrorCount.set_optional();
    pollError.set_optional();
    pkcs12Export.set_optional();
    keygen.set_optional();
    vscExport.set_optional();
    tokenExport.set_optional();
    friendlyName.set_optional();
    certificate.set_optional();
    register_child(&sender);
    register_child(&recipient);
    register_child(&recipientURL);
    register_child(&transactionID);
    register_child(&keyData);
    register_child(&pollReference);
    register_child(&pollTime);
    register_child(&lastPoll);
    register_child(&pollErrorCount);
    register_child(&pollError);
    register_child(&pkcs12Export);
    register_child(&vscExport);
    register_child(&tokenExport);
    register_child(&keygen);
    register_child(&friendlyName);
    register_child(&certificate);
    register_child(&msg);
  };
};
#endif
