#ifndef _JONAH_CL_H_
#define _JONAH_CL_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "cssmerr.h"

#ifndef CSSM_CL_INVALID_RESULTS_HANDLE
#define CSSM_CL_INVALID_RESULTS_HANDLE CSSM_CL_RESULTS_HANDLE
#endif


static const CSSM_GUID JONAHCL_GUID 
= { /* 95d67e80-e120-11d1-9841-00a0c98ce906 */
    0x95d67e80,
    0xe120,
    0x11d1,
    {0x98, 0x41, 0x00, 0xa0, 0xc9, 0x8c, 0xe9, 0x06}
  };
static const uint32
JONAHCL_MAJOR_VERSION = 1;

static const uint32
JONAHCL_MINOR_VERSION = 0;


#define JONAHCL_THREADSAFE     (CSSM_TRUE)
#define JONAHCL_NUMSUBSERVICE  (1)



const uint8  JONAH_x509_crl_signature_DER[] = { 0x06, 0x08, 0x2a, 0x87, 0x67, 0x01, 0x01, 0x01, 0x02, 0x01 };
const uint8  JONAH_x509_crl_signatureAlgorithmIdentifier_DER[] = { 0x06, 0x08, 0x2a, 0x87, 0x67, 0x01, 0x01, 0x01, 0x02, 0x02 };
const uint8  JONAH_x509_crl_signatureAlgorithmIdentifier_objectIdentifier_DER[] = { 0x06, 0x09, 0x2a, 0x87, 0x67, 0x01, 0x01, 0x01, 0x02, 0x02, 0x01 };
const uint8  JONAH_x509_crl_signatureAlgorithmIdentifier_parameters_DER[] = { 0x06, 0x09, 0x2a, 0x87, 0x67, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02 };
const uint8  JONAH_x509_ucrl_version_DER[] = { 0x06, 0x09, 0x2a, 0x87, 0x67, 0x01, 0x01, 0x01, 0x02, 0x03, 0x01 };
const uint8  JONAH_x509_ucrl_signatureAlgorithmIdentifier_DER[] = { 0x06, 0x09, 0x2a, 0x87, 0x67, 0x01, 0x01, 0x01, 0x02, 0x03, 0x02 };
const uint8  JONAH_x509_ucrl_signatureAlgorithmIdentifier_objectIdentifier_DER[] = { 0x06, 0x0a, 0x2a, 0x87, 0x67, 0x01, 0x01, 0x01, 0x02, 0x03, 0x02, 0x01 };
const uint8  JONAH_x509_ucrl_signatureAlgorithmIdentifier_parameters_DER[] = { 0x06, 0x0a, 0x2a, 0x87, 0x67, 0x01, 0x01, 0x01, 0x02, 0x03, 0x02, 0x02 };
const uint8  JONAH_x509_ucrl_issuer_DER[] = { 0x06, 0x09, 0x2a, 0x87, 0x67, 0x01, 0x01, 0x01, 0x02, 0x03, 0x03 };
const uint8  JONAH_x509_ucrl_thisUpdate_DER[] = { 0x06, 0x09, 0x2a, 0x87, 0x67, 0x01, 0x01, 0x01, 0x02, 0x03, 0x04 };
const uint8  JONAH_x509_ucrl_nextUpdate_DER[] = { 0x06, 0x09, 0x2a, 0x87, 0x67, 0x01, 0x01, 0x01, 0x02, 0x03, 0x05 };
const uint8  JONAH_x509_ucrl_revokedCertificates_crlEntry_DER[] = { 0x06, 0x0a, 0x2a, 0x87, 0x67, 0x01, 0x01, 0x01, 0x02, 0x03, 0x06, 0x01 };
const uint8  JONAH_x509_ucrl_extensions_DER[] = { 0x06, 0x09, 0x2a, 0x87, 0x67, 0x01, 0x01, 0x01, 0x02, 0x03, 0x07 };



const uint8  JONAH_x509_cert_signature_DER[] = { 0x06, 0x08, 0x2a, 0x87, 0x67, 0x01, 0x01, 0x01, 0x01, 0x01 };
const uint8  JONAH_x509_cert_signatureAlgorithmIdentifier_DER[] = { 0x06, 0x08, 0x2a, 0x87, 0x67, 0x01, 0x01, 0x01, 0x01, 0x02 };
const uint8  JONAH_x509_cert_signatureAlgorithmIdentifier_objectIdentifier_DER[] = { 0x06, 0x09, 0x2a, 0x87, 0x67, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01 };
const uint8  JONAH_x509_cert_signatureAlgorithmIdentifier_parameters_DER[] = { 0x06, 0x09, 0x2a, 0x87, 0x67, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02 };
const uint8  JONAH_x509_ucert_version_DER[] = { 0x06, 0x09, 0x2a, 0x87, 0x67, 0x01, 0x01, 0x01, 0x01, 0x03, 0x01 };
const uint8  JONAH_x509_ucert_signatureAlgorithmIdentifier_DER[] = { 0x06, 0x09, 0x2a, 0x87, 0x67, 0x01, 0x01, 0x01, 0x01, 0x03, 0x02 };
const uint8  JONAH_x509_ucert_signatureAlgorithmIdentifier_objectIdentifier_DER[] = { 0x06, 0x0a, 0x2a, 0x87, 0x67, 0x01, 0x01, 0x01, 0x01, 0x03, 0x02, 0x01 };
const uint8  JONAH_x509_ucert_signatureAlgorithmIdentifier_parameters_DER[] = { 0x06, 0x0a, 0x2a, 0x87, 0x67, 0x01, 0x01, 0x01, 0x01, 0x03, 0x02, 0x02 };
const uint8  JONAH_x509_ucert_issuerName_DER[] = { 0x06, 0x09, 0x2a, 0x87, 0x67, 0x01, 0x01, 0x01, 0x01, 0x03, 0x03 };
const uint8  JONAH_x509_ucert_subjectName_DER[] = { 0x06, 0x09, 0x2a, 0x87, 0x67, 0x01, 0x01, 0x01, 0x01, 0x03, 0x04 };
const uint8  JONAH_x509_ucert_validity_notbefore_DER[] = { 0x06, 0x0a, 0x2a, 0x87, 0x67, 0x01, 0x01, 0x01, 0x01, 0x03, 0x05, 0x01 };
const uint8  JONAH_x509_ucert_validity_notafter_DER[] = { 0x06, 0x0a, 0x2a, 0x87, 0x67, 0x01, 0x01, 0x01, 0x01, 0x03, 0x05, 0x02 };
const uint8  JONAH_x509_ucert_subjectPublicKeyInfo_DER[] = { 0x06, 0x09, 0x2a, 0x87, 0x67, 0x01, 0x01, 0x01, 0x01, 0x03, 0x06 };
const uint8  JONAH_x509_ucert_subjectPublicKeyInfo_algorithm_DER[] = { 0x06, 0x0a, 0x2a, 0x87, 0x67, 0x01, 0x01, 0x01, 0x01, 0x03, 0x06, 0x01 };
const uint8  JONAH_x509_ucert_subjectPublicKeyInfo_algorithm_oid_DER[] = { 0x06, 0x0b, 0x2a, 0x87, 0x67, 0x01, 0x01, 0x01, 0x01, 0x03, 0x06, 0x01, 0x01 };
const uint8  JONAH_x509_ucert_subjectPublicKeyInfo_algorithm_parameters_DER[] = { 0x06, 0x0b, 0x2a, 0x87, 0x67, 0x01, 0x01, 0x01, 0x01, 0x03, 0x06, 0x01, 0x02 };
const uint8  JONAH_x509_ucert_subjectPublicKeyInfo_publicKey_DER[] = { 0x06, 0x0a, 0x2a, 0x87, 0x67, 0x01, 0x01, 0x01, 0x01, 0x03, 0x06, 0x02 };
const uint8  JONAH_x509_ucert_certificateSerialNumber_DER[] = { 0x06, 0x09, 0x2a, 0x87, 0x67, 0x01, 0x01, 0x01, 0x01, 0x03, 0x07 };
const uint8  JONAH_x509_ucert_serialNumberIssuerName_DER[] = { 0x06, 0x09, 0x2a, 0x87, 0x67, 0x01, 0x01, 0x01, 0x01, 0x03, 0x08 };
const uint8  JONAH_x509_ucert_issuerUniqueID_DER[] = { 0x06, 0x09, 0x2a, 0x87, 0x67, 0x01, 0x01, 0x01, 0x01, 0x03, 0x09 };
const uint8  JONAH_x509_ucert_subjectUniqueID_DER[] = { 0x06, 0x09, 0x2a, 0x87, 0x67, 0x01, 0x01, 0x01, 0x01, 0x03, 0x0a };
const uint8  JONAH_x509_ucert_extensions_DER[] = { 0x06, 0x09, 0x2a, 0x87, 0x67, 0x01, 0x01, 0x01, 0x01, 0x03, 0x0b };


#ifdef __cplusplus
}
#endif


#endif   //_JONAH_CL_H_

