/*
 * Decompiled with CFR 0.152.
 */
package LOKI97;

import LOKI97.LOKI97_Properties;
import java.io.PrintWriter;
import java.security.InvalidKeyException;

public final class LOKI97_Algorithm {
    static final String NAME = "LOKI97_Algorithm";
    static final String FULL_NAME;
    static final boolean IN = true;
    static final boolean OUT = false;
    static final boolean DEBUG = true;
    static final int debuglevel;
    static final PrintWriter err;
    static final boolean TRACE;
    static final int BLOCK_SIZE = 16;
    static final int ROUNDS = 16;
    static final int NUM_SUBKEYS = 48;
    private static final long DELTA = -7046029254386353131L;
    private static final int S1_GEN = 10513;
    static final int S1_SIZE = 8192;
    static final byte[] S1;
    private static final int S2_GEN = 2727;
    static final int S2_SIZE = 2048;
    static final byte[] S2;
    static final long[] P;
    private static final char[] HEX_DIGITS;

    static void debug(String s) {
        err.println(">>> " + "LOKI97 ver. " + 1.0 + ": " + s);
    }

    static void trace(boolean in, String s) {
        if (TRACE) {
            err.println(String.valueOf(in ? "==> " : "<== ") + NAME + "." + s);
        }
    }

    static void trace(String s) {
        if (TRACE) {
            err.println("<=> LOKI97_Algorithm." + s);
        }
    }

    static final byte exp3(int b, int g, int n) {
        if (b == 0) {
            return 0;
        }
        int r = b;
        b = LOKI97_Algorithm.mult(r, b, g, n);
        r = LOKI97_Algorithm.mult(r, b, g, n);
        return (byte)r;
    }

    static final int mult(int a, int b, int g, int n) {
        int p = 0;
        while (b != 0) {
            if ((b & 1) != 0) {
                p ^= a;
            }
            if ((a <<= 1) >= n) {
                a ^= g;
            }
            b >>>= 1;
        }
        return p;
    }

    public static synchronized Object makeKey(byte[] k) throws InvalidKeyException {
        long k1;
        long k2;
        LOKI97_Algorithm.trace(true, "makeKey(" + k + ")");
        if (k == null) {
            throw new InvalidKeyException("Empty key");
        }
        if (k.length != 16 && k.length != 24 && k.length != 32) {
            throw new InvalidKeyException("Incorrect key length");
        }
        if (debuglevel > 7) {
            System.out.println("Intermediate Session Key Values");
            System.out.println();
            System.out.println("Raw=" + LOKI97_Algorithm.toString(k));
        }
        long[] SK = new long[48];
        long deltan = -7046029254386353131L;
        int i = 0;
        long k4 = ((long)k[i++] & 0xFFL) << 56 | ((long)k[i++] & 0xFFL) << 48 | ((long)k[i++] & 0xFFL) << 40 | ((long)k[i++] & 0xFFL) << 32 | ((long)k[i++] & 0xFFL) << 24 | ((long)k[i++] & 0xFFL) << 16 | ((long)k[i++] & 0xFFL) << 8 | (long)k[i++] & 0xFFL;
        long k3 = ((long)k[i++] & 0xFFL) << 56 | ((long)k[i++] & 0xFFL) << 48 | ((long)k[i++] & 0xFFL) << 40 | ((long)k[i++] & 0xFFL) << 32 | ((long)k[i++] & 0xFFL) << 24 | ((long)k[i++] & 0xFFL) << 16 | ((long)k[i++] & 0xFFL) << 8 | (long)k[i++] & 0xFFL;
        if (k.length == 16) {
            k2 = LOKI97_Algorithm.f(k3, k4);
            k1 = LOKI97_Algorithm.f(k4, k3);
        } else {
            k2 = ((long)k[i++] & 0xFFL) << 56 | ((long)k[i++] & 0xFFL) << 48 | ((long)k[i++] & 0xFFL) << 40 | ((long)k[i++] & 0xFFL) << 32 | ((long)k[i++] & 0xFFL) << 24 | ((long)k[i++] & 0xFFL) << 16 | ((long)k[i++] & 0xFFL) << 8 | (long)k[i++] & 0xFFL;
            k1 = k.length == 24 ? LOKI97_Algorithm.f(k4, k3) : ((long)k[i++] & 0xFFL) << 56 | ((long)k[i++] & 0xFFL) << 48 | ((long)k[i++] & 0xFFL) << 40 | ((long)k[i++] & 0xFFL) << 32 | ((long)k[i++] & 0xFFL) << 24 | ((long)k[i++] & 0xFFL) << 16 | ((long)k[i++] & 0xFFL) << 8 | (long)k[i++] & 0xFFL;
        }
        if (debuglevel > 0) {
            LOKI97_Algorithm.debug("makeKey(" + LOKI97_Algorithm.longToString(k4) + "," + LOKI97_Algorithm.longToString(k3) + "," + LOKI97_Algorithm.longToString(k2) + "," + LOKI97_Algorithm.longToString(k1) + ")");
        }
        i = 0;
        while (i < 48) {
            long f_out = LOKI97_Algorithm.f(k1 + k3 + deltan, k2);
            SK[i] = k4 ^ f_out;
            k4 = k3;
            k3 = k2;
            k2 = k1;
            k1 = SK[i];
            deltan += -7046029254386353131L;
            if (debuglevel > 2) {
                LOKI97_Algorithm.debug(" SK[" + i + "]=" + LOKI97_Algorithm.longToString(SK[i]) + "; f=" + LOKI97_Algorithm.longToString(f_out));
            }
            ++i;
        }
        if (debuglevel > 7) {
            i = 0;
            while (i < 48) {
                System.out.println("SK" + i + "=" + LOKI97_Algorithm.longToString(SK[i]));
                ++i;
            }
            System.out.println();
        }
        LOKI97_Algorithm.trace(false, "makeKey()");
        return SK;
    }

    public static byte[] blockEncrypt(byte[] in, int inOffset, Object sessionKey) {
        LOKI97_Algorithm.trace(true, "blockEncrypt(" + in + ", " + inOffset + ", " + sessionKey + ")");
        long[] SK = (long[])sessionKey;
        long L = ((long)in[inOffset++] & 0xFFL) << 56 | ((long)in[inOffset++] & 0xFFL) << 48 | ((long)in[inOffset++] & 0xFFL) << 40 | ((long)in[inOffset++] & 0xFFL) << 32 | ((long)in[inOffset++] & 0xFFL) << 24 | ((long)in[inOffset++] & 0xFFL) << 16 | ((long)in[inOffset++] & 0xFFL) << 8 | (long)in[inOffset++] & 0xFFL;
        long R = ((long)in[inOffset++] & 0xFFL) << 56 | ((long)in[inOffset++] & 0xFFL) << 48 | ((long)in[inOffset++] & 0xFFL) << 40 | ((long)in[inOffset++] & 0xFFL) << 32 | ((long)in[inOffset++] & 0xFFL) << 24 | ((long)in[inOffset++] & 0xFFL) << 16 | ((long)in[inOffset++] & 0xFFL) << 8 | (long)in[inOffset++] & 0xFFL;
        if (debuglevel > 0) {
            LOKI97_Algorithm.debug("blockEncrypt(" + LOKI97_Algorithm.longToString(L) + LOKI97_Algorithm.longToString(R) + ")");
        }
        if (debuglevel > 6) {
            System.out.println("PT=" + LOKI97_Algorithm.longToString(L) + " " + LOKI97_Algorithm.longToString(R));
        }
        int k = 0;
        int i = 0;
        while (i < 16) {
            long nR = R + SK[k++];
            long f_out = LOKI97_Algorithm.f(nR, SK[k++]);
            int n = k++;
            R = L ^ f_out;
            L = nR += SK[n];
            if (debuglevel > 1) {
                LOKI97_Algorithm.debug(" L[" + (i + 1) + "]=" + LOKI97_Algorithm.longToString(L) + "; R[" + (i + 1) + "]=" + LOKI97_Algorithm.longToString(R) + "; f(SK(" + (k - 2) + "))=" + LOKI97_Algorithm.longToString(f_out));
            }
            if (debuglevel > 6) {
                System.out.println("CT" + (i + 1) + "=" + LOKI97_Algorithm.longToString(L) + " " + LOKI97_Algorithm.longToString(R));
            }
            ++i;
        }
        if (debuglevel > 0) {
            LOKI97_Algorithm.debug("  = " + LOKI97_Algorithm.longToString(R) + LOKI97_Algorithm.longToString(L));
        }
        byte[] result = new byte[]{(byte)(R >>> 56), (byte)(R >>> 48), (byte)(R >>> 40), (byte)(R >>> 32), (byte)(R >>> 24), (byte)(R >>> 16), (byte)(R >>> 8), (byte)R, (byte)(L >>> 56), (byte)(L >>> 48), (byte)(L >>> 40), (byte)(L >>> 32), (byte)(L >>> 24), (byte)(L >>> 16), (byte)(L >>> 8), (byte)L};
        if (debuglevel > 6) {
            System.out.println("CT=" + LOKI97_Algorithm.toString(result));
            System.out.println();
        }
        LOKI97_Algorithm.trace(false, "blockEncrypt()");
        return result;
    }

    public static byte[] blockDecrypt(byte[] in, int inOffset, Object sessionKey) {
        LOKI97_Algorithm.trace(true, "blockDecrypt(" + in + ", " + inOffset + ", " + sessionKey + ")");
        long[] SK = (long[])sessionKey;
        long L = ((long)in[inOffset++] & 0xFFL) << 56 | ((long)in[inOffset++] & 0xFFL) << 48 | ((long)in[inOffset++] & 0xFFL) << 40 | ((long)in[inOffset++] & 0xFFL) << 32 | ((long)in[inOffset++] & 0xFFL) << 24 | ((long)in[inOffset++] & 0xFFL) << 16 | ((long)in[inOffset++] & 0xFFL) << 8 | (long)in[inOffset++] & 0xFFL;
        long R = ((long)in[inOffset++] & 0xFFL) << 56 | ((long)in[inOffset++] & 0xFFL) << 48 | ((long)in[inOffset++] & 0xFFL) << 40 | ((long)in[inOffset++] & 0xFFL) << 32 | ((long)in[inOffset++] & 0xFFL) << 24 | ((long)in[inOffset++] & 0xFFL) << 16 | ((long)in[inOffset++] & 0xFFL) << 8 | (long)in[inOffset++] & 0xFFL;
        if (debuglevel > 0) {
            LOKI97_Algorithm.debug("blockDecrypt(" + LOKI97_Algorithm.longToString(L) + LOKI97_Algorithm.longToString(R) + ")");
        }
        if (debuglevel > 6) {
            System.out.println("CT=" + LOKI97_Algorithm.longToString(L) + " " + LOKI97_Algorithm.longToString(R));
        }
        int k = 47;
        int i = 0;
        while (i < 16) {
            long nR = R - SK[k--];
            long f_out = LOKI97_Algorithm.f(nR, SK[k--]);
            int n = k--;
            R = L ^ f_out;
            L = nR -= SK[n];
            if (debuglevel > 1) {
                LOKI97_Algorithm.debug(" L[" + (i + 1) + "]=" + LOKI97_Algorithm.longToString(L) + "; R[" + (i + 1) + "]=" + LOKI97_Algorithm.longToString(R) + "; f(SK(" + (k + 2) + "))=" + LOKI97_Algorithm.longToString(f_out));
            }
            if (debuglevel > 6) {
                System.out.println("PT" + (i + 1) + "=" + LOKI97_Algorithm.longToString(L) + " " + LOKI97_Algorithm.longToString(R));
            }
            ++i;
        }
        if (debuglevel > 0) {
            LOKI97_Algorithm.debug("  = " + LOKI97_Algorithm.longToString(R) + LOKI97_Algorithm.longToString(L));
        }
        byte[] result = new byte[]{(byte)(R >>> 56), (byte)(R >>> 48), (byte)(R >>> 40), (byte)(R >>> 32), (byte)(R >>> 24), (byte)(R >>> 16), (byte)(R >>> 8), (byte)R, (byte)(L >>> 56), (byte)(L >>> 48), (byte)(L >>> 40), (byte)(L >>> 32), (byte)(L >>> 24), (byte)(L >>> 16), (byte)(L >>> 8), (byte)L};
        if (debuglevel > 6) {
            System.out.println("PT=" + LOKI97_Algorithm.toString(result));
            System.out.println();
        }
        LOKI97_Algorithm.trace(false, "blockDecrypt()");
        return result;
    }

    public static boolean self_test() {
        boolean ok;
        block9: {
            LOKI97_Algorithm.trace(true, "self_test()");
            ok = false;
            try {
                byte[] tmp;
                byte[] kb = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
                byte[] pt = new byte[16];
                int i = 0;
                while (i < 16) {
                    pt[i] = (byte)i;
                    ++i;
                }
                Object key = LOKI97_Algorithm.makeKey(kb);
                byte[] ct = LOKI97_Algorithm.fromString("75080E359F10FE640144B35C57128DAD");
                ok = LOKI97_Algorithm.areEqual(ct, tmp = LOKI97_Algorithm.blockEncrypt(pt, 0, key));
                if (!ok) {
                    if (debuglevel > 0) {
                        LOKI97_Algorithm.debug("KAT single triple");
                        LOKI97_Algorithm.debug("       key: " + LOKI97_Algorithm.toString(kb));
                        LOKI97_Algorithm.debug(" plaintext: " + LOKI97_Algorithm.toString(pt));
                        LOKI97_Algorithm.debug("ciphertext: " + LOKI97_Algorithm.toString(ct));
                        LOKI97_Algorithm.debug("  computed: " + LOKI97_Algorithm.toString(tmp));
                    }
                    throw new RuntimeException("Encryption failed");
                }
                tmp = LOKI97_Algorithm.blockDecrypt(ct, 0, key);
                ok = LOKI97_Algorithm.areEqual(pt, tmp);
                if (!ok) {
                    if (debuglevel > 0) {
                        LOKI97_Algorithm.debug("KAT single triple");
                        LOKI97_Algorithm.debug("       key: " + LOKI97_Algorithm.toString(kb));
                        LOKI97_Algorithm.debug("ciphertext: " + LOKI97_Algorithm.toString(ct));
                        LOKI97_Algorithm.debug(" plaintext: " + LOKI97_Algorithm.toString(pt));
                        LOKI97_Algorithm.debug("  computed: " + LOKI97_Algorithm.toString(tmp));
                    }
                    throw new RuntimeException("Decryption failed");
                }
                if (debuglevel > 0) {
                    LOKI97_Algorithm.debug("KAT (single triple) OK? " + ok);
                }
                ok = LOKI97_Algorithm.self_test(16);
            }
            catch (Exception x) {
                if (debuglevel <= 0) break block9;
                LOKI97_Algorithm.debug("Exception encountered during self-test: " + x.getMessage());
                x.printStackTrace();
            }
        }
        if (debuglevel > 0) {
            LOKI97_Algorithm.debug("Self-test OK? " + ok);
        }
        LOKI97_Algorithm.trace(false, "self_test()");
        return ok;
    }

    public static int blockSize() {
        return 16;
    }

    private static long f(long A, long B) {
        int Al = (int)(A >>> 32);
        int Ar = (int)A;
        int Br = (int)B;
        long d = (long)(Al & ~Br | Ar & Br) << 32 | (long)(Ar & ~Br | Al & Br) & 0xFFFFFFFFL;
        long e = P[S1[(int)((d >>> 56 | d << 8) & 0x1FFFL)] & 0xFF] >>> 7 | P[S2[(int)(d >>> 48 & 0x7FFL)] & 0xFF] >>> 6 | P[S1[(int)(d >>> 40 & 0x1FFFL)] & 0xFF] >>> 5 | P[S2[(int)(d >>> 32 & 0x7FFL)] & 0xFF] >>> 4 | P[S2[(int)(d >>> 24 & 0x7FFL)] & 0xFF] >>> 3 | P[S1[(int)(d >>> 16 & 0x1FFFL)] & 0xFF] >>> 2 | P[S2[(int)(d >>> 8 & 0x7FFL)] & 0xFF] >>> 1 | P[S1[(int)(d & 0x1FFFL)] & 0xFF];
        long f = ((long)S2[(int)(e >>> 56 & 0xFFL | B >>> 53 & 0x700L)] & 0xFFL) << 56 | ((long)S2[(int)(e >>> 48 & 0xFFL | B >>> 50 & 0x700L)] & 0xFFL) << 48 | ((long)S1[(int)(e >>> 40 & 0xFFL | B >>> 45 & 0x1F00L)] & 0xFFL) << 40 | ((long)S1[(int)(e >>> 32 & 0xFFL | B >>> 40 & 0x1F00L)] & 0xFFL) << 32 | ((long)S2[(int)(e >>> 24 & 0xFFL | B >>> 37 & 0x700L)] & 0xFFL) << 24 | ((long)S2[(int)(e >>> 16 & 0xFFL | B >>> 34 & 0x700L)] & 0xFFL) << 16 | ((long)S1[(int)(e >>> 8 & 0xFFL | B >>> 29 & 0x1F00L)] & 0xFFL) << 8 | (long)S1[(int)(e & 0xFFL | B >>> 24 & 0x1F00L)] & 0xFFL;
        if (debuglevel > 3) {
            LOKI97_Algorithm.debug("  f(" + LOKI97_Algorithm.longToString(A) + "," + LOKI97_Algorithm.longToString(B) + ") = " + LOKI97_Algorithm.longToString(f));
        }
        if (debuglevel > 4) {
            LOKI97_Algorithm.debug("   d=" + LOKI97_Algorithm.longToString(d) + "; e=" + LOKI97_Algorithm.longToString(e));
        }
        return f;
    }

    private static boolean self_test(int keysize) {
        boolean ok;
        block9: {
            LOKI97_Algorithm.trace(true, "self_test(" + keysize + ")");
            ok = false;
            try {
                byte[] cpt;
                byte[] kb = new byte[keysize];
                byte[] pt = new byte[16];
                int i = 0;
                while (i < keysize) {
                    kb[i] = (byte)i;
                    ++i;
                }
                i = 0;
                while (i < 16) {
                    pt[i] = (byte)i;
                    ++i;
                }
                if (debuglevel > 6) {
                    System.out.println("==========");
                    System.out.println();
                    System.out.println("KEYSIZE=" + 8 * keysize);
                    System.out.println("KEY=" + LOKI97_Algorithm.toString(kb));
                    System.out.println();
                }
                Object key = LOKI97_Algorithm.makeKey(kb);
                if (debuglevel > 6) {
                    System.out.println("Intermediate Ciphertext Values (Encryption)");
                    System.out.println();
                }
                byte[] ct = LOKI97_Algorithm.blockEncrypt(pt, 0, key);
                if (debuglevel > 6) {
                    System.out.println("Intermediate Plaintext Values (Decryption)");
                    System.out.println();
                }
                if (!(ok = LOKI97_Algorithm.areEqual(pt, cpt = LOKI97_Algorithm.blockDecrypt(ct, 0, key)))) {
                    throw new RuntimeException("Symmetric operation failed");
                }
            }
            catch (Exception x) {
                if (debuglevel <= 0) break block9;
                LOKI97_Algorithm.debug("Exception encountered during self-test: " + x.getMessage());
                x.printStackTrace();
            }
        }
        if (debuglevel > 0) {
            LOKI97_Algorithm.debug("Self-test OK? " + ok);
        }
        LOKI97_Algorithm.trace(false, "self_test()");
        return ok;
    }

    public static boolean triple_test() {
        if (TRACE) {
            LOKI97_Algorithm.trace(true, "triple_test()");
        }
        boolean result = false;
        boolean enok = true;
        boolean deok = true;
        byte[] keyx = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
        byte[] plain = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        byte[] cipher = LOKI97_Algorithm.fromString("75080E359F10FE640144B35C57128DAD");
        try {
            LOKI97_Algorithm.debug("SelfTest");
            LOKI97_Algorithm.debug("   key: " + LOKI97_Algorithm.toString(keyx));
            LOKI97_Algorithm.debug(" plain: " + LOKI97_Algorithm.toString(plain));
            LOKI97_Algorithm.debug("cipher: " + LOKI97_Algorithm.toString(cipher));
            Object key = LOKI97_Algorithm.makeKey(keyx);
            byte[] temp = LOKI97_Algorithm.blockEncrypt(plain, 0, key);
            if (!LOKI97_Algorithm.areEqual(temp, cipher)) {
                enok = false;
            }
            LOKI97_Algorithm.debug("Test encrypt: " + LOKI97_Algorithm.toString(temp) + (enok ? "    GOOD" : "    FAILED"));
            temp = LOKI97_Algorithm.blockDecrypt(cipher, 0, key);
            if (!LOKI97_Algorithm.areEqual(temp, plain)) {
                deok = false;
            }
            LOKI97_Algorithm.debug("Test decrypt: " + LOKI97_Algorithm.toString(temp) + (deok ? "    GOOD" : "    FAILED"));
            result = enok && deok;
        }
        catch (Exception ex) {
            LOKI97_Algorithm.debug("Exception in triple-test: " + ex.getMessage());
            ex.printStackTrace();
        }
        LOKI97_Algorithm.debug("triple-test OK? " + result);
        if (TRACE) {
            LOKI97_Algorithm.trace(false, "triple_test()");
        }
        return result;
    }

    private static boolean areEqual(byte[] a, byte[] b) {
        int aLength = a.length;
        if (aLength != b.length) {
            return false;
        }
        int i = 0;
        while (i < aLength) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static byte[] fromString(String hex) {
        int len = hex.length();
        byte[] buf = new byte[(len + 1) / 2];
        int i = 0;
        int j = 0;
        if (len % 2 == 1) {
            buf[j++] = (byte)LOKI97_Algorithm.fromDigit(hex.charAt(i++));
        }
        while (i < len) {
            buf[j++] = (byte)(LOKI97_Algorithm.fromDigit(hex.charAt(i++)) << 4 | LOKI97_Algorithm.fromDigit(hex.charAt(i++)));
        }
        return buf;
    }

    public static int fromDigit(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'A' && ch <= 'F') {
            return ch - 65 + 10;
        }
        if (ch >= 'a' && ch <= 'f') {
            return ch - 97 + 10;
        }
        throw new IllegalArgumentException("Invalid hex digit '" + ch + "'");
    }

    private static String byteToString(int n) {
        char[] buf = new char[]{HEX_DIGITS[n >>> 4 & 0xF], HEX_DIGITS[n & 0xF]};
        return new String(buf);
    }

    private static String shortToString(int n) {
        char[] buf = new char[]{HEX_DIGITS[n >>> 12 & 0xF], HEX_DIGITS[n >>> 8 & 0xF], HEX_DIGITS[n >>> 4 & 0xF], HEX_DIGITS[n & 0xF]};
        return new String(buf);
    }

    private static String longToString(long n) {
        char[] buf = new char[16];
        int i = 15;
        while (i >= 0) {
            buf[i] = HEX_DIGITS[(int)n & 0xF];
            n >>>= 4;
            --i;
        }
        return new String(buf);
    }

    private static String toString(byte[] ba) {
        int length = ba.length;
        char[] buf = new char[length * 2];
        int i = 0;
        int j = 0;
        while (i < length) {
            byte k = ba[i++];
            buf[j++] = HEX_DIGITS[k >>> 4 & 0xF];
            buf[j++] = HEX_DIGITS[k & 0xF];
        }
        return new String(buf);
    }

    public static void main(String[] args) {
        LOKI97_Algorithm.self_test(16);
        LOKI97_Algorithm.self_test(24);
        LOKI97_Algorithm.self_test(32);
        LOKI97_Algorithm.triple_test();
    }

    static {
        int j;
        int b;
        FULL_NAME = "LOKI97 ver. " + 1.0;
        debuglevel = LOKI97_Properties.getLevel(NAME);
        err = LOKI97_Properties.getOutput();
        TRACE = LOKI97_Properties.isTraceable(NAME);
        S1 = new byte[8192];
        S2 = new byte[2048];
        P = new long[256];
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        long time = System.currentTimeMillis();
        if (debuglevel > 6) {
            System.out.println("Algorithm Name: " + "LOKI97 ver. " + 1.0);
            System.out.println("Electronic Codebook (ECB) Mode");
            System.out.println();
        }
        if (debuglevel > 5) {
            LOKI97_Algorithm.debug("Static init of precomputing tables");
        }
        int S1_MASK = 8191;
        int S2_MASK = 2047;
        int i = 0;
        i = 0;
        while (i < 8192) {
            b = i ^ S1_MASK;
            LOKI97_Algorithm.S1[i] = LOKI97_Algorithm.exp3(b, 10513, 8192);
            if (debuglevel > 5) {
                LOKI97_Algorithm.debug(" S1[" + LOKI97_Algorithm.shortToString(i) + "] = " + LOKI97_Algorithm.byteToString(S1[i]));
            }
            ++i;
        }
        i = 0;
        while (i < 2048) {
            b = i ^ S2_MASK;
            LOKI97_Algorithm.S2[i] = LOKI97_Algorithm.exp3(b, 2727, 2048);
            if (debuglevel > 5) {
                LOKI97_Algorithm.debug(" S2[" + LOKI97_Algorithm.shortToString(i) + "] = " + LOKI97_Algorithm.byteToString(S2[i]));
            }
            ++i;
        }
        i = 0;
        while (i < 256) {
            long pval = 0L;
            j = 0;
            int k = 7;
            while (j < 8) {
                pval |= (long)(i >>> j & 1) << k;
                ++j;
                k += 8;
            }
            LOKI97_Algorithm.P[i] = pval;
            if (debuglevel > 5) {
                LOKI97_Algorithm.debug(" P[" + LOKI97_Algorithm.byteToString(i) + "] = " + LOKI97_Algorithm.longToString(P[i]));
            }
            ++i;
        }
        time = System.currentTimeMillis() - time;
        if (debuglevel > 8) {
            System.out.println("==========");
            System.out.println();
            System.out.println("Static Data");
            System.out.println();
            System.out.println("S1[]:");
            i = 0;
            while (i < 512) {
                System.out.print(String.valueOf(LOKI97_Algorithm.shortToString(i)) + ": ");
                j = 0;
                while (j < 16) {
                    System.out.print(String.valueOf(LOKI97_Algorithm.byteToString(S1[i * 16 + j])) + " ");
                    ++j;
                }
                System.out.println();
                ++i;
            }
            System.out.println();
            System.out.println("S2[]:");
            i = 0;
            while (i < 128) {
                System.out.print(String.valueOf(LOKI97_Algorithm.shortToString(i)) + ": ");
                j = 0;
                while (j < 16) {
                    System.out.print(String.valueOf(LOKI97_Algorithm.byteToString(S2[i * 16 + j])) + " ");
                    ++j;
                }
                System.out.println();
                ++i;
            }
            System.out.println();
            System.out.println("P[]:");
            i = 0;
            while (i < 256) {
                System.out.println(String.valueOf(LOKI97_Algorithm.byteToString(i)) + ": " + LOKI97_Algorithm.longToString(P[i]));
                ++i;
            }
            System.out.println();
            System.out.println("Total initialization time: " + time + " ms.");
            System.out.println();
        }
    }
}

