/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.JceSecurity;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;

public class KeyAgreement {
    private Provider provider;
    private KeyAgreementSpi keyAgreeSpi;
    private String algorithm;

    protected KeyAgreement(KeyAgreementSpi keyAgreementSpi, Provider provider, String string) {
        this.keyAgreeSpi = keyAgreementSpi;
        this.provider = provider;
        this.algorithm = string;
    }

    public final Key doPhase(Key key, boolean bl) throws InvalidKeyException, IllegalStateException {
        return this.keyAgreeSpi.engineDoPhase(key, bl);
    }

    public final byte[] generateSecret() throws IllegalStateException {
        return this.keyAgreeSpi.engineGenerateSecret();
    }

    public final SecretKey generateSecret(String string) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        return this.keyAgreeSpi.engineGenerateSecret(string);
    }

    public final int generateSecret(byte[] byArray, int n) throws IllegalStateException, ShortBufferException {
        return this.keyAgreeSpi.engineGenerateSecret(byArray, n);
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public static final KeyAgreement getInstance(String string) throws NoSuchAlgorithmException {
        try {
            Object[] objectArray = JceSecurity.getImpl(string, "KeyAgreement", null);
            return new KeyAgreement((KeyAgreementSpi)objectArray[0], (Provider)objectArray[1], string);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException(String.valueOf(string) + " not found");
        }
    }

    public static final KeyAgreement getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        Object[] objectArray = JceSecurity.getImpl(string, "KeyAgreement", string2);
        return new KeyAgreement((KeyAgreementSpi)objectArray[0], (Provider)objectArray[1], string);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(Key key) throws InvalidKeyException {
        this.keyAgreeSpi.engineInit(key, new SecureRandom());
    }

    public final void init(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.keyAgreeSpi.engineInit(key, secureRandom);
    }

    public final void init(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.keyAgreeSpi.engineInit(key, algorithmParameterSpec, new SecureRandom());
    }

    public final void init(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.keyAgreeSpi.engineInit(key, algorithmParameterSpec, secureRandom);
    }
}

