/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.MacSpi;
import javax.crypto.SecretKey;

public final class HmacMD5
extends MacSpi
implements Cloneable {
    private MessageDigest md5 = MessageDigest.getInstance("MD5");
    private byte[] k_ipad = new byte[64];
    private byte[] k_opad = new byte[64];
    private boolean first = true;
    private static final int MD5_LENGTH = 16;
    private static final int MD5_BLOCK_LENGTH = 64;

    public Object clone() {
        HmacMD5 hmacMD5 = null;
        try {
            hmacMD5 = (HmacMD5)super.clone();
            hmacMD5.md5 = (MessageDigest)this.md5.clone();
            hmacMD5.k_ipad = (byte[])this.k_ipad.clone();
            hmacMD5.k_opad = (byte[])this.k_opad.clone();
            hmacMD5.first = this.first;
            return hmacMD5;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return hmacMD5;
        }
    }

    protected byte[] engineDoFinal() {
        if (this.first) {
            this.md5.update(this.k_ipad);
        } else {
            this.first = true;
        }
        byte[] byArray = this.md5.digest();
        this.md5.update(this.k_opad);
        return this.md5.digest(byArray);
    }

    protected int engineGetMacLength() {
        return this.md5.getDigestLength();
    }

    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (key == null || !(key instanceof SecretKey)) {
            throw new InvalidKeyException("Secret key expected");
        }
        byte[] byArray = key.getEncoded();
        if (byArray == null || byArray.length == 0) {
            throw new InvalidKeyException("Missing key data");
        }
        if (byArray.length > 64) {
            byArray = this.md5.digest(byArray);
        }
        byte[] byArray2 = new byte[64];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        int n = 64 - byArray.length;
        while (n < 64) {
            byArray2[n] = 0;
            ++n;
        }
        n = 0;
        while (n < 64) {
            this.k_ipad[n] = (byte)(byArray2[n] ^ 0x36);
            this.k_opad[n] = (byte)(byArray2[n] ^ 0x5C);
            ++n;
        }
        n = 0;
        while (n < byArray.length) {
            byArray[n] = 0;
            ++n;
        }
        n = 0;
        while (n < byArray2.length) {
            byArray2[n] = 0;
            ++n;
        }
        byArray = null;
        byArray2 = null;
    }

    protected void engineReset() {
        this.md5.reset();
        this.first = true;
    }

    protected void engineUpdate(byte by) {
        if (this.first) {
            this.md5.update(this.k_ipad);
            this.first = false;
        }
        this.md5.update(by);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) {
        if (this.first) {
            this.md5.update(this.k_ipad);
            this.first = false;
        }
        this.md5.update(byArray, n, n2);
    }
}

