/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.FeedbackCipher;
import com.sun.crypto.provider.SymmetricCipher;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.DESParameterSpec;

public class PCBC
extends SymmetricCipher
implements FeedbackCipher {
    private static final String MODE_NAME = "PCBC";
    private byte[] iv = null;
    private byte[] k;
    private SymmetricCipher embeddedCipher;
    private int blockSize = -1;

    public void decrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalBlockSizeException {
        int n4 = n + n2;
        while (n < n4) {
            this.embeddedCipher.decrypt(byArray, n, this.blockSize, byArray2, n3);
            int n5 = 0;
            while (n5 < this.blockSize) {
                int n6 = n5 + n3;
                byArray2[n6] = (byte)(byArray2[n6] ^ this.k[n5]);
                ++n5;
            }
            n5 = 0;
            while (n5 < this.blockSize) {
                this.k[n5] = (byte)(byArray2[n5 + n3] ^ byArray[n5 + n]);
                ++n5;
            }
            n3 += this.blockSize;
            n += this.blockSize;
        }
    }

    public void encrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalBlockSizeException {
        int n4 = n + n2;
        while (n < n4) {
            int n5 = 0;
            while (n5 < this.blockSize) {
                int n6 = n5;
                this.k[n6] = (byte)(this.k[n6] ^ byArray[n5 + n]);
                ++n5;
            }
            this.embeddedCipher.encrypt(this.k, 0, this.blockSize, byArray2, n3);
            n5 = 0;
            while (n5 < this.blockSize) {
                this.k[n5] = (byte)(byArray[n5 + n] ^ byArray2[n5 + n3]);
                ++n5;
            }
            n += this.blockSize;
            n3 += this.blockSize;
        }
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public String getFeedback() {
        return MODE_NAME;
    }

    public byte[] getIV() {
        return this.iv;
    }

    public void init(Key key) throws InvalidKeyException {
        this.embeddedCipher.init(key);
        SecureRandom secureRandom = new SecureRandom();
        this.iv = new byte[this.blockSize];
        secureRandom.nextBytes(this.iv);
        System.arraycopy(this.iv, 0, this.k, 0, this.blockSize);
    }

    public void init(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.embeddedCipher.init(key);
        if (algorithmParameterSpec == null || !(algorithmParameterSpec instanceof DESParameterSpec)) {
            throw new InvalidAlgorithmParameterException();
        }
        DESParameterSpec dESParameterSpec = (DESParameterSpec)algorithmParameterSpec;
        this.iv = dESParameterSpec.getIV();
        System.arraycopy(this.iv, 0, this.k, 0, this.blockSize);
    }

    public void reset() {
        System.arraycopy(this.iv, 0, this.k, 0, this.blockSize);
    }

    public void setEmbeddedCipher(SymmetricCipher symmetricCipher) throws NoSuchAlgorithmException {
        if (symmetricCipher == null || (this.blockSize = symmetricCipher.getBlockSize()) <= 0) {
            throw new NoSuchAlgorithmException("Incompatible algorithm type and mode");
        }
        this.embeddedCipher = symmetricCipher;
        this.k = new byte[this.blockSize];
    }
}

