/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.DESedeCipher;
import com.sun.crypto.provider.DESedeKey;
import com.sun.crypto.provider.PBEWithMD5AndDESCipher;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;

public final class PBEWithMD5AndTripleDESCipher
extends PBEWithMD5AndDESCipher {
    public PBEWithMD5AndTripleDESCipher() throws NoSuchAlgorithmException, NoSuchPaddingException {
        this.desCipher = new DESedeCipher();
        this.desCipher.engineSetMode("CBC");
        this.desCipher.engineSetPadding("PKCS5Padding");
    }

    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        try {
            int n2;
            if (algorithmParameterSpec == null || !(algorithmParameterSpec instanceof PBEParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Inappropriate parameter type");
            }
            if (key == null || !key.getAlgorithm().equalsIgnoreCase("PBE")) {
                throw new InvalidKeyException("Missing password");
            }
            byte[] byArray = key.getEncoded();
            byte[] byArray2 = ((PBEParameterSpec)algorithmParameterSpec).getSalt();
            if (byArray2.length != 8) {
                throw new InvalidAlgorithmParameterException("Salt does not have length 8");
            }
            int n3 = ((PBEParameterSpec)algorithmParameterSpec).getIterationCount();
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] byArray3 = null;
            IvParameterSpec ivParameterSpec = null;
            byte[] byArray4 = null;
            int n4 = 0;
            while (n4 < 4) {
                if (byArray2[n4] != byArray2[n4 + 4]) break;
                ++n4;
            }
            if (n4 == 4) {
                n4 = 0;
                while (n4 < 2) {
                    n2 = byArray2[n4];
                    byArray2[n4] = byArray2[3 - n4];
                    byArray2[2] = n2;
                    ++n4;
                }
            }
            n4 = 0;
            while (n4 < 2) {
                byArray4 = new byte[byArray2.length / 2];
                System.arraycopy(byArray2, n4 * (byArray2.length / 2), byArray4, 0, byArray4.length);
                n2 = 0;
                while (n2 < n3) {
                    messageDigest.update(byArray4);
                    messageDigest.update(byArray);
                    byArray4 = messageDigest.digest();
                    ++n2;
                }
                if (n4 == 0) {
                    byArray3 = new byte[24];
                    System.arraycopy(byArray4, 0, byArray3, 0, byArray4.length);
                } else {
                    System.arraycopy(byArray4, 0, byArray3, byArray4.length, byArray4.length / 2);
                    ivParameterSpec = new IvParameterSpec(byArray4, byArray4.length / 2, byArray4.length / 2);
                }
                ++n4;
            }
            Arrays.fill(byArray, (byte)0);
            DESedeKey dESedeKey = new DESedeKey(byArray3);
            this.desCipher.engineInit(n, (Key)dESedeKey, ivParameterSpec, secureRandom);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidKeyException(noSuchAlgorithmException.toString());
        }
    }
}

