/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.EncryptedPrivateKeyInfo;
import com.sun.crypto.provider.KeyProtector;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public final class JceKeyStore
extends KeyStoreSpi {
    private static final int MAGIC = -825307442;
    private static final int JAVAKEYSTORE_MAGIC = -17957139;
    private static final int VERSION_1 = 1;
    private Hashtable entries = new Hashtable();

    public Enumeration engineAliases() {
        return this.entries.keys();
    }

    public boolean engineContainsAlias(String string) {
        return this.entries.containsKey(string.toLowerCase());
    }

    public void engineDeleteEntry(String string) throws KeyStoreException {
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            this.entries.remove(string.toLowerCase());
        }
    }

    public Certificate engineGetCertificate(String string) {
        Object v = this.entries.get(string.toLowerCase());
        if (v != null) {
            if (v instanceof TrustedCertEntry) {
                return ((TrustedCertEntry)v).cert;
            }
            if (((KeyEntry)v).chain == null) {
                return null;
            }
            return ((KeyEntry)v).chain[0];
        }
        return null;
    }

    public String engineGetCertificateAlias(Certificate certificate) {
        Enumeration enumeration = this.entries.keys();
        while (enumeration.hasMoreElements()) {
            Certificate certificate2;
            String string = (String)enumeration.nextElement();
            Object v = this.entries.get(string);
            if (v instanceof TrustedCertEntry) {
                certificate2 = ((TrustedCertEntry)v).cert;
            } else {
                if (((KeyEntry)v).chain == null) continue;
                certificate2 = ((KeyEntry)v).chain[0];
            }
            if (!certificate2.equals(certificate)) continue;
            return string;
        }
        return null;
    }

    public Certificate[] engineGetCertificateChain(String string) {
        Object v = this.entries.get(string.toLowerCase());
        if (v != null && v instanceof KeyEntry) {
            if (((KeyEntry)v).chain == null) {
                return null;
            }
            return (Certificate[])((KeyEntry)v).chain.clone();
        }
        return null;
    }

    public Date engineGetCreationDate(String string) {
        Object v = this.entries.get(string.toLowerCase());
        if (v != null) {
            if (v instanceof TrustedCertEntry) {
                return new Date(((TrustedCertEntry)v).date.getTime());
            }
            return new Date(((KeyEntry)v).date.getTime());
        }
        return null;
    }

    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        EncryptedPrivateKeyInfo encryptedPrivateKeyInfo;
        Object v = this.entries.get(string.toLowerCase());
        if (v == null || !(v instanceof KeyEntry)) {
            return null;
        }
        KeyProtector keyProtector = new KeyProtector(cArray);
        byte[] byArray = ((KeyEntry)v).protectedPrivKey;
        try {
            encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(byArray);
        }
        catch (IOException iOException) {
            throw new UnrecoverableKeyException("Private key not stored as PKCS #8 EncryptedPrivateKeyInfo");
        }
        return keyProtector.recover(encryptedPrivateKeyInfo);
    }

    public boolean engineIsCertificateEntry(String string) {
        Object v = this.entries.get(string.toLowerCase());
        return v != null && v instanceof TrustedCertEntry;
    }

    public boolean engineIsKeyEntry(String string) {
        Object v = this.entries.get(string.toLowerCase());
        return v != null && v instanceof KeyEntry;
    }

    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            Object object;
            DataInputStream dataInputStream;
            MessageDigest messageDigest = null;
            CertificateFactory certificateFactory = null;
            ByteArrayInputStream byteArrayInputStream = null;
            byte[] byArray = null;
            if (cArray != null) {
                messageDigest = this.getPreKeyedHash(cArray);
                dataInputStream = new DataInputStream(new DigestInputStream(inputStream, messageDigest));
            } else {
                dataInputStream = new DataInputStream(inputStream);
            }
            int n = dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            if (!(n == -825307442 && n2 == 1 || n == -17957139 && n2 == 1)) {
                throw new IOException("Invalid keystore format");
            }
            this.entries.clear();
            int n3 = dataInputStream.readInt();
            int n4 = 0;
            while (n4 < n3) {
                Object object2;
                int n5 = dataInputStream.readInt();
                certificateFactory = CertificateFactory.getInstance("X509");
                if (n5 == 1) {
                    object2 = new KeyEntry();
                    object = dataInputStream.readUTF();
                    ((KeyEntry)object2).date = new Date(dataInputStream.readLong());
                    try {
                        ((KeyEntry)object2).protectedPrivKey = new byte[dataInputStream.readInt()];
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        throw new IOException("Keysize too big");
                    }
                    dataInputStream.readFully(((KeyEntry)object2).protectedPrivKey);
                    try {
                        ((KeyEntry)object2).chain = new Certificate[dataInputStream.readInt()];
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        throw new IOException("Too many certificates in chain");
                    }
                    int n6 = 0;
                    while (n6 < ((KeyEntry)object2).chain.length) {
                        try {
                            byArray = new byte[dataInputStream.readInt()];
                        }
                        catch (OutOfMemoryError outOfMemoryError) {
                            throw new IOException("Certificate too big");
                        }
                        dataInputStream.readFully(byArray);
                        byteArrayInputStream = new ByteArrayInputStream(byArray);
                        ((KeyEntry)object2).chain[n6] = certificateFactory.generateCertificate(byteArrayInputStream);
                        ((InputStream)byteArrayInputStream).close();
                        ++n6;
                    }
                    this.entries.put(object, object2);
                } else if (n5 == 2) {
                    object2 = new TrustedCertEntry();
                    object = dataInputStream.readUTF();
                    ((TrustedCertEntry)object2).date = new Date(dataInputStream.readLong());
                    try {
                        byArray = new byte[dataInputStream.readInt()];
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        throw new IOException("Certificate too big");
                    }
                    dataInputStream.readFully(byArray);
                    byteArrayInputStream = new ByteArrayInputStream(byArray);
                    ((TrustedCertEntry)object2).cert = certificateFactory.generateCertificate(byteArrayInputStream);
                    ((InputStream)byteArrayInputStream).close();
                    this.entries.put(object, object2);
                } else {
                    throw new IOException("Unrecognized keystore entry");
                }
                ++n4;
            }
            if (cArray != null) {
                byte[] byArray2 = messageDigest.digest();
                object = new byte[byArray2.length];
                dataInputStream.readFully((byte[])object);
                int n7 = 0;
                while (n7 < byArray2.length) {
                    if (byArray2[n7] != object[n7]) {
                        throw new IOException("Keystore was tampered with, or password was incorrect");
                    }
                    ++n7;
                }
            }
        }
    }

    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            Object v = this.entries.get(string.toLowerCase());
            if (v != null && v instanceof KeyEntry) {
                throw new KeyStoreException("Cannot overwrite own certificate");
            }
            TrustedCertEntry trustedCertEntry = new TrustedCertEntry();
            trustedCertEntry.cert = certificate;
            trustedCertEntry.date = new Date();
            this.entries.put(string.toLowerCase(), trustedCertEntry);
        }
    }

    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        try {
            Hashtable hashtable = this.entries;
            synchronized (hashtable) {
                KeyEntry keyEntry = new KeyEntry();
                keyEntry.date = new Date();
                KeyProtector keyProtector = new KeyProtector(cArray);
                keyEntry.protectedPrivKey = keyProtector.protect(key);
                if (certificateArray != null) {
                    keyEntry.chain = (Certificate[])certificateArray.clone();
                }
                this.entries.put(string.toLowerCase(), keyEntry);
            }
        }
        catch (Exception exception) {
            throw new KeyStoreException(exception.getMessage());
        }
    }

    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            KeyEntry keyEntry = new KeyEntry();
            keyEntry.date = new Date();
            keyEntry.protectedPrivKey = (byte[])byArray.clone();
            if (certificateArray != null) {
                keyEntry.chain = (Certificate[])certificateArray.clone();
            }
            this.entries.put(string.toLowerCase(), keyEntry);
        }
    }

    public int engineSize() {
        return this.entries.size();
    }

    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            Object object;
            if (cArray == null) {
                throw new IllegalArgumentException("password can't be null");
            }
            MessageDigest messageDigest = this.getPreKeyedHash(cArray);
            DataOutputStream dataOutputStream = new DataOutputStream(new DigestOutputStream(outputStream, messageDigest));
            dataOutputStream.writeInt(-825307442);
            dataOutputStream.writeInt(1);
            dataOutputStream.writeInt(this.entries.size());
            Enumeration enumeration = this.entries.keys();
            while (enumeration.hasMoreElements()) {
                byte[] byArray;
                object = (String)enumeration.nextElement();
                Object v = this.entries.get(object);
                if (v instanceof KeyEntry) {
                    dataOutputStream.writeInt(1);
                    dataOutputStream.writeUTF((String)object);
                    dataOutputStream.writeLong(((KeyEntry)v).date.getTime());
                    dataOutputStream.writeInt(((KeyEntry)v).protectedPrivKey.length);
                    dataOutputStream.write(((KeyEntry)v).protectedPrivKey);
                    int n = ((KeyEntry)v).chain == null ? 0 : ((KeyEntry)v).chain.length;
                    dataOutputStream.writeInt(n);
                    int n2 = 0;
                    while (n2 < n) {
                        byArray = ((KeyEntry)v).chain[n2].getEncoded();
                        dataOutputStream.writeInt(byArray.length);
                        dataOutputStream.write(byArray);
                        ++n2;
                    }
                    continue;
                }
                dataOutputStream.writeInt(2);
                dataOutputStream.writeUTF((String)object);
                dataOutputStream.writeLong(((TrustedCertEntry)v).date.getTime());
                byArray = ((TrustedCertEntry)v).cert.getEncoded();
                dataOutputStream.writeInt(byArray.length);
                dataOutputStream.write(byArray);
            }
            object = messageDigest.digest();
            dataOutputStream.write((byte[])object);
            dataOutputStream.flush();
        }
    }

    private MessageDigest getPreKeyedHash(char[] cArray) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA");
        byte[] byArray = new byte[cArray.length * 2];
        int n = 0;
        int n2 = 0;
        while (n < cArray.length) {
            byArray[n2++] = (byte)(cArray[n] >> 8);
            byArray[n2++] = (byte)cArray[n];
            ++n;
        }
        messageDigest.update(byArray);
        n = 0;
        while (n < byArray.length) {
            byArray[n] = 0;
            ++n;
        }
        messageDigest.update("Mighty Aphrodite".getBytes("UTF8"));
        return messageDigest;
    }

    class KeyEntry {
        Date date;
        byte[] protectedPrivKey;
        Certificate[] chain;

        KeyEntry() {
        }
    }

    class TrustedCertEntry {
        Date date;
        Certificate cert;

        TrustedCertEntry() {
        }
    }
}

