/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import java.security.InvalidKeyException;
import java.util.Arrays;
import javax.crypto.SecretKey;

class DESKey
implements SecretKey {
    private byte[] key;

    public DESKey(byte[] byArray) throws InvalidKeyException {
        this(byArray, 0);
    }

    public DESKey(byte[] byArray, int n) throws InvalidKeyException {
        if (byArray == null || byArray.length - n < 8) {
            throw new InvalidKeyException("Wrong key size");
        }
        this.key = new byte[8];
        System.arraycopy(byArray, n, this.key, 0, 8);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SecretKey)) {
            return false;
        }
        String string = ((SecretKey)object).getAlgorithm();
        if (!string.equalsIgnoreCase("DES")) {
            return false;
        }
        byte[] byArray = ((SecretKey)object).getEncoded();
        boolean bl = Arrays.equals(this.key, byArray);
        Arrays.fill(byArray, (byte)0);
        return bl;
    }

    protected void finalize() {
        if (this.key != null) {
            Arrays.fill(this.key, (byte)0);
            this.key = null;
        }
    }

    public String getAlgorithm() {
        return "DES";
    }

    public byte[] getEncoded() {
        return (byte[])this.key.clone();
    }

    public String getFormat() {
        return "RAW";
    }

    public int hashCode() {
        int n = 0;
        int n2 = 1;
        while (n2 < this.key.length) {
            n += this.key[n2] * n2;
            ++n2;
        }
        return n ^= "des".hashCode();
    }
}

