/*
 * Decompiled with CFR 0.152.
 */
package cryptix.test;

import cryptix.provider.key.RawSecretKey;
import cryptix.util.core.ArrayUtil;
import cryptix.util.core.Hex;
import java.io.PrintStream;
import java.security.Cipher;
import java.security.FeedbackCipher;
import java.security.Key;

public class TestIDEA {
    private static final String[][] testData1 = new String[][]{{"00010002000300040005000600070008", "0000000100020003", "11FBED2B01986DE5"}, {"00010002000300040005000600070008", "0102030405060708", "540E5FEA18C2F8B1"}, {"00010002000300040005000600070008", "0019324B647D96AF", "9F0A0AB6E10CED78"}, {"00010002000300040005000600070008", "F5202D5B9C671B08", "CF18FD7355E2C5C5"}, {"00010002000300040005000600070008", "FAE6D2BEAA96826E", "85DF52005608193D"}, {"00010002000300040005000600070008", "0A141E28323C4650", "2F7DE750212FB734"}, {"00010002000300040005000600070008", "050A0F14191E2328", "7B7314925DE59C09"}, {"0005000A000F00140019001E00230028", "0102030405060708", "3EC04780BEFF6E20"}, {"3A984E2000195DB32EE501C8C47CEA60", "0102030405060708", "97BCD8200780DA86"}, {"006400C8012C019001F4025802BC0320", "05320A6414C819FA", "65BE87E7A2538AED"}, {"9D4075C103BC322AFB03E7BE6AB30006", "0808080808080808", "F5DB1AC45E5EF9F9"}};
    private static final String[][] testData2 = new String[][]{{"00010002000300040005000600070008", "0000000100020003"}, {"00010002000300040005000600070008", "01020304050607084E"}, {"00010002000300040005000600070008", "0019324B647D96AF4E2019"}, {"00010002000300040005000600070008", "F5202D5B9C671B084E2009"}, {"00010002000300040005000600070008", "FAE6D2BEAA96826E4E200019"}, {"00010002000300040005000600070008", "0A141E28323C46504E200019"}, {"00010002000300040005000600070008", "050A0F14191E23284E2019"}, {"0005000A000F00140019001E00230028", "01020304050607080A000F"}, {"3A984E2000195DB32EE501C8C47CEA60", "0102030405060708EA60"}, {"006400C8012C019001F4025802BC0320", "05320A6414C819FA025802BC0320"}, {"9D4075C103BC322AFB03E7BE6AB30006", "08080808080808086AB30006"}};

    public TestIDEA() {
        try {
            System.out.println("*** IDEA in ECB mode:\n");
            Cipher cipher = Cipher.getInstance((String)"IDEA", (String)"Cryptix");
            this.test1(cipher, System.out, testData1);
            System.out.println("\n*** IDEA in CFB mode:\n");
            cipher = Cipher.getInstance((String)"IDEA/CFB", (String)"Cryptix");
            this.test2(cipher, System.out, testData2);
            System.out.println("\n*** IDEA in OFB mode:\n");
            cipher = Cipher.getInstance((String)"IDEA/OFB", (String)"Cryptix");
            this.test2(cipher, System.out, testData2);
            System.out.println("\n*** IDEA in CFB-PGP mode:\n");
            cipher = Cipher.getInstance((String)"IDEA/CFB-PGP", (String)"Cryptix");
            this.test2(cipher, System.out, testData2);
            System.out.println("\n*** IDEA in CBC mode with PKCS#5 padding:\n");
            cipher = Cipher.getInstance((String)"IDEA/CBC/PKCS#5", (String)"Cryptix");
            this.test2(cipher, System.out, testData2);
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public static final void main(String[] stringArray) {
        System.out.println("*** IDEA:\n");
        new TestIDEA();
    }

    private void test1(Cipher cipher, PrintStream printStream, String[][] stringArray) throws Exception {
        int n = 0;
        while (n < stringArray.length) {
            RawSecretKey rawSecretKey = new RawSecretKey("IDEA", Hex.fromString((String)stringArray[n][0]));
            cipher.initEncrypt((Key)rawSecretKey);
            byte[] byArray = cipher.crypt(Hex.fromString((String)stringArray[n][1]));
            String string = Hex.toString((byte[])byArray);
            printStream.println("...");
            cipher.initDecrypt((Key)rawSecretKey);
            byte[] byArray2 = cipher.crypt(byArray);
            String string2 = Hex.toString((byte[])byArray2);
            printStream.println("plain:" + stringArray[n][1] + " enc:" + string + " calc:" + stringArray[n][2]);
            if (string.equals(stringArray[n][2])) {
                printStream.println(" ********* IDEA ENC GOOD ********* ");
            } else {
                printStream.println(" ********* IDEA ENC FAILED ********* ");
            }
            printStream.println("  enc:" + Hex.toString((byte[])byArray) + " dec:" + string2 + " calc:" + stringArray[n][1]);
            if (string2.equals(stringArray[n][1])) {
                printStream.println(" ********* IDEA DEC GOOD ********* ");
            } else {
                printStream.println(" ********* IDEA DEC FAILED ********* ");
            }
            ++n;
        }
    }

    private void test2(Cipher cipher, PrintStream printStream, String[][] stringArray) throws Exception {
        byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        ((FeedbackCipher)cipher).setInitializationVector(byArray);
        int n = 0;
        while (n < stringArray.length) {
            RawSecretKey rawSecretKey = new RawSecretKey("IDEA", Hex.fromString((String)stringArray[n][0]));
            cipher.initEncrypt((Key)rawSecretKey);
            byte[] byArray2 = Hex.fromString((String)stringArray[n][1]);
            byte[] byArray3 = cipher.crypt(byArray2);
            printStream.println("...");
            cipher.initDecrypt((Key)rawSecretKey);
            byte[] byArray4 = cipher.crypt(byArray3);
            printStream.println("plain:" + Hex.toString((byte[])byArray2) + " enc:" + Hex.toString((byte[])byArray3) + " dec:" + Hex.toString((byte[])byArray4));
            if (ArrayUtil.areEqual((byte[])byArray2, (byte[])byArray4)) {
                printStream.println(" ********* IDEA FEEDBACK GOOD ********* ");
            } else {
                printStream.println(" ********* IDEA FEEDBACK FAILED ********* ");
            }
            ++n;
        }
    }
}

