/*
 * Decompiled with CFR 0.152.
 */
package cryptix.test;

import cryptix.provider.key.RawSecretKey;
import cryptix.util.core.ArrayUtil;
import cryptix.util.core.Hex;
import java.security.Cipher;
import java.security.Key;
import java.util.Date;

public final class TestCAST5 {
    private static Cipher alg;
    private static final byte[] input;

    private TestCAST5() {
        System.out.println("*** CAST5 (CAST-128):\n");
        try {
            this.test1();
            this.test2();
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public static final void main(String[] stringArray) {
        try {
            alg = Cipher.getInstance((String)"CAST-128", (String)"Cryptix");
            new TestCAST5();
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    private void test1() throws Exception {
        String[][] stringArrayArray = new String[][]{{"0123456712345678234567893456789A", "238B4FE5847E44B2"}, {"01234567123456782345", "EB6A711A2C02271B"}, {"0123456712", "7AC816D16E9B302E"}};
        int n = 0;
        while (n < stringArrayArray.length) {
            RawSecretKey rawSecretKey = new RawSecretKey("CAST5", Hex.fromString((String)stringArrayArray[n][0]));
            byte[] byArray = Hex.fromString((String)stringArrayArray[n][1]);
            System.out.println("\nTest vector (" + 4 * stringArrayArray[n][0].length() + "-bit key):");
            System.out.println("\nEncrypting:");
            alg.initEncrypt((Key)rawSecretKey);
            this.compareIt(alg.crypt(input), byArray);
            System.out.println("\nDecrypting:");
            alg.initDecrypt((Key)rawSecretKey);
            this.compareIt(alg.crypt(byArray), input);
            ++n;
        }
    }

    private void test2() throws Exception {
        int n;
        RawSecretKey rawSecretKey = new RawSecretKey("CAST5", Hex.fromString((String)"0123456712"));
        byte[] byArray = Hex.fromString((String)"0123456789ABCDEF");
        alg.initEncrypt((Key)rawSecretKey);
        System.out.println("\nSpeed test (10,000 x 8-byte w/40-bit key):\n");
        System.out.println("...Encryption\n");
        System.out.println("      start date/time: " + new Date().toString());
        int n2 = 0;
        while (n2 < 10) {
            n = 0;
            while (n < 1000) {
                alg.crypt(byArray, 0, 8, byArray, 0);
                ++n;
            }
            ++n2;
        }
        System.out.println("     finish date/time: " + new Date().toString());
        alg.initDecrypt((Key)rawSecretKey);
        System.out.println("\n...Decryption\n");
        System.out.println("      start date/time: " + new Date().toString());
        n = 0;
        while (n < 10) {
            int n3 = 0;
            while (n3 < 1000) {
                alg.crypt(byArray, 0, 8, byArray, 0);
                ++n3;
            }
            ++n;
        }
        System.out.println("     finish date/time: " + new Date().toString());
        System.out.println("\n result:");
        this.compareIt(byArray, input);
    }

    private void test3() throws Exception {
        byte[] byArray = Hex.fromString((String)"0123456712345678234567893456789A");
        byte[] byArray2 = Hex.fromString((String)"0123456712345678234567893456789A");
        byte[] byArray3 = Hex.fromString((String)"EEA9D0A249FD3BA6B3436FB89D6DCA92");
        byte[] byArray4 = Hex.fromString((String)"B2C95EB00C31AD7180AC05B8E83D696E");
        System.out.println("\nTest 1,000,000 encryptions with 128-bit key:\n");
        System.out.println("  start date/time: " + new Date().toString());
        int n = 0;
        while (n < 1000) {
            int n2 = 0;
            while (n2 < 1000) {
                alg.initEncrypt((Key)new RawSecretKey("CAST5", byArray2));
                byArray = alg.crypt(byArray);
                alg.initEncrypt((Key)new RawSecretKey("CAST5", byArray));
                byArray2 = alg.crypt(byArray2);
                ++n2;
            }
            ++n;
        }
        System.out.println(" finish date/time: " + new Date().toString());
        System.out.println("\n result for 'a'\n");
        this.compareIt(byArray, byArray3);
        System.out.println("\n result for 'b'\n");
        this.compareIt(byArray2, byArray4);
    }

    private void compareIt(byte[] byArray, byte[] byArray2) {
        if (byArray.length < 33) {
            System.out.println("  computed: " + Hex.toString((byte[])byArray));
            System.out.println(" certified: " + Hex.toString((byte[])byArray2));
        } else {
            System.out.println("  computed: ");
            Hex.dumpString((byte[])byArray);
            System.out.println(" certified: ");
            Hex.dumpString((byte[])byArray2);
        }
        System.out.println(ArrayUtil.areEqual((byte[])byArray, (byte[])byArray2) ? " *** GOOD" : " *** FAILED");
    }

    static {
        input = Hex.fromString((String)"0123456789ABCDEF");
    }
}

