/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.key;

import cryptix.provider.key.RawKeyGenerator;
import java.security.InvalidKeyException;
import java.security.WeakKeyException;

public class DESKeyGenerator
extends RawKeyGenerator {
    public DESKeyGenerator() {
        super("DES", 8);
    }

    protected DESKeyGenerator(String string, int n) {
        super(string, n);
    }

    protected byte[] engineGenerateKey(byte[] byArray) throws WeakKeyException, InvalidKeyException {
        byArray = super.engineGenerateKey(byArray);
        this.setParity(byArray);
        return byArray;
    }

    protected void setParity(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            byte by = byArray[n];
            byArray[n] = (byte)(by & 0xFE | (by >> 1 ^ by >> 2 ^ by >> 3 ^ by >> 4 ^ by >> 5 ^ by >> 6 ^ by >> 7) & 1);
            ++n;
        }
    }

    protected boolean isWeak(byte[] byArray) {
        return this.isWeak(byArray, 0);
    }

    protected boolean isWeak(byte[] byArray, int n) {
        int n2 = (byArray[n] & 0xFE) << 8 | byArray[n + 1] & 0xFE;
        int n3 = (byArray[n + 2] & 0xFE) << 8 | byArray[n + 3] & 0xFE;
        int n4 = (byArray[n + 4] & 0xFE) << 8 | byArray[n + 5] & 0xFE;
        int n5 = (byArray[n + 6] & 0xFE) << 8 | byArray[n + 7] & 0xFE;
        return !(n2 != 0 && n2 != 65278 || n3 != 0 && n3 != 65278 || n4 != 0 && n4 != 65278) && (n5 == 0 || n5 == 65278);
    }
}

