/*
 * Decompiled with CFR 0.152.
 */
package cryptix.security;

import cryptix.security.MessageDigest;
import cryptix.util.core.ArrayUtil;
import cryptix.util.core.Hex;

public class MessageHash {
    private String algorithm;
    private byte[] hash;

    public MessageHash(String string, byte[] byArray) {
        if (string == null) {
            throw new NullPointerException("algorithm == null");
        }
        this.hash = new byte[byArray.length];
        this.algorithm = string.equals("SHA-0") ? "SHA0" : (string.equals("SHA-1") ? "SHA" : string);
        System.arraycopy(byArray, 0, this.hash, 0, byArray.length);
    }

    public static MessageHash fromDigest(MessageDigest messageDigest) {
        return new MessageHash(messageDigest.name(), messageDigest.digest());
    }

    public static MessageHash fromDigest(MessageDigest messageDigest, byte[] byArray) {
        return new MessageHash(messageDigest.name(), messageDigest.digest(byArray));
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public final byte[] toByteArray() {
        byte[] byArray = new byte[this.hash.length];
        System.arraycopy(this.hash, 0, byArray, 0, this.hash.length);
        return byArray;
    }

    public final int length() {
        return this.hash.length;
    }

    public int hashCode() {
        switch (this.hash.length) {
            case 0: {
                return 0;
            }
            case 1: {
                return this.hash[0];
            }
            case 2: {
                return this.hash[0] ^ this.hash[1] << 8;
            }
            case 3: {
                return this.hash[0] ^ this.hash[1] << 8 ^ this.hash[2] << 16;
            }
        }
        return this.hash[0] ^ this.hash[1] << 8 ^ this.hash[2] << 16 ^ this.hash[3] << 24;
    }

    public boolean equals(Object object) {
        if (!(object instanceof MessageHash)) {
            return false;
        }
        MessageHash messageHash = (MessageHash)object;
        return this.getAlgorithm().equals(messageHash.getAlgorithm()) && ArrayUtil.areEqual((byte[])this.hash, (byte[])messageHash.hash);
    }

    public String toString() {
        return String.valueOf(this.getAlgorithm()) + ":" + Hex.toString((byte[])this.hash);
    }
}

