/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.elgamal;

import cryptix.provider.elgamal.BaseElGamalParams;
import java.math.BigInteger;
import java.security.InvalidParameterException;
import java.security.interfaces.ElGamalParams;

public class GenericElGamalParameterSet {
    private int[] primeLengths;
    private String[][] precomputed;

    protected GenericElGamalParameterSet(int[] nArray, String[][] stringArray) {
        if (stringArray.length != nArray.length) {
            throw new IllegalArgumentException("array lengths do not match");
        }
        this.primeLengths = nArray;
        this.precomputed = stringArray;
    }

    public ElGamalParams getParameters(int n) {
        int n2 = 0;
        while (n2 < this.primeLengths.length) {
            if (n == this.primeLengths[n2]) {
                return new BaseElGamalParams(new BigInteger(this.precomputed[n2][0], 16), this.precomputed[n2][1] != null ? new BigInteger(this.precomputed[n2][1], 16) : null);
            }
            ++n2;
        }
        return null;
    }

    public void checkSane() throws InvalidParameterException {
        int n = 0;
        while (n < this.primeLengths.length) {
            BigInteger bigInteger = new BigInteger(this.precomputed[n][0]);
            if (bigInteger.bitLength() < this.primeLengths[n]) {
                throw new InvalidParameterException(String.valueOf(bigInteger) + " has incorrect bit length");
            }
            BigInteger bigInteger2 = new BigInteger(this.precomputed[n][1]);
            if (!bigInteger.isProbablePrime(80)) {
                throw new InvalidParameterException(String.valueOf(bigInteger) + " is not prime");
            }
            if (bigInteger2.compareTo(bigInteger) >= 0) {
                throw new InvalidParameterException("g >= p");
            }
            ++n;
        }
    }
}

