/*
This code is copyright (C) 1998 Robert O'Callahan.
This code is free for non-commercial use. Modification in all forms is permitted.
This license continues to apply to any modified versions. This license text must be
reproduced and distributed with any modified versions.
As a matter of courtesy I (Robert O'Callahan) would like to be informed of
any potentially useful modifications.
*/

#ifndef __AUTH_H
#define __AUTH_H

#include <stdio.h>

#include "rsa.h"

typedef struct {
  SSHAuthMethod method;
  char FAR * password;
  char FAR * rhosts_client_user;
  RSA FAR * RSA_key;
} AUTHCred;

typedef struct {
  char FAR * user;
  AUTHCred cur_cred;
  SSHAuthMethod failed_method;
  int supported_types;
  HWND auth_dialog;
} AUTHState;

void AUTH_init(struct _TInstVar FAR * pvar);
char FAR * AUTH_get_user_name(struct _TInstVar FAR * pvar);
int AUTH_set_supported_auth_types(struct _TInstVar FAR * pvar, int types);
void AUTH_advance_to_next_cred(struct _TInstVar FAR * pvar);
void AUTH_do_cred_dialog(struct _TInstVar FAR * pvar);
void AUTH_do_default_cred_dialog(struct _TInstVar FAR * pvar);
void AUTH_destroy_cur_cred(struct _TInstVar FAR * pvar);
void AUTH_get_auth_info(struct _TInstVar FAR * pvar, char FAR * dest, int len);
void AUTH_notify_disconnecting(struct _TInstVar FAR * pvar);
void AUTH_end(struct _TInstVar FAR * pvar);

#define AUTH_get_cur_cred(pvar) (&(pvar)->auth_state.cur_cred)

#endif
