#include "defs.h"
#if 0
#include <stdio.h>
#ifdef HASSTDLIB
#include <stdlib.h>
#else
#include <sys/types.h>
#endif
#endif
#include <string.h>
#ifdef	__MSDOS__
#include <dos.h>
#else	/* Assume BSD unix */
#include <fcntl.h>
#include <sgtty.h>
#endif
#include "interfac.h"

/* NOTE:  All MD5 ifdef's were done by Dan McD. */

#include "global.h"
#include "md5.h"
#include "md4.h"

extern int md5flag;

/* Crunch a key:
 * concatenate the seed and the password, run through MD4 and
 * collapse to 64 bits. This is defined as the user's starting key.
 */
int
keycrunch(result,seed,passwd)
char *result;	/* 8-byte result */
char *seed;	/* Seed, any length */
char *passwd;	/* Password, any length */
{
	char *buf;
	MD5_CTX md5;
	MD4_CTX md4;
	unsigned long results[4];
	unsigned int buflen;
	
	buflen = strlen(seed) + strlen(passwd);
#if 0	/*LX system manager*/
	if((buf = malloc(buflen+1)) == NULL)
		return -1;
#else
	if ((buf = m_alloc(buflen + 1)) == NULL)
		return -1;
#endif
	strcpy(buf,seed);
	strcat(buf,passwd);

	/* Crunch the key through MD[45] */
	if (md5flag)
	{
		MD5Init(&md5);
		MD5Update(&md5, (unsigned char *)buf, buflen);
		MD5Final((unsigned char *)results, &md5);
	}
	else
	{
		MD4Init(&md4);
		MD4Update(&md4, (unsigned char *)buf, buflen);
		MD4Final((unsigned char *)results, &md4);
	}
#if 0	/*LX system manager*/
	free(buf);
#else
	m_free(buf);
#endif

	results[0] ^= results[2];
	results[1] ^= results[3];

	memcpy(result,(char *)results,8);

	return 0;
}

/* The one-way function f(). Takes 8 bytes and returns 8 bytes in place */
void
f(x)
char *x;
{
        MD5_CTX md5;
	MD4_CTX md4;
	unsigned long results[4];

	if (md5flag)
	{
		MD5Init(&md5);
		MD5Update(&md5, (unsigned char *)x, 8);
		MD5Final((unsigned char *)results, &md5);
	}
	else
	{
		MD4Init(&md4);
		MD4Update(&md4, (unsigned char *)x, 8);
		MD4Final((unsigned char *)results, &md4);
	}
	/* Fold 128 to 64 bits */
	results[0] ^= results[2];
	results[1] ^= results[3];

	/* Only works on byte-addressed little-endian machines!! */
	memcpy(x, (char *)results, 8);
}

/* Strip trailing cr/lf from a line of text */
void
rip(buf)
char *buf;
{
	char *cp;

	if((cp = strchr(buf,'\r')) != NULL)
		*cp = '\0';

	if((cp = strchr(buf,'\n')) != NULL)
		*cp = '\0';
}
