/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.tags;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import sunw.hotjava.tags.EdgeInfo;
import sunw.hotjava.tags.FrameSetPanel;
import sunw.hotjava.tags.RuleWindow;

class ResizeTracker
implements MouseListener,
MouseMotionListener {
    private Point loc;
    private Rectangle travelLimits;
    private EdgeInfo edgeInfo;
    private FrameSetPanel owner;
    private Window sizingBar;
    private Cursor oldCursor;
    private Point displacement;
    private Component originComp;

    ResizeTracker(Point point, Rectangle rectangle, FrameSetPanel frameSetPanel, Component component, EdgeInfo edgeInfo) {
        this.travelLimits = rectangle;
        this.owner = frameSetPanel;
        this.edgeInfo = edgeInfo;
        this.originComp = component;
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
        this.oldCursor = frameSetPanel.getCursor();
        frameSetPanel.setCursor(Cursor.getPredefinedCursor(12));
        Container container = frameSetPanel.getParent();
        while (!(container instanceof Frame)) {
            container = container.getParent();
        }
        this.sizingBar = new RuleWindow((Frame)container);
        if (this.edgeInfo.isVertical()) {
            ((Component)this.sizingBar).setSize(rectangle.width, 1);
        } else {
            ((Component)this.sizingBar).setSize(1, rectangle.height);
        }
        this.displacement = this.computeDisplacement(component);
        this.setLocation(point);
        this.sizingBar.show();
    }

    private Point computeDisplacement(Component component) {
        Container container;
        Point point = new Point();
        do {
            Point point2 = component.getLocation();
            point.x += point2.x;
            point.y += point2.y;
            container = component.getParent();
            component = container;
        } while (container != this.owner);
        return point;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.setLocation(mouseEvent.getPoint());
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.owner.setCursor(this.oldCursor);
        this.originComp.removeMouseListener(this);
        this.originComp.removeMouseMotionListener(this);
        this.setLocation(mouseEvent.getPoint());
        ((Component)this.sizingBar).hide();
        this.sizingBar.dispose();
        this.owner.resizeFrames(this.edgeInfo, this.loc);
    }

    void setLocation(Point point) {
        point.x += this.displacement.x;
        point.y += this.displacement.y;
        this.loc = this.clampToLimits(point);
        Point point2 = this.owner.getLocationOnScreen();
        ((Component)this.sizingBar).setLocation(point2.x + this.loc.x, point2.y + this.loc.y);
    }

    private Point clampToLimits(Point point) {
        Dimension dimension = this.sizingBar.getSize();
        if (point.x < this.travelLimits.x) {
            point.x = this.travelLimits.x;
        } else if (point.x + dimension.width >= this.travelLimits.x + this.travelLimits.width) {
            point.x = this.travelLimits.x + this.travelLimits.width - dimension.width;
        }
        if (point.y < this.travelLimits.y) {
            point.y = this.travelLimits.y;
        } else if (point.y + dimension.height >= this.travelLimits.y + this.travelLimits.height) {
            point.y = this.travelLimits.y + this.travelLimits.height - dimension.height;
        }
        return point;
    }
}

