/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.doc;

import java.awt.Color;
import java.io.Serializable;
import sunw.hotjava.doc.DocConstants;
import sunw.hotjava.doc.DocFont;
import sunw.hotjava.doc.DocStyle;
import sunw.hotjava.misc.Globals;
import sunw.html.Element;

public class StyleSheet
implements DocConstants,
Serializable {
    static final int BOLD = 1;
    static final int ITALIC = 2;
    static final int BOLDITALIC = 3;
    static final int TYPEWRITER = 4;
    static final int UNDERLINE = 5;
    static final int SUPERSCRIPT = 6;
    static final int SUBSCRIPT = 7;
    static final int STRIKE = 8;
    static final long serialVersionUID = -8408749127228872445L;
    Element elem;
    public String type;
    public String fontName;
    public String label;
    public int fontStyle;
    public int absSize;
    public int relSize;
    public Color color;
    public boolean nobreak;
    public int above;
    public int below;
    public int left;
    public int right;
    public int format;

    StyleSheet() {
    }

    StyleSheet(Element element) {
        String string;
        String string2;
        this.elem = element;
        element.data = this;
        String string3 = element.getName();
        this.type = System.getProperty(String.valueOf(string3) + ".type", "unknown");
        this.fontName = System.getProperty(String.valueOf(string3) + ".font");
        this.label = System.getProperty(String.valueOf(string3) + ".label");
        if (this.label == null) {
            this.label = element.getName();
            if (this.label.length() > 3) {
                this.label = this.label.substring(0, 3);
            }
        }
        if ((string2 = System.getProperty(String.valueOf(string3) + ".size")) != null) {
            if (string2.startsWith("+")) {
                this.relSize = Integer.valueOf(string2.substring(1));
            } else if (string2.startsWith("-")) {
                this.relSize = -Integer.valueOf(string2.substring(1)).intValue();
            } else {
                this.absSize = Integer.valueOf(string2);
            }
        }
        if ((string = System.getProperty(String.valueOf(string3) + ".style")) != null) {
            if (string.equals("bold")) {
                this.fontStyle = 1;
            } else if (string.equals("italic")) {
                this.fontStyle = 2;
            } else if (string.equals("bolditalic")) {
                this.fontStyle = 3;
            } else if (string.equals("typewriter")) {
                this.fontStyle = 4;
            } else if (string.equals("underline")) {
                this.fontStyle = 5;
            } else if (string.equals("strike")) {
                this.fontStyle = 8;
            } else if (string.equals("superscript")) {
                this.fontStyle = 6;
            } else if (string.equals("subscript")) {
                this.fontStyle = 7;
            }
        }
        this.nobreak = System.getProperty(String.valueOf(string3) + ".nobreak") != null;
        this.color = Globals.getColor(String.valueOf(string3) + ".color", null);
        this.above = Integer.getInteger(String.valueOf(string3) + ".above", 0);
        this.below = Integer.getInteger(String.valueOf(string3) + ".below", 0);
        this.left = Integer.getInteger(String.valueOf(string3) + ".left", 0);
        this.right = Integer.getInteger(String.valueOf(string3) + ".right", 0);
        this.format = -1;
        String string4 = System.getProperty(String.valueOf(string3) + ".format");
        if (string4 != null) {
            if (string4.equals("left")) {
                this.format = 0;
                return;
            }
            if (string4.equals("right")) {
                this.format = 1;
                return;
            }
            if (string4.equals("center")) {
                this.format = 3;
                return;
            }
            if (string4.equals("none")) {
                this.format = 2;
                return;
            }
            if (string4.equals("justified")) {
                this.format = 0;
            }
        }
    }

    public void apply(DocStyle docStyle) {
        DocFont docFont = docStyle.font;
        if (this.fontName != null) {
            docFont = docFont.getName(this.fontName);
        }
        if (this.absSize != 0) {
            docFont = docFont.getIndex(this.absSize);
        } else if (this.relSize != 0) {
            docFont = docFont.getBigger(this.relSize);
        }
        switch (this.fontStyle) {
            case 1: {
                docFont = docFont.getBold();
                break;
            }
            case 2: {
                docFont = docFont.getItalic();
                break;
            }
            case 3: {
                docFont = docFont.getItalic().getBold();
                break;
            }
            case 4: {
                docFont = docFont.getTypewriter();
                break;
            }
            case 5: {
                docStyle.underline = true;
                break;
            }
            case 8: {
                docStyle.strike = true;
                break;
            }
            case 6: 
            case 7: {
                docStyle.script = this.fontStyle;
                docFont = docFont.getSmaller(2);
                break;
            }
        }
        if (this.nobreak) {
            docStyle.nobreak = true;
        }
        if (this.color != null) {
            docStyle.color = this.color;
        }
        if (this.format >= 0) {
            docStyle.format = this.format;
        }
        if (docStyle.font != docFont) {
            docStyle.font = docFont;
        }
    }

    public int getLeftIndent() {
        return this.left;
    }

    public int getRightIndent() {
        return this.right;
    }

    public String getLabel() {
        return this.label;
    }

    public static StyleSheet getStyleSheet(Element element) {
        if (element.data != null) {
            return (StyleSheet)element.data;
        }
        return new StyleSheet(element);
    }
}

