/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.doc;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;
import sun.awt.ScreenUpdater;
import sun.awt.UpdateClient;
import sunw.hotjava.doc.BasefontTagRecord;
import sunw.hotjava.doc.BlockTagItem;
import sunw.hotjava.doc.DocBusyException;
import sunw.hotjava.doc.DocConstants;
import sunw.hotjava.doc.DocError;
import sunw.hotjava.doc.DocException;
import sunw.hotjava.doc.DocItem;
import sunw.hotjava.doc.DocItemEnumeration;
import sunw.hotjava.doc.DocNotEditableException;
import sunw.hotjava.doc.DocParser;
import sunw.hotjava.doc.DocStyle;
import sunw.hotjava.doc.DocView;
import sunw.hotjava.doc.DocumentEvent;
import sunw.hotjava.doc.DocumentEventMulticaster;
import sunw.hotjava.doc.DocumentEventSource;
import sunw.hotjava.doc.DocumentListener;
import sunw.hotjava.doc.EmptyTagItem;
import sunw.hotjava.doc.EndTagItem;
import sunw.hotjava.doc.FlowTagItem;
import sunw.hotjava.doc.OverlappingStringMatch;
import sunw.hotjava.doc.Range;
import sunw.hotjava.doc.SizeItem;
import sunw.hotjava.doc.StyleSheet;
import sunw.hotjava.doc.TagItem;
import sunw.hotjava.doc.TextItem;
import sunw.hotjava.forms.FORM;
import sunw.hotjava.misc.Globals;
import sunw.hotjava.misc.ReleasableResource;
import sunw.hotjava.misc.URLConnector;
import sunw.hotjava.tags.APPLET;
import sunw.hotjava.tags.FRAME;
import sunw.hotjava.tags.IMG;
import sunw.hotjava.tags.ImageMap;
import sunw.html.Attributes;
import sunw.html.DTD;
import sunw.html.Element;
import sunw.html.HTMLOutputWriter;
import sunw.html.Parser;

public final class Document
implements DocConstants,
ReleasableResource,
PropertyChangeListener,
DocumentEventSource,
UpdateClient {
    int state;
    Thread owner;
    private Parser currentParser;
    private String pragma;
    Hashtable props = new Hashtable(11);
    int ncompleted = Short.MAX_VALUE;
    public int nitems;
    public DocItem[] items = new DocItem[10];
    DocumentEventMulticaster listeners = new DocumentEventMulticaster();
    private int nviews;
    private DocView[] views = new DocView[4];
    private BasefontTagRecord basefontTagRecord;
    private URLConnector connector;
    private boolean parsingCompleted = false;
    private String documentError;
    PropertyChangeSupport changes = new PropertyChangeSupport(this);
    VetoableChangeSupport vchanges = new VetoableChangeSupport(this);
    private Hashtable imageMaps;
    private Hashtable sizeItemListWidth;
    private Hashtable sizeItemListHeight;
    private static final Integer dummyInt = new Integer(0);
    private boolean bIsOkToFormat = false;
    private Stack timeOutStack = new Stack();

    public Document() {
        this(Globals.getDefaultDTD(), null, null, null, null);
    }

    public Document(String string) {
        this(Globals.getDefaultDTD(), null, string, null, null);
    }

    public Document(String string, String string2) {
        this(Globals.getDefaultDTD(), null, string, string2, null);
    }

    public Document(URL uRL) {
        this(Globals.getDefaultDTD(), uRL, null, null, null);
    }

    public Document(URL uRL, URL uRL2) {
        this(Globals.getDefaultDTD(), uRL, null, null, uRL2);
    }

    public Document(URL uRL, String string) {
        this(Globals.getDefaultDTD(), uRL, string, null, null);
    }

    public Document(DTD dTD, URL uRL, String string) {
        this(Globals.getDefaultDTD(), uRL, string, null, null);
    }

    public Document(DTD dTD, URL uRL, String string, String string2, URL uRL2) {
        this.basefontTagRecord = new BasefontTagRecord(this);
        try {
            this.setProperty("dtd", dTD);
            if (uRL != null) {
                this.setProperty("url", uRL);
            }
            if (string != null) {
                this.setProperty("title", string);
            }
            if (string2 != null) {
                this.setProperty("doctype", string2);
            }
            if (uRL2 != null) {
                this.setProperty("referer", uRL2);
            }
        }
        catch (DocException docException) {}
        this.sizeItemListWidth = new Hashtable();
        this.sizeItemListHeight = new Hashtable();
        this.bIsOkToFormat = false;
        this.setDocumentTitle(string);
    }

    public void addDocumentListener(DocumentListener documentListener) {
        this.listeners.add(documentListener);
    }

    public void removeDocumentListener(DocumentListener documentListener) {
        this.listeners.remove(documentListener);
    }

    public int getState() {
        return this.state;
    }

    public synchronized void setState(int n) throws DocBusyException {
        if (n >= 10 && this.owner != null && this.owner != Thread.currentThread()) {
            throw new DocBusyException(this, "document busy");
        }
        if (this.state != n) {
            this.state = n;
            this.dispatchDocumentEvent(1005, new Integer(n));
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean needsActivation(int var1_1) {
        if (this.items[var1_1].needsActivation()) ** GOTO lbl10
        return false;
lbl-1000:
        // 1 sources

        {
            var2_2 = this.items[var1_1];
            var3_3 = var2_2.offset;
            if (var3_3 > 0) {
                if (!var2_2.needsActivation()) continue;
                return false;
            }
            if (var3_3 >= 0) continue;
            var1_1 += var3_3;
lbl10:
            // 4 sources

            ** while (var1_1-- > 0)
        }
lbl11:
        // 1 sources

        return true;
    }

    public void setCompleted(int n) throws DocBusyException {
        Object object = Globals.getAwtLock();
        synchronized (object) {
            Document document = this;
            synchronized (document) {
                if (this.owner == null || this.owner != Thread.currentThread()) {
                    throw new DocBusyException(this, "not owner");
                }
                int n2 = n >> 16;
                if (this.ncompleted < n2) {
                    int n3 = Math.min(this.nitems, n2);
                    int n4 = this.ncompleted;
                    while (n4 < n3) {
                        short s = this.items[n4].offset;
                        if (s <= 0 && this.needsActivation(n4 + s)) {
                            this.notifyViews(20, n4 + s << 16, 1 - s << 16);
                        }
                        ++n4;
                    }
                } else {
                    int n5 = Math.min(this.nitems, this.ncompleted);
                    int n6 = n2;
                    while (n6 < n5) {
                        short s = this.items[n6].offset;
                        if (s <= 0 && this.needsActivation(n6 + s)) {
                            this.notifyViews(21, n6 + s << 16, 1 - s << 16);
                        }
                        ++n6;
                    }
                }
                this.ncompleted = n2;
                if (n == Integer.MAX_VALUE) {
                    this.notifyViews(22, 0, Integer.MAX_VALUE);
                    this.parsingCompleted = true;
                    Globals.registerTimeStamp(this.currentParser, "END PARSING");
                    this.dispatchFormatScreen();
                }
            }
            return;
        }
    }

    public void setParsingCompleted(boolean bl) {
        this.parsingCompleted = bl;
    }

    public boolean doneParsing() {
        return this.parsingCompleted;
    }

    public String getPragma() {
        return this.pragma;
    }

    public void setPragma(String string) {
        this.pragma = string;
    }

    public Object getProperty(String string) {
        Object v = this.props.get(string);
        return v;
    }

    public Object getProperty(String string, Object object) {
        Object object2 = this.getProperty(string);
        if (object2 != null) {
            return object2;
        }
        return object;
    }

    public DTD getDTD() {
        return (DTD)this.getProperty("dtd");
    }

    public URL getURL() {
        return (URL)this.getProperty("url");
    }

    public URL getReferer() {
        return (URL)this.getProperty("referer");
    }

    public URL getBaseURL() {
        URL uRL = (URL)this.getProperty("base");
        if (uRL != null) {
            return uRL;
        }
        return this.getURL();
    }

    public String getTitle() {
        return (String)this.getProperty("title");
    }

    public String getDoctype() {
        return (String)this.getProperty("doctype");
    }

    public String getTitleString() {
        String string = this.getTitle();
        if (string == null || string.equals("")) {
            string = Globals.localProps.handleGetString("hotjava.untitled");
            URL uRL = this.getURL();
            if (uRL != null) {
                string = String.valueOf(string) + " (" + uRL + ")";
            }
        }
        return string;
    }

    public Document getDocThisIsSourceOf() {
        return (Document)this.getProperty("docThisIsSourceOf");
    }

    public Date getExpirationDate() {
        return (Date)this.getProperty("expiration-date");
    }

    public void setExpirationDate(Date date) {
        try {
            this.setProperty("expiration-date", date);
            return;
        }
        catch (DocException docException) {
            return;
        }
    }

    public void setProperty(String string, Object object) throws DocException {
        Object object2 = Globals.getAwtLock();
        synchronized (object2) {
            Document document = this;
            synchronized (document) {
                if (this.changeNotVetoed(string, object)) {
                    this.modify();
                    if (object == null) {
                        this.props.remove(string);
                    } else {
                        if ("title".equals(string)) {
                            String string2 = this.getTitle();
                            this.changes.firePropertyChange("documentTitle", string2, object);
                        }
                        this.props.put(string, object);
                    }
                    this.dispatchDocumentEvent(1004, string);
                }
            }
            return;
        }
    }

    public Thread getOwner() {
        return this.owner;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int setOwner(int n, Thread thread) throws DocBusyException {
        Object object = Globals.getAwtLock();
        synchronized (object) {
            Document document = this;
            synchronized (document) {
                int n3 = this.state;
                if (this.owner != null && this.owner != Thread.currentThread()) {
                    throw new DocBusyException(this, "not owner");
                }
                this.owner = thread;
                if (this.state == n) return n3;
                this.state = n;
                this.dispatchDocumentEvent(1005, new Integer(n));
                return n3;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int setOwner(int n, Thread thread, Parser parser) throws DocBusyException {
        Object object = Globals.getAwtLock();
        synchronized (object) {
            Document document = this;
            synchronized (document) {
                int n3 = this.setOwner(n, thread);
                this.currentParser = parser;
                if (!(parser instanceof DocParser)) return n3;
                ((DocParser)parser).addPropertyChangeListener(this);
                return n3;
            }
        }
    }

    public Parser getParser() {
        return this.currentParser;
    }

    public BasefontTagRecord getBasefontTagRecord() {
        return this.basefontTagRecord;
    }

    public int basefontSizeAt(DocStyle docStyle, int n) {
        return this.basefontTagRecord.basefontSizeAt(docStyle, n);
    }

    public int length() {
        return this.nitems << 16;
    }

    public synchronized void interruptOwner() {
        if (this.owner != null) {
            this.owner.interrupt();
        }
    }

    public void interruptOwnerWaitCompletion() {
        Thread thread;
        if (this.owner == null) {
            return;
        }
        Object object = this.owner;
        synchronized (object) {
            thread = this.owner;
            this.owner.interrupt();
        }
        try {
            thread.setPriority(2);
        }
        catch (NullPointerException nullPointerException) {}
        if (this.state != 4 && this.state != 12) {
            object = new Properties();
            ((Hashtable)object).put("baseurl", this.getBaseURL().toExternalForm());
            this.dispatchDocumentEvent(1012, object);
        }
        if (this.state != 11) {
            try {
                thread.join();
                return;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                return;
            }
        }
        this.state = 15;
    }

    private void dispatchDocumentEvent(int n, Object object) {
        DocumentEvent documentEvent = new DocumentEvent(this, n, object);
        this.listeners.documentChanged(documentEvent);
    }

    void notifyViews(int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < this.nviews) {
            this.views[n4].notify(this, n, n2, n3);
            ++n4;
        }
    }

    public int countViews() {
        return this.nviews;
    }

    public void addView(DocView docView) {
        Object object = Globals.getAwtLock();
        synchronized (object) {
            Document document = this;
            synchronized (document) {
                if (this.nviews >= this.views.length) {
                    DocView[] docViewArray = new DocView[this.nviews + 8];
                    System.arraycopy(this.views, 0, docViewArray, 0, this.nviews);
                    this.views = docViewArray;
                }
                this.views[this.nviews++] = docView;
                docView.notify(this, 15, 0, this.nitems << 16);
                int n = 0;
                while (n < this.nitems) {
                    DocItem docItem = this.items[n];
                    short s = docItem.offset;
                    if (s >= 0 && n + s < this.ncompleted && this.needsActivation(n)) {
                        docView.notify(this, 20, n << 16, s + 1 << 16);
                    }
                    ++n;
                }
            }
            return;
        }
    }

    public void removeView(DocView docView) {
        Object object = Globals.getAwtLock();
        synchronized (object) {
            Document document = this;
            synchronized (document) {
                int n = 0;
                while (n < this.nviews) {
                    if (this.views[n] == docView) {
                        System.arraycopy(this.views, n + 1, this.views, n, this.nviews - (n + 1));
                        --this.nviews;
                        n = 0;
                        while (n < this.nitems) {
                            DocItem docItem = this.items[n];
                            short s = docItem.offset;
                            if (s >= 0 && n + s < this.ncompleted && this.needsActivation(n)) {
                                docView.notify(this, 21, n << 16, s + 1 << 16);
                            }
                            ++n;
                        }
                        docView.notify(this, 16, 0, this.nitems << 16);
                        break;
                    }
                    ++n;
                }
                this.views[this.nviews] = null;
            }
            return;
        }
    }

    TagItem makeTag(String string) {
        return this.makeTag(this.getDTD().getElement(string), null);
    }

    TagItem makeTag(Element element, Attributes attributes) {
        TagItem tagItem;
        Object object;
        try {
            object = Globals.props.getProperty(String.valueOf(element.getName()) + ".class");
            if (object == null) {
                object = "sunw.hotjava.tags." + element.getName().toUpperCase();
            }
            tagItem = (TagItem)Class.forName((String)object).newInstance();
        }
        catch (Exception exception) {
            tagItem = element.isEmpty() ? new EmptyTagItem() : new FlowTagItem();
        }
        tagItem.style = StyleSheet.getStyleSheet(element);
        tagItem.atts = attributes;
        if (tagItem instanceof FlowTagItem) {
            object = (FlowTagItem)tagItem;
            ((FlowTagItem)object).nobr = ((TagItem)object).getName().equals("nobr");
        } else if (tagItem instanceof BlockTagItem) {
            object = (BlockTagItem)tagItem;
            ((BlockTagItem)object).pre = ((TagItem)object).getName().equals("pre");
        }
        try {
            tagItem.init(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return tagItem;
    }

    private void modify() throws DocBusyException, DocNotEditableException {
        switch (this.state) {
            case 0: {
                this.setState(2);
                return;
            }
            case 2: 
            case 4: {
                return;
            }
        }
        if (this.state >= 10) {
            if (this.owner != Thread.currentThread()) {
                throw new DocBusyException(this, "document busy");
            }
            return;
        }
        throw new DocNotEditableException(this, "document not editable: " + this.state);
    }

    private void insertItems(int n, int n2) {
        int n3;
        if (this.nitems + n2 > this.items.length) {
            n3 = Math.max(this.nitems + n2, 3 * (this.items.length + 1) / 2);
            DocItem[] docItemArray = new DocItem[n3];
            System.arraycopy(this.items, 0, docItemArray, 0, n);
            System.arraycopy(this.items, n, docItemArray, n + n2, this.nitems - n);
            this.items = docItemArray;
        } else {
            System.arraycopy(this.items, n, this.items, n + n2, this.nitems - n);
        }
        this.nitems += n2;
        n3 = n - 1;
        while (n3 >= 0) {
            int n4 = this.items[n3].offset;
            if (n4 > 0) {
                this.items[n3].offset = (short)(n4 += n2);
                this.items[n3 + n4].offset = (short)(-n4);
            } else {
                n3 += n4;
            }
            --n3;
        }
        int n5 = n + n2;
        while (n5 < this.nitems) {
            this.items[n5].setIndex((short)(this.items[n5].index + n2), this);
            ++n5;
        }
    }

    private int deleteItems(int n, int n2) {
        int n3;
        int n4 = n;
        int n5 = n;
        while (n5 < n2) {
            n3 = this.items[n5].offset;
            if (n5 + n3 >= n2 || n3 < 0) {
                n4 = this.deleteItems(n5 + 1, n2);
                n2 = n5;
                break;
            }
            n5 += n3 + 1;
        }
        if (n < n2) {
            int n6;
            int n7;
            n3 = n;
            while (n3 < n2) {
                DocItem docItem = this.items[n3];
                n7 = docItem.offset;
                if (n7 >= 0 && n3 + n7 < this.ncompleted && this.needsActivation(n3)) {
                    this.notifyViews(21, n3 << 16, n7 + 1 << 16);
                }
                ++n3;
            }
            int n8 = n2 - n;
            System.arraycopy(this.items, n2, this.items, n, this.nitems - n2);
            this.nitems -= n8;
            this.basefontTagRecord.notifyDocItemsDeleted(n, n8);
            n7 = 0;
            while (n7 < n8) {
                this.items[this.nitems + n7] = null;
                ++n7;
            }
            if (this.nitems < this.items.length >> 1) {
                DocItem[] docItemArray = new DocItem[this.items.length >> 1];
                System.arraycopy(this.items, 0, docItemArray, 0, this.nitems);
                this.items = docItemArray;
            }
            int n9 = n - 1;
            while (n9 >= 0) {
                n6 = this.items[n9].offset;
                if (n6 > 0) {
                    this.items[n9].offset = (short)(n6 -= n8);
                    this.items[n9 + n6].offset = (short)(-n6);
                } else {
                    n9 += n6;
                }
                --n9;
            }
            n6 = n;
            while (n6 < this.nitems) {
                this.items[n6].setIndex((short)(this.items[n6].index - n8), this);
                ++n6;
            }
            this.notifyViews(16, n << 16, n2 - n << 16);
        }
        return n4;
    }

    private int splitItem(int n) {
        DocItem docItem;
        if (n < 0) {
            return 0;
        }
        if (n > this.nitems << 16) {
            return this.nitems;
        }
        int n2 = n >> 16;
        if ((n & 0xFFFF) == 0) {
            return n2;
        }
        if ((docItem = this.items[n2++].split(this, n)) != null) {
            this.insertItems(n2, 1);
            docItem.setIndex((short)n2, this);
            this.items[n2] = docItem;
            this.notifyViews(10, n, 0);
        }
        return n2;
    }

    public int insertTag(int n, String string, Attributes attributes) throws DocException {
        return this.insertTag(n, this.getDTD().getElement(string), attributes);
    }

    public int insertTag(int n, Element element, Attributes attributes) throws DocException {
        return this.insertTag(n, this.makeTag(element, attributes));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int insertTag(int n, TagItem tagItem) throws DocException {
        Object object = Globals.getAwtLock();
        synchronized (object) {
            Document document = this;
            synchronized (document) {
                this.modify();
                int n3 = this.splitItem(n);
                this.insertItems(n3, 1);
                tagItem.offset = 0;
                tagItem.setIndex((short)n3, this);
                this.items[n3] = tagItem;
                this.notifyViews(15, n3 << 16, 65536);
                if (n3 >= this.ncompleted) return n3 + 1 << 16;
                if (!this.needsActivation(n3)) return n3 + 1 << 16;
                this.notifyViews(20, n3 << 16, 65536);
                return n3 + 1 << 16;
            }
        }
    }

    public int insertTagPair(int n, String string, Attributes attributes) throws DocException {
        return this.insertTagPair(n, this.getDTD().getElement(string), attributes);
    }

    public int insertTagPair(int n, Element element, Attributes attributes) throws DocException {
        return this.insertTagPair(n, this.makeTag(element, attributes));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int insertTagPair(int n, TagItem tagItem) throws DocException {
        Object object = Globals.getAwtLock();
        synchronized (object) {
            Document document = this;
            synchronized (document) {
                this.modify();
                EndTagItem endTagItem = new EndTagItem();
                int n3 = this.splitItem(n);
                this.insertItems(n3, 2);
                tagItem.offset = 1;
                endTagItem.offset = (short)-1;
                tagItem.setIndex((short)n3, this);
                this.items[n3] = tagItem;
                endTagItem.setIndex((short)(n3 + 1), this);
                this.items[n3 + 1] = endTagItem;
                this.notifyViews(15, n3 << 16, 131072);
                if (n3 + 1 >= this.ncompleted) return n3 + 1 << 16;
                if (!this.needsActivation(n3)) return n3 + 1 << 16;
                this.notifyViews(20, n3 << 16, 131072);
                return n3 + 1 << 16;
            }
        }
    }

    public int insert(int n, String string) throws DocException {
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        return this.insert(n, cArray, 0, cArray.length);
    }

    public int insert(int n, int n2) throws DocException {
        char[] cArray = new char[]{(char)(n2 & 0xFFFF)};
        return this.insert(n, cArray, 0, 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int insert(int n, char[] cArray, int n2, int n3) throws DocException {
        Object object = Globals.getAwtLock();
        synchronized (object) {
            Document document = this;
            synchronized (document) {
                TextItem textItem;
                int n4;
                int n5;
                this.modify();
                if (n < 0) {
                    n = 0;
                } else if (n > this.nitems << 16) {
                    n = this.nitems << 16;
                }
                int n6 = n5 = n >> 16;
                if (n6 >= 0 && n6 < this.nitems && this.items[n6].isText() && (n4 = this.items[n6].insert(this, n, cArray, n2, n3)) != -1) {
                    this.notifyViews(12, n4 - n3, n3);
                    return n4;
                }
                if (n6 > 0 && (n & 0xFFFF) == 0 && this.items[n6 - 1].isText() && (n4 = this.items[n6 - 1].insert(this, n - 1, cArray, n2, n3)) != -1) {
                    this.notifyViews(12, n4 - n3, n3);
                    return n4;
                }
                n6 = this.splitItem(n);
                n4 = 0;
                int n7 = n2;
                int n8 = n3 - n7;
                while (n8 > 65535) {
                    this.insertItems(n6, 1);
                    textItem = new TextItem(cArray, n7, 65535);
                    ++n4;
                    textItem.offset = 0;
                    textItem.setIndex((short)n6, this);
                    this.items[n6] = textItem;
                    n7 += 65535;
                    n8 -= 65535;
                    ++n6;
                }
                this.insertItems(n6, 1);
                textItem = new TextItem(cArray, n7, n8);
                textItem.offset = 0;
                textItem.setIndex((short)n6, this);
                this.items[n6] = textItem;
                this.notifyViews(15, n5 << 16, ++n4 << 16);
                return n6 + 1 << 16;
            }
        }
    }

    public void surround(int n, int n2, String string, Attributes attributes) throws DocException {
        this.surround(n, n2, this.getDTD().getElement(string), attributes);
    }

    public void surround(int n, int n2, Element element, Attributes attributes) throws DocException {
        this.surround(n, n2, this.makeTag(element, attributes));
    }

    public void surround(int n, int n2, TagItem tagItem) throws DocException {
        if (n2 >> 16 <= n >> 16 || n >> 16 < 0 || n2 >> 16 >= this.nitems) {
            throw new DocError(this, "invalid surround: " + (n >> 16) + " - " + (n2 >> 16));
        }
        Object object = Globals.getAwtLock();
        synchronized (object) {
            Document document = this;
            synchronized (document) {
                this.modify();
                EndTagItem endTagItem = new EndTagItem();
                int n3 = this.splitItem(n2);
                int n4 = this.splitItem(n);
                ++n3;
                if (n4 << 16 > n) {
                    ++n3;
                }
                this.insertItems(n3, 1);
                endTagItem.offset = (short)(-(n3 + 1 - n4));
                endTagItem.setIndex((short)n3, this);
                this.items[n3] = endTagItem;
                this.notifyViews(15, n3 << 16, 65536);
                this.insertItems(n4, 1);
                tagItem.offset = (short)(++n3 - n4);
                tagItem.setIndex((short)n4, this);
                this.items[n4] = tagItem;
                this.notifyViews(15, n4 << 16, 65536);
                this.notifyViews(17, n4 + 1 << 16, n3 - n4 - 1 << 16);
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int delete(int n, int n2) throws DocException {
        Object object = Globals.getAwtLock();
        synchronized (object) {
            Document document = this;
            synchronized (document) {
                int n3;
                this.modify();
                if (n < 0) {
                    n = 0;
                }
                if (n2 > this.nitems << 16) {
                    n2 = this.nitems << 16;
                }
                if (n >= n2) {
                    return n2;
                }
                int n4 = n >> 16;
                int n5 = n2 >> 16;
                if ((n2 & 0xFFFF) > 0 && !this.items[n5].isText()) {
                    n2 = ++n5 << 16;
                }
                if (n4 == n5) {
                    this.items[n4].delete(this, n, n2 - n);
                    this.notifyViews(13, n, n2 - n);
                    return n;
                }
                if ((n & 0xFFFF) > 0 && this.items[n4].isText()) {
                    n3 = 65535 - (n & 0xFFFF);
                    this.items[n4++].delete(this, n, n3);
                    this.notifyViews(13, n, n3);
                }
                if (n4 < n5) {
                    n5 = this.deleteItems(n4, n5);
                }
                if ((n2 & 0xFFFF) <= 0) return n5 << 16;
                n3 = n2 & 0xFFFF;
                this.items[n5].delete(this, n4 << 16, n3);
                this.notifyViews(13, n4 << 16, n3);
                return n5 << 16;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void change(int n, int n2) {
        Object object = Globals.getAwtLock();
        synchronized (object) {
            Document document = this;
            synchronized (document) {
                if (n < 0) {
                    n = 0;
                }
                if (n2 > this.nitems << 16) {
                    n2 = this.nitems << 16;
                }
                if (n >= n2) {
                    return;
                }
                this.notifyViews(17, n, n2 - n);
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void paint(int n, int n2) {
        Object object = Globals.getAwtLock();
        synchronized (object) {
            Document document = this;
            synchronized (document) {
                if (n < 0) {
                    n = 0;
                }
                if (n2 > this.nitems << 16) {
                    n2 = this.nitems << 16;
                }
                if (n >= n2) {
                    return;
                }
                this.notifyViews(18, n, n2 - n);
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void update(int n, int n2) {
        Object object = Globals.getAwtLock();
        synchronized (object) {
            Document document = this;
            synchronized (document) {
                if (n < 0) {
                    n = 0;
                }
                if (n2 > this.nitems << 16) {
                    n2 = this.nitems << 16;
                }
                if (n >= n2) {
                    return;
                }
                this.notifyViews(19, n, n2 - n);
            }
            return;
        }
    }

    DocItemEnumeration getDocItems(int n, int n2) {
        return new DocItemEnumeration(this, n, n2);
    }

    /*
     * Unable to fully structure code
     */
    public synchronized DocStyle getStyle(DocStyle var1_1, int var2_2) {
        var3_3 = null;
        var4_4 = var2_2 >> 16;
        if ((var2_2 & 65535) == 0) ** GOTO lbl29
        if (true) ** GOTO lbl29
        do {
            if ((var5_5 = this.items[var4_4]) != null) {
                var6_6 = var5_5.offset;
                if (var6_6 > 0) {
                    var7_8 = this.getStyle(var1_1, var4_4 << 16).push(var5_5);
                    if (var3_3 != null) {
                        while (!var3_3.empty()) {
                            var8_9 = (DocItem)var3_3.pop();
                            var7_8 = var8_9.modifyStyleInPlace(var7_8);
                        }
                    }
                    return var7_8;
                }
                if (var6_6 == 0 && var5_5.modifiesStyleInPlace()) {
                    if (var3_3 == null) {
                        var3_3 = new Stack<DocItem>();
                    }
                    var3_3.push(var5_5);
                } else if (var6_6 < 0) {
                    v0 = var7_7 = this.basefontTagRecord.numIndices > 0 ? this.basefontTagRecord.maxLessThanOrEqual(var4_4) : -1;
                    if (var7_7 > (var4_4 += var6_6)) {
                        if (var3_3 == null) {
                            var3_3 = new Stack<E>();
                        }
                        var3_3.push(this.items[var7_7]);
                    }
                }
            }
lbl29:
            // 10 sources

            v1 = ++var4_4;
            --var4_4;
        } while (v1 > 0 && this.items != null);
        if (var3_3 != null) {
            while (!var3_3.empty()) {
                var5_5 = (DocItem)var3_3.pop();
                if (var5_5 == null) break;
                var1_1 = var5_5.modifyStyleInPlace(var1_1);
            }
        }
        return var1_1;
    }

    public synchronized int findLabel(String string) {
        int n = 0;
        while (n < this.nitems) {
            int n2;
            DocItem docItem = this.items[n];
            if (docItem.offset >= 0 && (n2 = docItem.findLabel(string)) != -1) {
                return n2;
            }
            ++n;
        }
        return -1;
    }

    private String getColorString(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        char[] cArray = new char[]{'#', Character.forDigit(n >> 4, 16), Character.forDigit(n & 0xF, 16), Character.forDigit(n2 >> 4, 16), Character.forDigit(n2 & 0xF, 16), Character.forDigit(n3 >> 4, 16), Character.forDigit(n3 & 0xF, 16)};
        return new String(cArray);
    }

    public void write(OutputStream outputStream) throws DocException, IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        this.write(outputStreamWriter);
        outputStreamWriter.flush();
    }

    public void write(Writer writer) throws DocException, IOException {
        HTMLOutputWriter hTMLOutputWriter = new HTMLOutputWriter(writer, this.getDTD());
        int n = this.state;
        try {
            Color color;
            n = this.setOwner(13, Thread.currentThread());
            String string = this.getDoctype();
            if (string != null) {
                hTMLOutputWriter.doctype(string);
            }
            hTMLOutputWriter.comment(String.valueOf(Globals.localProps.handleGetString("hotjava.html.header")) + " " + new Date());
            TagItem tagItem = this.makeTag("html");
            TagItem tagItem2 = this.makeTag("head");
            TagItem tagItem3 = this.makeTag("title");
            TagItem tagItem4 = this.makeTag("body");
            Attributes attributes = new Attributes();
            String string2 = (String)this.getProperty("background.img");
            if (string2 != null) {
                attributes.put("background", string2);
            }
            if ((color = (Color)this.getProperty("background.color")) != null) {
                attributes.put("bgcolor", this.getColorString(color));
            }
            if ((color = (Color)this.getProperty("text.color")) != null) {
                attributes.put("text", this.getColorString(color));
            }
            if ((color = (Color)this.getProperty("link.color")) != null) {
                attributes.put("link", this.getColorString(color));
            }
            if ((color = (Color)this.getProperty("vlink.color")) != null) {
                attributes.put("vlink", this.getColorString(color));
            }
            if ((color = (Color)this.getProperty("alink.color")) != null) {
                attributes.put("alink", this.getColorString(color));
            }
            tagItem4.atts = attributes;
            hTMLOutputWriter.startTag(tagItem);
            hTMLOutputWriter.startTag(tagItem2);
            hTMLOutputWriter.startTag(tagItem3);
            string2 = this.getTitle();
            if (string2 != null) {
                hTMLOutputWriter.text(string2);
            }
            hTMLOutputWriter.endTag(tagItem3);
            URL uRL = (URL)this.getProperty("base");
            if (uRL != null) {
                TagItem tagItem5 = this.makeTag("base");
                tagItem5.atts = new Attributes();
                tagItem5.atts.put("href", uRL.toExternalForm());
                hTMLOutputWriter.emptyTag(tagItem5);
            }
            hTMLOutputWriter.endTag(tagItem2);
            hTMLOutputWriter.startTag(tagItem4);
            int n2 = 0;
            while (n2 < this.nitems) {
                short s = this.items[n2].offset;
                if (s > 0) {
                    this.items[n2].writeStartTag(hTMLOutputWriter);
                } else if (s < 0) {
                    this.items[n2 + s].writeEndTag(hTMLOutputWriter);
                } else {
                    this.items[n2].write(hTMLOutputWriter);
                }
                ++n2;
            }
            hTMLOutputWriter.endTag(tagItem4);
            hTMLOutputWriter.endTag(tagItem);
        }
        catch (Throwable throwable) {
            Object var5_17 = null;
            this.setOwner(n, null);
            hTMLOutputWriter.flush();
            throw throwable;
        }
        Object var5_16 = null;
        this.setOwner(n, null);
        hTMLOutputWriter.flush();
    }

    public synchronized int startPos(int n) {
        int n2 = n >> 16;
        int n3 = n & 0xFFFF;
        while (n2 >= 0 && n2 < this.nitems) {
            n = this.items[n2].startOffset(this, n3);
            if (n >= 0) {
                return n2 << 16 | n;
            }
            n3 = 65536;
            --n2;
        }
        return 0;
    }

    public Document getSourceDocument() throws DocException {
        Object object;
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        try {
            this.write(charArrayWriter);
        }
        catch (IOException iOException) {
            throw new DocError(this, "I/O error on buffer");
        }
        char[] cArray = charArrayWriter.toCharArray();
        Object object2 = Globals.localProps.handleGetString("hotjava.htmlsource");
        URL uRL = this.getURL();
        if (uRL != null) {
            object2 = String.valueOf(object2) + " -- " + uRL.toExternalForm();
        } else {
            object = this.getTitle();
            if (object != null) {
                object2 = ((String)object).startsWith((String)object2) ? object : String.valueOf(object2) + " -- " + (String)object;
            }
        }
        object = new Document((String)object2);
        ((Document)object).setProperty("docThisIsSourceOf", this);
        int n = ((Document)object).insertTagPair(0, "h1", null);
        n = ((Document)object).insert(n, (String)object2);
        n += 65536;
        if (uRL != null) {
            object2 = uRL.toExternalForm();
            String string = Globals.localProps.handleGetString("html.source.msg", "Original source of");
            n = ((Document)object).insert(n, String.valueOf(string) + " ");
            n = ((Document)object).insertTagPair(n, "a", new Attributes("href", "verbatim:" + (String)object2));
            n = ((Document)object).insert(n, (String)object2) + 65536;
        }
        n = ((Document)object).insertTag(n, "hr", null);
        n = ((Document)object).insertTagPair(n, "plaintext", null);
        ((Document)object).insert(n, cArray, 0, cArray.length);
        ((Document)object).setState(1);
        ((Document)object).setParsingCompleted(true);
        ((Document)object).dispatchFormatScreen();
        return object;
    }

    public synchronized void reset() throws DocException {
        this.setState(0);
        this.owner = null;
        this.parsingCompleted = false;
        this.setIsOkToFormat(false);
    }

    public void clear() throws DocException {
        Object object = Globals.getAwtLock();
        synchronized (object) {
            Document document = this;
            synchronized (document) {
                this.modify();
                this.delete(0, Integer.MAX_VALUE);
                DTD dTD = this.getDTD();
                URL uRL = this.getURL();
                this.props = new Hashtable(11);
                this.props.put("dtd", dTD);
                this.props.put("url", uRL);
            }
            return;
        }
    }

    public Range find(String string) {
        return this.find(string, 0);
    }

    public Range find(String string, int n) {
        return this.find(string, n, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized Range find(String string, int n, boolean bl) {
        OverlappingStringMatch overlappingStringMatch = new OverlappingStringMatch();
        String string2 = null;
        int n2 = n >> 16;
        int n3 = n & 0xFFFF;
        boolean bl2 = false;
        int n4 = 0;
        int n5 = 0;
        while (n2 < this.nitems) {
            int n6;
            DocItem docItem = this.items[n2];
            if (!bl2) {
                n6 = docItem.find(string, n3, bl, overlappingStringMatch);
                if (n6 >= 0) {
                    if (overlappingStringMatch.matchLength == string.length()) {
                        return new Range(n2 << 16 | n6, n2 << 16 | n6 + string.length());
                    }
                    bl2 = true;
                    n4 = n2;
                    n5 = n6;
                    string2 = string.substring(overlappingStringMatch.matchLength);
                }
            } else if (docItem instanceof FlowTagItem || docItem instanceof TextItem || docItem instanceof EndTagItem || docItem instanceof EmptyTagItem) {
                n6 = docItem.find(string2, n3, bl, overlappingStringMatch);
                if (n6 >= 0) {
                    String string3 = docItem.getText();
                    if (!string3.startsWith(overlappingStringMatch.overlappingMatch)) {
                        bl2 = false;
                        n3 = 0;
                        continue;
                    }
                    if (overlappingStringMatch.matchLength >= string2.length()) return new Range(n4 << 16 | n5, n2 << 16 | overlappingStringMatch.matchLength);
                    string2 = string2.substring(overlappingStringMatch.matchLength);
                } else if (docItem instanceof TextItem) {
                    bl2 = false;
                    n3 = 0;
                    continue;
                }
            } else {
                bl2 = false;
                n3 = 0;
                continue;
            }
            n3 = 0;
            ++n2;
        }
        return null;
    }

    public synchronized int count(int n, int n2) {
        int n3 = 0;
        int n4 = n;
        while (n4 < n2) {
            short s = this.items[n4].offset;
            if (s > 0) {
                n4 += s;
            }
            ++n4;
            ++n3;
        }
        return n3;
    }

    public void print() {
        Enumeration enumeration = this.props.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            System.out.println(String.valueOf(k) + "=" + this.props.get(k));
        }
        int n = 0;
        while (n < this.nitems) {
            DocItem docItem = this.items[n];
            String string = docItem.getClass().getName();
            System.out.println(String.valueOf(n) + " = " + string.substring(string.lastIndexOf(46) + 1) + "," + docItem);
            ++n;
        }
    }

    public synchronized DocItem getItem(int n) {
        if (n < 0 || n >= this.nitems) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.items[n];
    }

    public boolean isStateless() {
        int n = 0;
        while (n < this.nitems) {
            if (this.items[n] instanceof APPLET || this.items[n] instanceof FORM) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean releaseResources(int n) {
        switch (n) {
            case 1: {
                return this.releaseApplets();
            }
            case 2: {
                return this.releaseForms();
            }
            case 3: {
                return this.releaseImages();
            }
            case 4: {
                return this.releaseImageMaps();
            }
            case 6: {
                if (this.releaseImages()) {
                    return true;
                }
                return this.releaseImageMaps();
            }
        }
        return false;
    }

    private boolean releaseImages() {
        int n = 0;
        while (n < this.nitems) {
            if (this.items[n] instanceof IMG && !((IMG)this.items[n]).isMappable()) {
                this.items[n].flush();
            }
            ++n;
        }
        return false;
    }

    private boolean releaseImageMaps() {
        int n = 0;
        while (n < this.nitems) {
            if (this.items[n] instanceof IMG && ((IMG)this.items[n]).isMappable()) {
                this.items[n].flush();
                this.notifyViews(21, n << 16, 65536);
            }
            ++n;
        }
        return false;
    }

    private boolean releaseApplets() {
        int n = 0;
        while (n < this.nitems) {
            if (this.items[n] instanceof APPLET) {
                this.items[n].flush();
                this.notifyViews(21, n << 16, 65536);
            }
            ++n;
        }
        return false;
    }

    private boolean releaseForms() {
        int n = 0;
        while (n < this.nitems) {
            if (this.items[n] instanceof FORM) {
                this.items[n].flush();
                this.notifyViews(21, n << 16, n + this.items[n].getOffset() << 16);
            }
            ++n;
        }
        return false;
    }

    protected void reloadFrames() throws DocException {
        int n = 0;
        while (n < this.nitems) {
            if (this.items[n] instanceof FRAME) {
                Document document = ((FRAME)this.items[n]).getSourceDocument();
                document.reload();
            }
            ++n;
        }
    }

    public void reload() throws DocException {
        this.setState(4);
        this.interruptOwnerWaitCompletion();
        this.reloadFrames();
        this.setState(0);
        this.delete(0, Integer.MAX_VALUE);
        this.reset();
        this.setProperty("background.img", null);
        this.setProperty("background.color", null);
        this.setProperty("text.color", null);
        this.setProperty("link.color", null);
        this.setProperty("vlink.color", null);
        this.setProperty("alink.color", null);
        DocParser docParser = new DocParser(this, false);
        docParser.addPropertyChangeListener(this);
    }

    public void setParserProperties(Properties properties) {
        try {
            new DocParser(this, properties);
            return;
        }
        catch (DocException docException) {
            return;
        }
    }

    public void setConnector(URLConnector uRLConnector) {
        this.connector = uRLConnector;
    }

    public URLConnector getConnector() {
        return this.connector;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[title=" + this.getTitle() + ",url=" + this.getURL() + ",state=" + this.state + "]";
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vchanges.addVetoableChangeListener(vetoableChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vchanges.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void setErrorMessage(String string) {
        this.changes.firePropertyChange("documentError", this.documentError, string);
        this.documentError = string;
    }

    public void setDocumentTitle(String string) {
        String string2 = (String)this.getProperty("title");
        try {
            this.setProperty("title", string);
        }
        catch (DocException docException) {}
        this.changes.firePropertyChange("documentTitle", string2, string);
    }

    public String getDocumentTitle() {
        return this.getTitle();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("parseError")) {
            this.setErrorMessage("parse: " + (String)propertyChangeEvent.getNewValue());
        }
    }

    protected boolean changeNotVetoed(String string, Object object) {
        boolean bl = true;
        String[] stringArray = new String[]{"background.img", "background.color", "text.color", "link.color", "vlink.color", "alink.color"};
        String[] stringArray2 = new String[]{"backgroundImage", "backgroundColor", "textColor", "linkColor", "visitedLinkColor", "clickLinkColor"};
        int n = 0;
        while (n < stringArray.length) {
            if (string.equals(stringArray[n])) {
                try {
                    this.vchanges.fireVetoableChange(stringArray2[n], this.props.get(string), object);
                }
                catch (PropertyVetoException propertyVetoException) {
                    bl = false;
                }
                break;
            }
            ++n;
        }
        return bl;
    }

    public void printDocContext(int n, int n2) {
        int n3 = n >> 16;
        int n4 = n3 - n2;
        int n5 = n3 + n2;
        if (n4 < 0) {
            n4 = 0;
        }
        if (n5 > this.items.length) {
            n5 = this.items.length;
        }
        System.out.println("***************************************");
        System.out.println("*  Current doc context of " + n2);
        int n6 = n4;
        while (n6 < n5) {
            TagItem tagItem = null;
            if (this.items[n6] != null && this.items[n6] instanceof TagItem) {
                tagItem = (TagItem)this.items[n6];
            }
            if (n6 == n3) {
                System.out.println("* ===> items[" + n6 + "] == <" + (this.items[n6] != null ? this.getTagName(this.items[n6]) : "null") + "> offset = " + (this.items[n6] != null ? (int)this.items[n6].offset : 0));
            } else {
                System.out.println("*      items[" + n6 + "] == <" + (this.items[n6] != null ? this.getTagName(this.items[n6]) : "null") + "> offset = " + (this.items[n6] != null ? (int)this.items[n6].offset : 0));
            }
            ++n6;
        }
        System.out.println("***************************************");
    }

    public String getTagName(DocItem docItem) {
        if (docItem instanceof TagItem) {
            return ((TagItem)docItem).getElement().getName();
        }
        if (docItem instanceof EndTagItem) {
            return "/" + ((EndTagItem)docItem).getTag(this).getElement().getName();
        }
        if (docItem instanceof TextItem) {
            return "text item";
        }
        return "Unknown";
    }

    public Hashtable getImageMaps() {
        if (this.imageMaps == null) {
            Document document = this;
            synchronized (document) {
                if (this.imageMaps == null) {
                    this.imageMaps = new Hashtable(11);
                }
            }
        }
        return this.imageMaps;
    }

    public ImageMap findImageMap(URL uRL) {
        if (this.imageMaps != null) {
            return (ImageMap)this.imageMaps.get(uRL);
        }
        return null;
    }

    public void addSizeItemWidthWaitRef(SizeItem sizeItem) {
        this.startTimer();
        this.sizeItemListWidth.put(sizeItem, dummyInt);
    }

    public void addSizeItemHeightWaitRef(SizeItem sizeItem) {
        this.startTimer();
        this.sizeItemListHeight.put(sizeItem, dummyInt);
    }

    public void addSizeItemWaitRef(SizeItem sizeItem) {
        this.addSizeItemWidthWaitRef(sizeItem);
        this.addSizeItemHeightWaitRef(sizeItem);
    }

    public void removeSizeItemWidthWaitRef(SizeItem sizeItem) {
        boolean bl = this.isSizeItemWidthWaitRef();
        this.sizeItemListWidth.remove(sizeItem);
        if (bl) {
            this.dispatchFormatScreen();
        }
    }

    public void removeSizeItemHeightWaitRef(SizeItem sizeItem) {
        boolean bl = this.isSizeItemHeightWaitRef();
        this.sizeItemListHeight.remove(sizeItem);
        if (bl) {
            this.dispatchFormatScreen();
        }
    }

    public void removeSizeItemWaitRef(SizeItem sizeItem) {
        boolean bl = this.isSizeItemWaitRef();
        this.sizeItemListWidth.remove(sizeItem);
        this.sizeItemListHeight.remove(sizeItem);
        if (bl) {
            this.dispatchFormatScreen();
        }
    }

    public void dispatchFormatScreen() {
        this.setIsOkToFormat(false);
        if (this.sizeItemListWidth.size() <= 0 && this.sizeItemListHeight.size() <= 0 && this.parsingCompleted) {
            Object object = Globals.getAwtLock();
            synchronized (object) {
                Document document = this;
                synchronized (document) {
                    this.timeOutStack.removeAllElements();
                    this.notifyViews(23, 0, 0);
                }
                return;
            }
        }
    }

    public void purgeSizeItemWidthWaitRef() {
        this.sizeItemListWidth = new Hashtable();
    }

    public void purgeSizeItemHeightWaitRef() {
        this.sizeItemListHeight = new Hashtable();
    }

    public void purgeSizeItemWaitRef() {
        this.purgeSizeItemWidthWaitRef();
        this.purgeSizeItemHeightWaitRef();
    }

    public boolean isSizeItemWidthWaitRef() {
        return this.sizeItemListWidth.size() > 0;
    }

    public boolean isSizeItemHeightWaitRef() {
        return this.sizeItemListHeight.size() > 0;
    }

    public boolean isSizeItemWaitRef() {
        return this.sizeItemListWidth.size() > 0 || this.sizeItemListHeight.size() > 0;
    }

    public void setIsOkToFormat(boolean bl) {
        if (!this.isSizeItemWaitRef() && this.doneParsing() && !bl) {
            this.bIsOkToFormat = true;
            return;
        }
        this.bIsOkToFormat = bl;
    }

    public boolean isOkToFormat() {
        return this.bIsOkToFormat;
    }

    public void updateClient(Object object) {
        boolean bl = this.isSizeItemWaitRef();
        Long l = null;
        if (!this.timeOutStack.empty()) {
            l = (Long)this.timeOutStack.peek();
        }
        if (object != null && l != null && l.equals(object)) {
            SizeItem sizeItem;
            this.timeOutStack.removeAllElements();
            System.out.println("DOC TIMED OUT ON IMG");
            Enumeration enumeration = this.sizeItemListWidth.keys();
            while (enumeration.hasMoreElements()) {
                sizeItem = (SizeItem)enumeration.nextElement();
                sizeItem.waiterTimedOut();
            }
            enumeration = this.sizeItemListHeight.keys();
            while (enumeration.hasMoreElements()) {
                sizeItem = (SizeItem)enumeration.nextElement();
                sizeItem.waiterTimedOut();
            }
        }
        this.purgeSizeItemWaitRef();
        if (bl) {
            this.dispatchFormatScreen();
        }
    }

    private void startTimer() {
        if (this.sizeItemListWidth.size() <= 0 && this.sizeItemListHeight.size() <= 0) {
            Long l = new Long(System.currentTimeMillis());
            this.timeOutStack.push(l);
            int n = Integer.getInteger("allimages.timeout", 60000);
            ScreenUpdater.updater.notify((UpdateClient)this, (long)n, (Object)l);
        }
    }
}

