/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.accessibility.Accessible;
import com.sun.java.accessibility.AccessibleContext;
import com.sun.java.accessibility.AccessibleRole;
import com.sun.java.accessibility.AccessibleState;
import com.sun.java.swing.AbstractAction;
import com.sun.java.swing.AbstractButton;
import com.sun.java.swing.ButtonModel;
import com.sun.java.swing.DefaultButtonModel;
import com.sun.java.swing.Icon;
import com.sun.java.swing.KeyStroke;
import com.sun.java.swing.MenuElement;
import com.sun.java.swing.MenuSelectionManager;
import com.sun.java.swing.OverlayLayout;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.event.ChangeEvent;
import com.sun.java.swing.event.ChangeListener;
import com.sun.java.swing.plaf.MenuItemUI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;

public class JMenuItem
extends AbstractButton
implements Accessible,
MenuElement {
    private KeyStroke accelerator;

    public JMenuItem() {
        this(null, null);
        this.setRequestFocusEnabled(false);
    }

    public JMenuItem(Icon icon) {
        this(null, icon);
        this.setRequestFocusEnabled(false);
    }

    public JMenuItem(String string) {
        this(string, null);
    }

    public JMenuItem(String string, Icon icon) {
        this.setModel(new DefaultButtonModel());
        this.init(string, icon);
        this.setBorderPainted(false);
        this.setFocusPainted(false);
        this.setHorizontalTextPosition(2);
        this.setHorizontalAlignment(2);
        this.updateUI();
    }

    public JMenuItem(String string, int n) {
        this.setModel(new DefaultButtonModel());
        this.init(string, null);
        this.setBorderPainted(false);
        this.setFocusPainted(false);
        this.setHorizontalTextPosition(2);
        this.setHorizontalAlignment(2);
        this.setMnemonic(n);
        this.updateUI();
    }

    protected void init(String string, Icon icon) {
        this.setLayout(new OverlayLayout(this));
        if (string != null) {
            this.setText(string);
        }
        if (icon != null) {
            this.setIcon(icon);
        }
        this.addFocusListener(new MenuItemFocusListener());
    }

    public void setUI(MenuItemUI menuItemUI) {
        super.setUI(menuItemUI);
    }

    public void updateUI() {
        this.setUI((MenuItemUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "MenuItemUI";
    }

    public void setArmed(boolean bl) {
        ButtonModel buttonModel = this.getModel();
        boolean bl2 = buttonModel.isArmed();
        if (this.accessibleContext != null && bl2 != bl) {
            if (bl) {
                this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.ARMED);
            } else {
                this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.ARMED, null);
            }
        }
        if (buttonModel.isArmed() != bl) {
            buttonModel.setArmed(bl);
        }
    }

    public boolean isArmed() {
        ButtonModel buttonModel = this.getModel();
        return buttonModel.isArmed();
    }

    public void setEnabled(boolean bl) {
        if (!bl) {
            this.setArmed(false);
        }
        super.setEnabled(bl);
    }

    public void setAccelerator(KeyStroke keyStroke) {
        if (this.accelerator != null) {
            this.unregisterKeyboardAction(this.accelerator);
        }
        this.registerKeyboardAction(new 1(), keyStroke, 2);
        this.accelerator = keyStroke;
    }

    public KeyStroke getAccelerator() {
        return this.accelerator;
    }

    public void processMouseEvent(MouseEvent mouseEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
        ((MenuItemUI)this.getUI()).processMouseEvent(this, mouseEvent, menuElementArray, menuSelectionManager);
    }

    public void processKeyEvent(KeyEvent keyEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
        ((MenuItemUI)this.getUI()).processKeyEvent(this, keyEvent, menuElementArray, menuSelectionManager);
    }

    public void menuSelectionChanged(boolean bl) {
        this.setArmed(bl);
    }

    public MenuElement[] getSubElements() {
        return new MenuElement[0];
    }

    public Component getComponent() {
        return this;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJMenuItem();
        }
        return this.accessibleContext;
    }

    private static class MenuItemFocusListener
    implements FocusListener,
    Serializable {
        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            JMenuItem jMenuItem = (JMenuItem)focusEvent.getSource();
            if (jMenuItem.isFocusPainted()) {
                jMenuItem.repaint();
            }
        }

        MenuItemFocusListener() {
        }
    }

    private final class 1
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            MenuSelectionManager.defaultManager().clearSelectedPath();
            JMenuItem.this.doClick();
        }

        /* synthetic */ 1() {
        }
    }

    protected class AccessibleJMenuItem
    extends AbstractButton.AccessibleAbstractButton
    implements ChangeListener {
        AccessibleJMenuItem() {
            JMenuItem.this = JMenuItem.this;
            JMenuItem.this.addChangeListener(this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU_ITEM;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.firePropertyChange("AccessibleVisibleData", new Boolean(false), new Boolean(true));
        }
    }
}

