COMMENT |
============================================================================
  
  NOISE.SYS v0.3.5-Beta, /dev/random driver for DOS boxes (8 Jan 96)
  by Robert Rothenburg Walking-Owl.  Portions by Colin Plumb.
  Copyright (C) 1995-1996.  All Rights Reserved.

  This is code for a character device which samples various sources of
  entropy (most based on fast timings between events like keystrokes
  and disk access) and accumulates them in a pool which is mixed using
  a Secure Hash Algorithm transformation.

== License and (Non)Warranty Information ===================================

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or 
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

===========================================================================|

__cpu        equ 3  ; 3 for 386, 4 for 486
; Note: 386 version includes some fixes for older 386 processors which choke
;       on pushad/popad instructions. At the moment no 486-specific instruc.
;       are used.

__sample09   equ 1  ; 1 to sample Int 0x09 (Keyboard ISR)
__sample13   equ 1  ; 1 to sample Int 0x13 (Low-level disk calls)
__sample14   equ 0  ; 1 to sample Int 0x14 (Serial Ports)
; ----- Is it worth sampling the Communications ports? Most programs that
;       use it install their own drivers over and above previous driver
__sample33   equ 1  ; 1 to sample Int 0x33 (Mouse) /M option.
__sample08   equ 1  ; 1 to hook to timer and periodically sample mouse
                    ; enabled by /P option on loading

initseedcnt  equ 20 ; if non-zero, sample keystrokes when /I option given

; ----- See documentation before enabling the following features! -----
__counters   equ 0  ; mix counters with the entropy pool (unneeded)
__trackdelta equ 0  ; 1 to track the timing second-order deltas and only
                    ; add bits to the entropy pool conservatively
__sampleIDLE equ 1  ; 1 to sample clock drift during DOS idle (Int 0x28)
                    ; enabled by /C option on loading
; --------------------------------------------------------------------------
; ----- Note: these defines for testing only, in order to verify how much
;       entropy is generated by a particular sampling method.
NOHASH       equ 0  ; 1 disables mixing with hash function
NOMIX        equ 0  ; 1 disables mixing of new samples in pool
; --------------------------------------------------------------------------

unknowncmd equ 8003h
DONE       equ 0100h

drvname    equ 'NOISE.SYS'; name of driver
drvver     equ '0.3.5', 225 ; version (224 = Alpha, 225 = Beta)
devname    equ 'RANDOM  ' ; name of device (must be 8 characters)
attribute  equ 1000000000000000b  ; driver attribute word

                include noise.mac

if __cpu lt 3
   .err         ; 386 is min supported CPU for this version
elseif __cpu eq 3
   .386
elseif __cpu eq 4
   .486
endif

; --------------------------------------------------------------------------
_TEXT   segment word public use16 'CODE'
        assume  cs:_TEXT, ds:_TEXT
        org     0
rheader label   dword
        dd      -1                      ; device header offset        
        dw      attribute               ; character device
        dw      strategy
        dw      interrupt
        db      devname

rh      label   dword                   ; request header pointer
rh_off  label   word
        dw      ?
rh_seg  label   word
        dw      ?
; --------------------------------------------------------------------------
; Data used by the driver
index   label   word
        dw      0                       ; where new data is put
bytesavail label word                   ; output queue pointer
  ife NOHASH
        dw      0                 
statesize equ (hashbits/8)              ; 160 bits
state   label   dword                   ; initial SHA chaining variables
        dd 67452301h, 0EFCDAB89h, 98BADCFEh, 10325476h, 0C3D2E1F0h
initstate label dword                   ; initial SHA chaining variables
        dd 67452301h, 0EFCDAB89h, 98BADCFEh, 10325476h, 0C3D2E1F0h
  else
statesize equ rawsize
        dw      rawsize-1
  endif
  if __counters
samplecount label dword                 ; total samples collected
        dd      1 dup (0)
hashcount label dword                   ; total hashes performed
        dd      0
freshcount label word                   ; total fresh bits in pool
        dw      0
  endif
  if __trackdelta                       ; changes for v0.3.4
bitbuffer label word
        dw      0
bitcount  label word
        dw      0
  endif
pool    dd      80 dup (?)              ; sampling pool SHA expansion array
; --------------------------------------------------------------------------
devicetable label word
        dw      initdevice              ; Initialize driver
        dw      devok                   ; Media Check
        dw      cunknown
        dw      cunknown
        dw      devread                 ; Read
        dw      cunknown                ; Nondestructive Read (Removed 0.3.5)
        dw      devok                   ; Input Status (always return Ok)
        dw      flushdevice             ; Flush Input Buffers
MAXCMD  equ     ($ - devicetable) / 2   ; Maximum allowable command
; --------------------------------------------------------------------------
strategy        proc    far
                mov     cs:rh_off, bx
                mov     cs:rh_seg, es
                ret
strategy        endp
; --------------------------------------------------------------------------
interrupt       proc    far
                cld
                push    es
                push    ds
  if __cpu lt 3
                .err ; not yet implemented
  else
                pushad              ; save all registers
  endif
  if __cpu eq 3 ; some 386 machines have a bug with pushad/popad instructions
                nop
  endif
                mov     ax, cs      ; avoid cs: overrides, set ds = cs
                mov     ds, ax
                les     di, DWORD PTR rh
                mov     bl, es:[di].ReqHdr.CmdCode
                xor     bh, bh
                cmp     bx, MAXCMD
                ja      SHORT cunknown
                add     bx, bx
                jmp     WORD PTR devicetable[bx]
  cunknown:                            ; ----- Unknown command
                mov     ax, unknowncmd
                jmp     SHORT finished
; --------------------------------------------------------------------------
; initdevice routine moved to disposed portion of driver (v0.3.5)

  devok:                                ; Everything went Ok
                xor     ax, ax
  finished:                             ; Leave the driver
                les     bx, DWORD PTR rh ; es:[bx] -> response header
                or      ax, DONE    ; set to done code
                mov     es:[bx].ReqHdr.StatusCode, ax
  if __cpu lt 3
                .err
  else
                popad                   ; restore registers
  endif
  if __cpu eq 3
                nop
  endif
                pop     ds
                pop     es
                ret
interrupt       endp
; --------------------------------------------------------------------------
flushdevice     proc    far             ; wipe the buffer
  ife NOHASH
                mov     bx, bytesavail  ;
                mov     bytesavail,ax
  flushloop:    dec     bx
                jns     SHORT devok        
                mov     al, BYTE PTR initstate[bx]
                mov     BYTE PTR state[bx], al
                jmp     SHORT flushloop
  else                                  ; does nothing
                jmp     SHORT devok
  endif
flushdevice     endp
; --------------------------------------------------------------------------
doneread        proc    near            ; Read operation completed
                mov     bytesavail, bx  ; Save remaining bytes
;;                mov     bytesavail, 0   ; or throw away remaining bytes
                jmp     SHORT devok
doneread        endp
; --------------------------------------------------------------------------
; This expects to be called with ds == cs and es:[si] -> response header
devread         proc    near            ; Read
                mov     cx, es:[di].ReqHdr.Siz  ; Bytes to read
                mov     bx, bytesavail
                les     di, es:[di].ReqHdr.Addr  ; Address to read to
  DO_READ:
; ----- CAVEAT: rather than calling read and jumping to doneread, we push
;       the address for doneread onto the stack and go to read.
                push    OFFSET doneread
devread         endp
; --------------------------------------------------------------------------
;   cx == bytes to read, bx == available bytes
read            proc    near            ; Read data
; The Read routine was rewritten by Colin Plumb (v0.3)
  readloop:     dec     bx
                jns     SHORT copybyte
  if __counters
           ; ----- Place (freshcount+(++hashcount)+samplecount) in the pool
                xor     eax, eax     ; get freshcount value and subtract
                mov     ax, WORD PTR freshcount
                sub     ax, statesize ; (rawsize if NOHASH set)
                jns     SHORT freshleft
                xor     ax, ax
  freshleft:    xchg    ax, WORD PTR freshcount
                inc     DWORD PTR hashcount
                add     eax, hashcount
                add     eax, samplecount
                xor     DWORD PTR pool[0], eax
; ----- The call to Accumulate changed (v0.3.5) to an xor, so that entropy
; in the pool is not lost by the addition of a word with low entropy. This
; method of using a counter also allows us to use 32-bits of data as well.
; Initial tests on raw/unhashed data seem to less compressable (by 4-5%)
  endif
  ife NOHASH
                push    cx              ; Oops, we need to hash more data
                call    SHATransform
; ----- Now add the hash output back to the pool.
;       This cheaply stirs up the pool even more.
                mov     cx, statesize/2
                mov     si, OFFSET state
  recycle:
                lodsw
                call    accumulate
                loop    recycle

                pop     cx              ; And restore the pointers
  endif
                mov     bx, statesize-1

  copybyte:     ; ----- Copy bytes to user buffer
  ife NOHASH
                mov     al, BYTE PTR initstate[bx] ; (changed v0.3.5)
                xchg    al, BYTE PTR state[bx]
;               mov     BYTE PTR state[bx], bl
                ; ----- Don't keep a copy of random data!
  else
                mov     al, BYTE PTR pool[bx]
  endif
                stosb
                loop    readloop
                ret
read            endp

  ife NOHASH
                include sha.inc         ; ----- Secure Hash Transform -----
  endif

  if __sample08 ; added v0.3.5
; --------------------------------------------------------------------------
; We don't sample the timer here, rather we use the timer to trigger
; periodic samplings of other things... (Note that under Windows 3.1 this
; handler will not be called)
  ife __trackdelta
TimerLatchBuf   LABEL   WORD
        DW      (?)
TimerLatchBit   LABEL   BYTE
        DB      16
  endif
SamplePeriod    equ     8               ; must be a power of two
CycleCounter    LABEL   WORD
        DW      SamplePeriod-1
        DD      (?)
_timerlatch     proc    far
                pushf
                call    DWORD PTR cs:[_timerlatch-4] ; handle original IRQ0
                dec     WORD PTR cs:[CycleCounter]   ; adjust counter
                js      SHORT ItsTime                ; if < 0, deal with it
                iret
  ItsTime:      push    ds      ; save registers
                push    ax      ; and reset counter
                push    bx
                push    cx
                push    dx
                mov     ax, cs
                mov     ds, ax
                and     WORD PTR CycleCounter, SamplePeriod-1
; ----- Get motion counters from mouse, add changes of position to pool
                mov     ax, 0Bh
  ife __sample33
                int     33h
  else
                pushf
                call    DWORD PTR [_mousesample-4]
  endif
                mov     ax, cx  ; get horizontal mickey count
                diff    ax, dx  ; average with vertical mickey count
                shr     ax, 1
                or      ax, ax
                jz      SHORT NoMovement
; ----- Merge with __trackdelta buffer?
MouseBits       equ     4
                and     al, (1 shl Mousebits)-1
  if __trackdelta
                rcr     al, 1
                rcr     bitbuffer, 1
                dec     BYTE PTR bitcount
                jns     SHORT NoMovement
                and     BYTE PTR bitcount, 15
                mov     ax, WORD PTR bitbuffer
  else
                rol     WORD PTR TimerLatchBuf, MouseBits
                xor     BYTE PTR TimerLatchBuf, al
                sub     TimerLatchBit, MouseBits
                jns     SHORT NoMovement
                and     TimerLatchBit, 15
                mov     ax, WORD PTR TimerLatchBuf
  endif
                call    Accumulate
  NoMovement:
                pop     dx      ; restore registers
                pop     cx
                pop     bx
                pop     ax
                pop     ds
                iret
_timerlatch     endp

  endif

  if __sampleIDLE
; --------------------------------------------------------------------------
; Note: this clock-drift sampling is EXPERIMENTAL. The idea is loosley
;       inspired by Matt Blaze and D.P. Mitchell's truerand() code.
; The idea was to use the "drift" between the system timer and the CPU
; when running a tight loop.  The least significant bit (note that the
; timer may increment by 2 on some systems) is added to the main entropy
; pool every 2**(driftbits-1) calls.  [Note that the DOS idle is called
; at set times... we're looking for deltas].

; Superifical tests on a 100MHz 486DX4 appear to give a balanced output
; of 1s and 0s (unskewed). The values may need to be adjusted for other
; processors.

; This method, assuming it generates useful entropy, can also be called
; at times other than sampling, perhaps each time the driver is read
; from.

driftbits       equ     7       ; (allowable range between 4 and 15)
; ----- entropy per call is aprox. 16/(2**driftbits) bits [typo fix, v0.3.4]
CountCycles     equ     0FFFFh
  if (driftbits lt 4) or (driftbits gt 15)
                .err
  endif
;  ife __trackdelta
driftbuffer     label   word
                dw      0
driftcounter    label   byte
                dw      (1 shl driftbits)-1
;  endif
                dd      (?)
_drift          proc    near
; We don't have to worry too much about saving all registers in Int 0x28
; (It might be a source of bugs if it doesn't work on some systems...)
                push    ds              ; Save ds, and set ds = cs
                mov     ax, cs
                mov     ds, ax
                SampleTimerWord
                push    ax
                mov     eax, CountCycles
  CountLoop:    dec     eax
                jns     SHORT CountLoop
; ----- The call to BIOS Event Wait was replaced by this counter (v0.3.5)
                SampleTimerWord
                pop     bx
                diff    al, bl          ; Very low deltas, so we use 1 bit
; ----- mixing w/trackdelta bitbuffer seems to reduce entropy overall,
;       since the idler samples less than 1 bit per call
;  if __trackdelta
;                rcr     al, 1
;                rcr     WORD PTR bitbuffer, 1
;                dec     BYTE PTR bitcount
;                jns     SHORT notyetaccum
;                and     BYTE PTR bitcount, 15
;                mov     ax, WORD PTR bitbuffer
;  else
                and     al, 1
                rol     WORD PTR driftbuffer, 1  ; shl/or changed (v0.3.3)
                xor     BYTE PTR driftbuffer, al
                dec     BYTE PTR driftcounter
                jns     SHORT notyetaccum        ; jns, not jnz (v0.3.4)
                and     WORD PTR driftcounter, (1 shl driftbits)-1
                mov     ax, WORD PTR driftbuffer
;  endif
                call    accumulate
  notyetaccum:
                pop     ds
                jmp     DWORD PTR cs:[_drift-4]
_drift          endp
  endif

; ----- The interrupt hooks are here:
  if __sample09
        GenericSampler _keysample
  endif
  if __sample13
        GenericSampler _dsksample
  endif
  if __sample14
        GenericSampler _portsample
  endif
  if __sample33
        GenericSampler _mousesample
  endif
; --------------------------------------------------------------------------
sample          proc    near
; Trashes ax and bx, expects to be called with ds == cs.
; Leaves everything else alone.
  ife __trackdelta
                SampleTimerWord     ; Get 16-bit sample from timer0
  else
                SampleTimerWord
;;                mov     ah, 0       ; Use only 8-bits
; ----- Using an 8-bit sample forces the driver to assume lower deltas and
;       be more conservative with adding bits... in reality?
; Based on second-order delta code from random.c v0.93 by Theodore Ts'o
; The effect seems to be slightly more entropy when multiple sources are
;       sampled.
                mov     bx, cx
                mov     cx, ax
                diff    ax, [bx].tDelta.LastTick  ; Delta = jiffy - LastTick
                xchg    ax, [bx].tDelta.LastDelta ; swap Delta w/ LastDelta
                diff    ax, [bx].tDelta.LastTick  ; ax = LastDelta - LastTick
                mov     [bx].tDelta.LastTick, cx  ; LastTick = jiffy
                mov     cx, -1                    ; nbits = -1
                cmp     ax, [bx].tDelta.LastDelta ; delta=MIN(Delta,LastDelta)
                jb      SHORT deltamin
                mov     ax, [bx].tDelta.LastDelta
  deltamin:     inc     cx                        ; nbits++
                shr     ax, 1                     ; delta>=1
                or      ax, ax                    ; while (!delta)
                jnz     SHORT deltamin
                ror     WORD PTR bitbuffer, cl    ; shift buffer right nbits
; ----- Note that this code also can waste some bits...
                sub     BYTE PTR bitcount, cl     ; bitcount += nbits
  if __counters
                add     BYTE PTR freshcount, cl   ; count number of bits
                and     freshcount, (rawsize*8)-1
  endif
                neg     cl                        ; nbits' = 16-nbits
                add     cl, 16
                mov     ax, [bx].tDelta.LastTick
                shl     ax, cl           ; ax = juffy sifted left (16-nbits)
                xor     bitbuffer, ax    ; put bits into buffer
                cmp     BYTE PTR bitcount, 0
                jns     SHORT enoughbits
                ret
  enoughbits:   and     BYTE PTR bitcount, 15
                mov     ax, WORD PTR bitbuffer
  endif
sample          endp
  if __counters ; ----- increment counters
; This is unnecessary if we recycle the state information back into
; the pool.
                inc     DWORD PTR samplecount
    ife __trackdelta
                add     freshcount, 16            ; count number of bits
                and     freshcount, (rawsize*8)-1
    endif
  endif
accumulate      proc    near ; ---------------------------------------------
  ife NOMIX                  ; pool mixing function by Colin Plumb
                include polynom2.inc   ; v0.3.5
;;                include polynom.inc  ; v0.3.4 and earlier
  else                  ; ----- NOMIX accumulation in buffer
; Unmixed accumulation simply adds the new samples to the queue. It is
; used for testing and experimenting with sample methods only!
                mov     bx, index
                add     bx, 2
                and     bx, 62
                mov     index, bx
  endif
                mov     WORD PTR pool[bx], ax        
                ret
accumulate      endp

EndOfDevice     equ     $
; --------------------------------------------------------------------------
; all code after this point is only needed for installation of the driver
; --------------------------------------------------------------------------

; alreadymsg label byte
;  db drvname, ' is already installed!', CR, LF, LF, EndString

; ----- utility routine to convert a two-digit hex/decimal to ascii
;       mov al, byte_to_convert, then do aam 10 or aam 16 for dec or hex
digits          proc    near
                xchg    ax, dx
                xor     bh, bh
                mov     bl, dh
                mov     al, hextbl[bx]
                mov     bl, dl
                mov     ah, hextbl[bx]
                ret
hextbl          label   byte
                db '0123456789ABCDEF'
digits          endp
; ----- hook interrupts and print a small message
;       assumes al=int, bx=routine (save oldvec at bx-4)
install_int     proc    near
                push    ax              ; output Interrupt name
                push    bx
  ifndef MASM
                aam     16 ; (*) MASM 5.0 cannot assemble this
  else
                db      0D4h, 10h
  endif
                call    digits
                mov     WORD PTR HexTxt, ax
                DosPrnt IntMsg
                pop     bx
                pop     ax
; ----- Note: this routine does not check to see if DOS rejects the hook
                pushf
                cli
                push    ax
                push    bx
                mov     ah, 35h
                int     DOS
                pop     ax
                xchg    ax, bx
                mov     WORD PTR [bx-2], es
                mov     WORD PTR [bx-4], ax
                mov     dx, bx
                pop     ax
                mov     ah, 25h
                int     DOS
                popf
                ret
install_int     endp
; --------------------------------------------------------------------------
  initdevice:                          ; assumes es:[di] -> response header
                call    driverinit
                les     bx, DWORD PTR rh
                lea     dx, EndOfDevice
                mov     WORD PTR es:[bx].ReqHdr.Addr, dx
                mov     WORD PTR es:[bx].ReqHdr.Addr+2, cs
                jmp     finished
; --------------------------------------------------------------------------
OptionFlags     LABEL   WORD
                DW      0
EnableMouse     EQU     0001h
EnablePeriod    EQU     0002h
EnableDrift     EQU     0004h
ShowLicenseFlag EQU     8000h

; ----- interpret command line argumentsd passed to the driver (v0.3.2)
initargs        proc    near
; Note: MS-DOS 5.0 will convert to uppercase from CONFIG.SYS, but
;       DEVLOD will not from the command-line.
                cmp     ah, 'a'
                jb      SHORT IsUpcase
                cmp     ah, 'z'
                ja      SHORT IsUpcase
                sub     ah, 20h
  IsUpcase:
; ----- Rewrite this *very* soon to use tables! -----
  if (initseedcnt ne 0) and (__sample09 ne 0)
                cmp     ah, 'I'     ; /I = Initialize with keystrokes
                jne     SHORT nokey
                mov     seedcount, initseedcnt
                jmp     SHORT argumentloop
  nokey:
  endif
  if __sampleIDLE
                cmp     ah, 'C'
                jne     SHORT nodrift
                or      WORD PTR OptionFlags, EnableDrift
                jmp     SHORT argumentloop
  nodrift:
  endif
  if __sample33
                cmp     ah, 'M'
                jne     SHORT NoMouseE
                or      WORD PTR OptionFlags, EnableMouse
                jmp     SHORT argumentloop
  NoMouseE:
  endif
  if __sample08
                cmp     ah, 'P'
                jne     noperiod
                or      WORD PTR OptionFlags, EnablePeriod
                jmp     SHORT argumentloop
  noperiod:
  endif
                cmp     ah, 'L'     ; /L = Show license
                jne     SHORT nolicense
                or      WORD PTR OptionFlags, ShowLicenseFlag
                jmp  SHORT ArgumentLoop
  nolicense:
                mov     BYTE PTR IllegalOption, ah
                DosPrnt Illegal
; Bugs? v0.3.3 no longer works under OS/2 DOS box... the driver always
;       seems to be receiving a /P option.  Define __IgnoreBadOpts
ifndef __IgnoreBadOpts
                mov     ax, -1
                ret
else
                jmp  SHORT ArgumentLoop
endif
initargs        endp
; --------------------------------------------------------------------------
driverinit      proc    near    ; Initialize the driver
; ----- this code was moved to the disposable region, since the driver does
;       not need it after installation (v0.2.2)
                DosPrnt InitMsg
  if __cpu ge 2
                call    TestCPU
                or      ax, ax
                jz      SHORT CorrectCPU
                not     ax
                ret
  CorrectCPU:
  endif
; ----- check for command-line arguments passed to driver (v0.3.2)
                les     di, DWORD PTR es:[di+18]
  ArgumentLoop:
                inc     di
                mov     ax, es:[di]
                cmp     al, CR
                je      SHORT endofargs
                cmp     al, '/'
                jne     SHORT argumentloop
                jmp     SHORT initargs
  endofargs:
                test    WORD PTR OptionFlags, ShowLicenseFlag
                jz      SHORT NoShowLic
                DosPrnt LicenseText
 NoShowLic:
; Possibility of aborting installation if other problems occur...
                DosPrnt StartInstall
; ----- install interrupts -----
  if  __sample08
                test    OptionFlags, EnablePeriod
                jz      SHORT NoEnablePeriod
    if __sample33
                test    OptionFlags, EnableMouse
                jnz     SHORT MouseEPE
                mov     ax, 3533h
                int     DOS
                mov     WORD PTR _mousesample-4, bx
                mov     WORD PTR _mousesample-2, es
    MouseEPE:
    endif
                mov     al, 8
                mov     bx, OFFSET _timerlatch
                call    install_int
  NoEnablePeriod:
  endif
  if __sample09
                mov     al, 9       ; install sampling of keyboard
                mov     bx, OFFSET _keysample
                call    install_int
  endif
  if __sample13
                mov     al, 13h     ; install sampling of disk access
                mov     bx, OFFSET _dsksample
                call    install_int
  endif
  if __sample14
                mov     al, 14h     ; install sampling of com port
                mov     bx, OFFSET _portsample
                call    install_int
  endif
  if __sample33
                test    OptionFlags, EnableMouse
                jz      SHORT NoEnableMouse
                mov     al, 33h
                mov     bx, OFFSET _mousesample
                call    install_int
  NoEnableMouse:
  endif
  if __sampleIDLE
                test    OptionFlags, EnableDrift
                jz      SHORT NoEnableDrift
                mov     al, 28h
                mov     bx, OFFSET _drift
                call    install_int
  NoEnableDrift:
  endif
                DosPrnt NewLine
; --------------------------------------------------------------------------
  if (initseedcnt ne 0) and (__sample09 ne 0)
; ----- initialize the sampling pool with some keystrokes
                mov     al, BYTE PTR seedcount
                or      al, al
                jz      SHORT nosample
                DosPrnt SeedMessage
  seedlings:
                mov     al, BYTE PTR SeedCount
                xor     ah, ah
                aam     10
                call    digits
                mov     WORD PTR digitcount, ax
                DosPrnt DigitCount
                mov     ah, 0
                int     keyboard
                dec     BYTE PTR seedcount
                jnz     SHORT seedlings
                DosPrnt OkMessage
  nosample:
  endif
                xor     ax, ax       ; return 0 = ok
                ret
driverinit      endp

                include cpuid.inc    ; TestCPU routine

; --------------------------------------------------------------------------
initmsg label byte  ; ----- Initial text messages and other stuff
        db CR, LF
        db drvname, ' v', drvver, ' /dev/random driver for DOS'
  ifdef ??date
        db ' ', ??date
  endif
        db CR, LF
        db 'by Robert Rothenburg Walking-Owl. Portions by Colin Plumb.'
        db CR, LF, 'Copyright (C) 1995-96, All Rights Reserved.', CR, LF, LF
        db EndString
; ----- This section is for displaying warnings when debug options enabled
NewLine LABEL BYTE
  if __trackdelta
        db CR, LF, 'Second-order delta tracking enabled.'
  endif
  if (NOHASH+NOMIX)
        db CR, LF, 'WARNING: '
  endif
  if NOHASH
        db 'Hashing is disabled. '
  endif
  if NOMIX
        db 'Mixing is disabled. '
  endif
; ----- End warnings -----
  if __counters
        db CR, LF, 'Counter enabled.'
  endif
        db CR, LF, EndString
StartInstall LABEL   BYTE
        DB 'Hooking interrupts:', EndString
IntMsg  LABEL   BYTE
        DB ' ??', EndString
HexTxt  equ     $ - 3
  if initseedcnt
seedcount label byte
        db  0   
seedmessage label byte
        db CR, LF
        db 'Please type some random keystrokes to seed the driver: '
        db EndString
digitcount label  byte
        db '00', BackSpace, BackSpace, EndString
okmessage label byte
        db 'Done!', BELL, CR, LF, EndString
  endif
; ----- Command Line Stuff
Illegal LABEL BYTE
        DB 'Illegal option: /?', CR, LF, BELL
IllegalOption   equ $ - 4
        DB 'Allowable options:', CR, LF
  if (initseedcnt ne 0) and (__sample09 ne 0)
        DB ' /I         Initialize entropy pool with keystrokes', CR, LF        
  endif
  if __sample33
        DB ' /M         sample timings between Mouse interrupt calls', CR, LF
  endif
  if __sample08
        DB ' /P         Periodically sample changes in mouse position', CR, LF
  endif
  if __sampleIDLE
        DB ' /C         sample Clock drift during DOS idle', CR, LF
  endif
        DB ' /L         show software License', CR, LF
        DB EndString
; --------------------------------------------------------------------------
LicenseText: ; accidentally used wrong text, fixed v0.3.4
     DB '    This program is free software; you can redistribute it and/or modify', CR, LF
     DB '    it under the terms of the GNU General Public License as published by', CR, LF
     DB '    the Free Software Foundation.', CR, LF
     DB LF
     DB '    This program is distributed in the hope that it will be useful,', CR, LF
     DB '    but WITHOUT ANY WARRANTY; without even the implied warranty of', CR, LF
     DB '    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the', CR, LF
     DB '    GNU General Public License for more details.', CR, LF
     DB LF
     DB '    You should have received a copy of the GNU General Public License', CR, LF
     DB '    along with this program; if not, write to the Free Software', CR, LF
     DB '    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.', CR, LF
     DB LF, EndString
; --------------------------------------------------------------------------

_TEXT   ends
        end


