/*
  Shatest.c is based on Peter Gutmann's shsdrvr.c program.  This is a
  a rushed hack meant to test the sha.inc file for the noise driver,
  and then later a secure-hash equivalent of the md5sum.c utility that
  can be found in PGP
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <mem.h>
#include "shs.h"

/* Prototypes of the local functions */
local void shsPrint OF((SHS_INFO *shsInfo));
local void shsTimeTrial OF((void));
local void shsString OF((char *inString));
local SHS_INFO *getshsFile OF((char *filename));
local void shsFile OF((char *filename));
local void shsFilter OF((void));
local void shsTestSuite OF((void));
local void usage OF((void));
      void main OF((int argc, char **argv));

/*
 * Prints message digest buffer in shsInfo as 40 hexadecimal digits. Order is
 * from low-order byte to high-order byte of digest. Each byte is printed
 * with high-order hexadecimal digit first.
 */
local void shsPrint (shsInfo)
	SHS_INFO *shsInfo;
{
	int i;

	for (i = 0; i < 5; i++)
		printf ("%08lx", shsInfo->digest [i]);
}

/* size of test block */
#define TEST_BLOCK_SIZE 1000

/* number of blocks to process */
#define TEST_BLOCKS 10000

int filemode = 0, verbose = 0;

/* number of test bytes = TEST_BLOCK_SIZE * TEST_BLOCKS */
local long TEST_BYTES = (long) TEST_BLOCK_SIZE * (long) TEST_BLOCKS;

/*
 * A time trial routine, to measure the speed of SHA.
 *
 * Measures wall time required to digest TEST_BLOCKS * TEST_BLOCK_SIZE
 * characters.
 */
local void shsTimeTrial ()
{
	SHS_INFO shsInfo;
	time_t endTime, startTime;
        unsigned char data [TEST_BLOCK_SIZE];
	unsigned int i;

	/* initialize test data */
	for (i = 0; i < TEST_BLOCK_SIZE; i++)
		data [i] = (unsigned char) (i & 0xFF);

	/* start timer */
	printf ("SHA time trial. Processing %ld characters...\n", TEST_BYTES);
	time (&startTime);

	/* digest data in TEST_BLOCK_SIZE byte blocks */
	shsInit (&shsInfo);
	for (i = TEST_BLOCKS; i > 0; i--)
		shsUpdate (&shsInfo, data, TEST_BLOCK_SIZE);
	shsFinal (&shsInfo);

	/* stop timer, get time difference */
	time (&endTime);
	shsPrint (&shsInfo);
	printf (" is digest of test input.\nSeconds to process test input: %ld\n",
		(long) (endTime - startTime));
	printf ("Characters processed per second: %ld\n",
		TEST_BYTES / (endTime - startTime));
}

/*
 * Computes the message digest for string inString. Prints out message
 * digest, a space, the string (in quotes) and a carriage return.
 */
local void shsString (inString)
	char *inString;
{
	SHS_INFO shsInfo;
	unsigned int len = strlen (inString);

	shsInit (&shsInfo);
	shsUpdate (&shsInfo, (unsigned char *) inString, len);
	shsFinal (&shsInfo);
	shsPrint (&shsInfo);
	printf (" \"%s\"\n", inString);
}

/*
 * Computes the message digest for a specified file and returns it.
 * Originally was part of shsFile, but it was made into a separate
 * function to be shared with shsCheck(); --Rob Walking-Owl
 */

#ifdef __MSDOS__
  #define BUFFSZ 8192 /* more efficient disk access on DOS systems */
#else
  #define BUFFSZ 1024
#endif

local SHS_INFO *getshsFile (filename)
        char *filename;
{
        FILE *inFile = fopen(filename, (filemode)?"rb":"rt");
	SHS_INFO shsInfo;
	int bytes;
        local unsigned char data [BUFFSZ];

#ifdef __MSDOS__
        strlwr(filename);
#endif
	if (inFile == NULL) {
                return NULL;
	}
	shsInit (&shsInfo);
        while ((bytes = fread (data, 1, BUFFSZ, inFile)) != 0)
		shsUpdate (&shsInfo, data, bytes);
	shsFinal (&shsInfo);
	fclose (inFile);
        return &shsInfo;
}

/* 
 * Get message digest of file. Prints out message digest, a space, a flag
 * (space or asterisk) as to whether file is read in ascii or binary mode,
 * the file name, and a carriage return.
 */
local void shsFile (filename)
	char *filename;
{
        SHS_INFO *shsInfo;
	int bytes;
        local unsigned char data [BUFFSZ];
        if ((shsInfo=getshsFile(filename))!=NULL) {
          shsPrint (shsInfo);
          printf (" %c%s\n", (filemode)?'*':' ', filename);
        } else fprintf (stderr, "%s can't be opened.\n", filename);
}

/*
 * Writes the message digest of the data from stdin onto stdout,
 * followed by a carriage return.
 */
local void shsFilter ()
{
	SHS_INFO shsInfo;
	int bytes;
	local unsigned char data [SHS_BLOCKSIZE];

	shsInit (&shsInfo);
	while ((bytes = fread (data, 1, SHS_BLOCKSIZE, stdin)) != 0)
		shsUpdate (&shsInfo, data, bytes);
	shsFinal (&shsInfo);
	shsPrint (&shsInfo);
	printf ("\n");
}

/*
 * Runs a standard suite of test data.
 */
local void shsTestSuite ()
{
	printf ("SHA test suite results:\n");
	shsString ("");
	shsString ("a");
	shsString ("abc");
	shsString ("message digest");
	shsString ("abcdefghijklmnopqrstuvwxyz");
	shsString ("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789");
	shsString ("1234567890123456789012345678901234567890\
1234567890123456789012345678901234567890");
	/* Contents of file foo are "abc" */
	shsFile ("foo");
}

/*
 * Checks message disgests listed in text file (based on output generated
 * by previous checks)
 */

static unsigned long failed=0, totalchecked=0;

local unsigned long shsCheck(filename)
	char *filename;
{
        FILE *inFile = fopen(filename, "rt");
        FILE *testFile;
        SHS_INFO shsInfo, *shsFileInfo;
        int i;
        unsigned long failcount;
        local unsigned char data [BUFFSZ];
        char *p, testfilename [256], fmode;

        failcount=0;
#ifdef __MSDOS__
        strlwr(filename);
#endif
	if (inFile == NULL) {
		printf ("%s can't be opened.\n", filename);
                return(0);
	}
        if (inFile!=NULL) for (;;) {
           if ((p=fgets(&data, BUFFSZ, inFile))==NULL) break;
           else if (strlen(data)>30) {
             /* Note: no error checking as to whether line is formatted
                correctly */
                for (i=0; i<5; i++) {
                  sscanf(p, "%8lx", &shsInfo.digest[i]);
                  p+=8;
                }
                sscanf(++p, "%1c%s", &fmode, &testfilename);
                filemode=(fmode=='*')?1:0;
                shsFileInfo = getshsFile(&testfilename);
                if (shsFileInfo!=NULL) {
                  ++totalchecked;
                  if (verbose) printf("%-14s", testfilename);
                  if (strncmp(shsFileInfo,&shsInfo,20)!=0) {
                        failcount++;
                        if (verbose) printf(" FAILED\n");
                   }
                 else if (verbose) printf(" OK\n");
               } else if (verbose)
                  fprintf (stderr,
                         "%s can't be opened.\n", testfilename);
           }
        }
	fclose (inFile);
  return(failcount);
}


local void usage ()
{
  fprintf(stderr,
    "usage: shatest [-bv] [-c filename] | [filename] | [-s string] [-tx]\n"
    "Generates or checks revised Secure Hash Algorithm message digests.\n"
    "  -b  read files in binary mode when generating (default is text)\n"
    "  -c  check message digests (default is to generate)\n"
    "  -v  show filenames when checking\n"
    "  -s  prints message digest and contents of string\n"
    "  -t  prints time strial statistics for 10M characters\n"
    "  -x  executates a standard test suite\n"
    "The input for -c should be the list of message digests and\n"
    "and filenames printed to stdout that this program generates.\n"
    );
}

void main (argc, argv)
	int argc;
	char **argv;
{
        int i,j;
        static int check=0;

	if (argc == 1)
		shsFilter ();
	else
		for (i = 1; i < argc; i++)
                        if (argv [i] [0] == '-') {
                          for (j = 1; j < strlen(argv [i]); j++)
                            switch(argv[i] [j]) {
                              case 'h':
                                usage();
                                exit(EXIT_SUCCESS);
                                break;
                              case 't':
                                shsTimeTrial();
                                exit(EXIT_SUCCESS);
                                break;
                              case 'x':
                                shsTestSuite();
                                exit(EXIT_SUCCESS);
                                break;
                              case 'b':
                                filemode = 1;
                                break;
                              case 'c':
                                check = 1;
                                break;
                              case 'v':
                                verbose = 1;
                                break;
                              case 's':
                                j = strlen(argv [i]);
                                shsString( argv [++i]);
                                break;
                              default:
                                fprintf(stderr,
                                  "unrecognized option: -%c\n", argv[i][j]);
                                usage();
                                exit(EXIT_FAILURE);
                                break;                                
                            }
                        } else if (check) failed+=shsCheck (argv [i]);
                          else shsFile (argv [i]);
/*
			if (argv [i] [0] == '-' && argv [i] [1] == 's')
				shsString (argv [i] + 2);
			else if (strcmp (argv [i], "-t") == 0)
				shsTimeTrial ();
			else if (strcmp (argv [i], "-x") == 0)
				shsTestSuite ();
                        else if (strcmp (argv [i], "-b") == 0)
                                filemode = 1;
                        else if (strcmp (argv [i], "-h") == 0) {
                                usage();
                                break;
                             }
                        else if (strcmp (argv [i], "-c") == 0) {
                                check = 1;
                             }
                        else if (strcmp (argv [i], "-v") == 0) {
                                verbose = 1;
                             }
                        else if (argv [i][0] == '-') {
                                fprintf(stderr,
                                  "unrecognized option: %s\n", argv[i]);
                                usage();
                                exit(EXIT_FAILURE);
                                break;
                             }
                        else if (check) failed+=shsCheck (argv [i]);
                        else shsFile (argv [i]); */
   if (!failed) exit(EXIT_SUCCESS);
   else {
     if (verbose)
       fprintf(stderr, "%ld of %ld file(s) failed Secure Hash check.\n",
            failed, totalchecked);
     exit(EXIT_FAILURE);
   }
}

