#ifndef PAN_FILE_MED
#define PAN_FILE_MED

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include "file_low.h"

#ifdef __cplusplus
extern "C" {
#endif

/*****Define stuff*****/

#define typeEntry 3
#define typeValue 2
#define typeBlock 1
#define typePartitio 0

/************* Extraction Routine *********************/

/*
 * Close all open files. If not open it doesn't try to close since
 * this will core dump.
 */
void CloseNDS(FILE *fEntry, FILE *fValue, FILE *fBlock)
{
  if (fEntry) fclose(fEntry);
  if (fValue) fclose(fValue);
  if (fBlock) fclose(fBlock);
}

/*
 * This routine counts the number of ENTRY.NDS records and returns the
 * value. Return j-1 to adjust for extra zero count record.
 */
long int countEntryRecords(FILE *fEntry)
{
 ldiv_t calc;
 fseek(fEntry,size_entry,SEEK_END);
 calc=ldiv((uint32)ftell(fEntry),size_entry);
 return((long int)(calc.quot-1));
}

/*
 * This routine scans through ENTRY.NDS records and looks for the object
 * ID of the User object and the Private Key. They are written to globals.
 * Here we also store in sys_obj all the names and ID's we can found in
 * Entry.NDS
 */
void findObjectIDs(FILE *fEntry, long int j, char *sys_obj,
                   uint32 *OBJECT_CLASS, uint32 *P_KEY, int type_obj)
{
 int i;
 long int count=0;
 char str_id[9];
 ENTRY pEntry;

 rewind(fEntry);
 while(j!=0)
  {
   fread(&pEntry,size_entry,1,fEntry);

   #ifdef BIG_ENDIAN
   pEntry.id=swap_uint32(pEntry.id);
   #endif
   sprintf(str_id,"%08lx",pEntry.id);
   for (i=0;i<8;i++) sys_obj[count+i]=str_id[i]; count+=8;
   for (i=0;i<40;i++) sys_obj[count+i]=pEntry.name[i]; count+=40;

   if(pEntry.classID==0xffffffff)
    {
     if (type_obj==1)
      if(pEntry.name[0]==0x55 && pEntry.name[2]==0x73 && pEntry.name[4]==0x65 && pEntry.name[6]==0x72)
       *OBJECT_CLASS=pEntry.id;

     if (type_obj==2)
      if(pEntry.name[0]==0x42 && pEntry.name[2]==0x69 && pEntry.name[4]==0x6E && pEntry.name[6]==0x64
         && pEntry.name[8]==0x65 && pEntry.name[10]==0x72 && pEntry.name[12]==0x79
         && pEntry.name[14]==0x20 && pEntry.name[16]==0x4F)
       *OBJECT_CLASS=pEntry.id;

      if(pEntry.name[0]==0x50 && pEntry.name[2]==0x72 && pEntry.name[4]==0x69 && pEntry.name[6]==0x76)
     *P_KEY=pEntry.id;
    }
   j--;
  }
}

/* Customized search, returns the pos in a string, takes : string to be
 * searched, length of that string, string looked for, length of that
 * string. The usual strstr(...) caused too much trouble with Unicode strings.
 */
long int search_id(char *in,long int in_long,char *what)
{
 int count=0;
 long int j;

 for (j=0;j<in_long;j++)
  {
   if (in[j]==what[count]) count++;
    else {j+=(47-count); count=0;}
   if (count==8) return(j-7);
  }
 return(-1);
}

/*
 * Main prog...
 */
int extract(Pan_PassList pPassList,int type_obj, char *path)
{
 FILE *fEntry;    ENTRY pEntry;
 FILE *fValue;    VALUE pvalue;
 FILE *fBlock;    BLOCK pblock;
 uint32 f,OBJECT_CLASS,P_KEY;
 short i,l,TEST=FALSE;
 long int nb_records,j,k;
 char str_id[9];
 char *sys_obj;

 /** Ansi convention : declare the function before call if FILE * ref */
 void     CloseNDS(FILE *fEntry, FILE *fValue, FILE *fBlock);
 long int countEntryRecords(FILE *fEntry);
 void     findObjectIDs(FILE *fEntry, long int j, char *sys_obj,
                        uint32 *OBJECT_CLASS, uint32 *P_KEY, int type_obj);

 /*
  * This union is needed as we need to read in four bytes from the
  * private key and write them out as a long.
  */
 union
 {uint8 inBytes[4];
  uint32 asLong;
 } Info;

 /* Open NDS and password target file */
   fEntry=fopen((char *)strcat(path,"ENTRY.NDS"),"rb");
   path[strlen(path)-9]='\0';
   fValue=fopen((char *)strcat(path,"VALUE.NDS"),"rb");
   path[strlen(path)-9]='\0';
   fBlock=fopen((char *)strcat(path,"BLOCK.NDS"),"rb");
   path[strlen(path)-9]='\0';
   if (!(fEntry && fValue && fBlock))
   {CloseNDS(fEntry,fValue,fBlock);
    return(-200);
   }

 /* Scan for object IDs we need */
 /* Count ENTRY.NDS and VALUE.NDS records */
 /* Saves all objects ID's and OU */
 nb_records=countEntryRecords(fEntry);
 sys_obj=(char *)malloc(sizeof(char)*48*nb_records);
 if (sys_obj==NULL) {CloseNDS(fEntry,fValue,fBlock);
                     return(-201); /** Out of memory **/
                    }

 findObjectIDs(fEntry,nb_records,sys_obj,&OBJECT_CLASS,&P_KEY,type_obj);
 rewind(fEntry);

 /* Main loop. If a user is found, print the CN and object ID to the
  * screen and a file. Then get the password length
  * and one-way encrypted password hash.
  */
 j=nb_records;
 while(j!=0)
 {
  fread(&pEntry,size_entry,1,fEntry);
  #ifdef BIG_ENDIAN
  pEntry.classID=swap_uint32(pEntry.classID);
  #endif
  if (pEntry.classID == OBJECT_CLASS) /*Is record type of Object searched*/
   {
    #ifdef BIG_ENDIAN
    pEntry.firstValue=swap_uint32(pEntry.firstValue);
    #endif
    f=pEntry.firstValue;
    while (f!=0xffffffff)
     {
      fseek(fValue,f,SEEK_SET);
      fread(&pvalue,size_value,1,fValue);
      #ifdef BIG_ENDIAN
      pvalue.entryID=swap_uint32(pvalue.entryID);
      pEntry.id=swap_uint32(pEntry.id);
      #endif
      if (pvalue.entryID!=pEntry.id)
       {CloseNDS(fEntry,fValue,fBlock);
        return(-203); /** Cross Reference **/
       }
      #ifdef BIG_ENDIAN
      pvalue.typeID=swap_uint32(pvalue.typeID);
      #endif
      if (pvalue.typeID==P_KEY) break;
      #ifdef BIG_ENDIAN
      pvalue.nextVal=swap_uint32(pvalue.nextVal);
      #endif
      f=pvalue.nextVal;
     }

    if (f!=0xffffffff)
     {
      /** Memory allocation for the list **/
      /** of users saved in memory as chained pointers   **/
      if (TEST)
       {pPassList->next=Pan_PassList_alloc();
        if (pPassList->next==NULL) return(-201);
        pPassList=pPassList->next;
       }
      TEST=TRUE; /*We have to do this dumb TEST thing, otherwise we*/
                 /*allways allocate one more record than needed*/
      fseek(fValue,f,SEEK_SET);
      fread(&pvalue,size_value,1,fValue);

      if (type_obj==1)
       {for (i=0;i<258;i++) pPassList->userCN[i]=pEntry.name[i];
        pPassList->bind=0x0100;
       }

      if (type_obj==2)
       {for (i=0;i<258;i++) if(pEntry.name[i]==(uint8)'+') l=i;
        for (i=0;i<l;i++) pPassList->userCN[i]=pEntry.name[i];
        for (i=l;i<258;i++) pPassList->userCN[i]=NULL;
        i=28;/*afther "+Bindery type="*/ pPassList->bind=0; /*initialize*/
        while(isdigit(pEntry.name[l+i]))
         {pPassList->bind=pPassList->bind*10+atoi((char *)(pEntry.name+l+i));
          i+=2; /* Next digit in unicode string*/
         }
        pPassList->bind=swap_uint16(pPassList->bind);
        /* We store the value in little endian since we need it */
        /* for network use mainly */
       }

      pPassList->id=pEntry.id; /*Already endian treated */
      #ifdef BIG_ENDIAN
      pEntry.parentID=swap_uint32(pEntry.parentID);
      #endif
      pPassList->parentID=pEntry.parentID;
      for (i=0;i<4;i++) Info.inBytes[i]=pvalue.data[i];
      pPassList->objectID=Info.asLong; /*Don't need endian treatment*/
      pPassList->pwlen_known=TRUE;
      pPassList->pwlen=pvalue.data[4];
      pPassList->pwhash_known=TRUE;
      for (i=0;i<8;i++) pPassList->hash[i]=pvalue.data[i+8];
      #ifdef BIG_ENDIAN
      pvalue.firstBlock=swap_uint32(pvalue.firstBlock);
      #endif
      f=pvalue.firstBlock;

      fseek(fBlock,f,SEEK_SET);
      fread(&pblock,size_block,1,fBlock);
      for (i=0;i<8;i++) pPassList->hash[i+8]=pblock.data[i];
      sprintf(str_id,"%08lx",pPassList->parentID);
      k=search_id(sys_obj,nb_records*48,str_id);
      if (k!=-1)
       for (i=0;i<40;i++) pPassList->userOU[i]=sys_obj[k+i+8];
      else
       for (i=0;i<40;i++) pPassList->userOU[i]=NULL;
     }
    }
   j--;
  }
 /* Close things up... */
 CloseNDS(fEntry,fValue,fBlock);
 return(NULL);
}
/******************End of Extraction routine***********/
/******************Conversion routine for BACKUP.DS****/
/* 
 * This routine simply gets and returns the value of an offset.
 */
uint32 get_an_offset(FILE *fBackup,uint32 *SCAN)
{
 uint32 k;
 uint32 j;

 fseek(fBackup,*SCAN,SEEK_SET);
 fread(&j,4,1,fBackup);
 k=j;
 #ifdef BIG_ENDIAN
 k=swap_uint32(k);
 #endif
 return(k);
}

/*
 * This routine looks for 0xfffffffe. The first occurance of 
 * this will be in the first ENTRY.NDS record. Once found,
 * SCAN is updated and fBackup is seeked so that the next
 * offset to be read will be the number of records in 
 * ENTRY.NDS.
 */
int findFirstEntryRecord(FILE *fBackup,uint32 *SCAN)
{
  uint32 k;
  int FOUND;
  long int counter;

  FOUND=FALSE;
  while(!(feof(fBackup)))
  {
    k=get_an_offset(fBackup,SCAN);
    if (k==0xfffffffe)
    {
      *SCAN=(ftell(fBackup)-16);
      fseek(fBackup,*SCAN,SEEK_SET);
      FOUND=TRUE;
      break;
    }
    (*SCAN)++;
  }
  return(FOUND);
}

/*
 * This routine creates each file for NDS as it is called. It is
 * passed the number of records, the filename, and the file type.
 */
int makeNDS(FILE *fBackup,long int records, char *filename, int filetype)
{
  FILE *fTemp;
  uint8 pentry[size_entry];
  uint8 pvalue[size_value];
  uint8 pblock[size_block];
  uint8 ppartitio[size_partitio];
  int cc,cb,i;
  i=0;

  fTemp = fopen(filename,"w+b");
  if (fTemp == NULL) return(-300);
  for(i=0;i<records;i++)
  {
    switch (filetype) {
    case typeEntry:
       cc=fread(pentry,size_entry,1,fBackup);
       cb=fwrite(pentry,size_entry,1,fTemp);
       break;
    case typeValue:
       cc=fread(pvalue,size_value,1,fBackup);
       cb=fwrite(pvalue,size_value,1,fTemp);
       break;
    case typeBlock:
       cc=fread(pblock,size_block,1,fBackup);
       cb=fwrite(pblock,size_block,1,fTemp);
       break;
    case typePartitio:
    default:
       cc=fread(ppartitio,size_partitio,1,fBackup);
       cb=fwrite(ppartitio,size_partitio,1,fTemp);
      break;
    }
   if (cc==0 || cb==0) return(-301);
  }
 fclose(fTemp);
 return(NULL);
}

/*
 * This routine takes the size of a record as input, checks the
 * current offset, calculates the number of records, and advances
 * SCAN to point past the NDS file. It returns the number of
 * records found.
 */
long int countRecords(FILE *fBackup,uint32 *SCAN,int size)
{
  uint32 t;
  ldiv_t calc;
  long int j;

  t=get_an_offset(fBackup,SCAN);
  calc=ldiv(t,size);
  j = calc.quot;
  (*SCAN) += (calc.quot * size)+4;
  return(j);
}

/*
 * Main program....
 */
int convert(char *path)
{
  FILE *fBackup;
  int err;
  long int j;
  uint32 SCAN=0;
  ldiv_t calc;

/** Ansi convention : declare the function before call if FILE * ref */
 int makeNDS(FILE *fBackup,long int records,char *filename,int filetype);
 uint32 get_an_offset(FILE *fBackup,uint32 *SCAN);
 int findFirstEntryRecord(FILE *fBackup,uint32 *SCAN);
 long int countRecords(FILE *fBackup,uint32 *SCAN,int size);

  fBackup=fopen((char *)strcat(path,"backup.ds"),"rb");
  path[strlen(path)-9]='\0';
  if (fBackup == NULL) return(-200);

/* Find ENTRY.NDS portion of BACKUP.DS */
  err=findFirstEntryRecord(fBackup,&SCAN);
  if(err==FALSE)
  {
    fclose(fBackup);
    return(-301);
  }

/* The next offset to be read in should be the number of
   ENTRY.NDS records */
/* Get ENTRY.NDS */
  j=countRecords(fBackup,&SCAN,size_entry);
  calc=ldiv(j,4);
  if (calc.rem!=0) SCAN += 2;
  err=makeNDS(fBackup,j,(char *)strcat(path,"ENTRY.NDS"),typeEntry);
  path[strlen(path)-9]='\0';
  if (err) return(err);

/* Get VALUE.NDS */
  j=countRecords(fBackup,&SCAN,size_value);
  err=makeNDS(fBackup,j,(char *)strcat(path,"VALUE.NDS"),typeValue);
  path[strlen(path)-9]='\0';
  if (err) return(err);

/* Get BLOCK.NDS */
  j=countRecords(fBackup,&SCAN,size_block);
  err=makeNDS(fBackup,j,(char *)strcat(path,"BLOCK.NDS"),typeBlock);
  path[strlen(path)-9]='\0';
  if (err) return(err);

/* Get PARTITIO.NDS */
  j=countRecords(fBackup,&SCAN,size_partitio);
  err=makeNDS(fBackup,j,(char *)strcat(path,"PARTITIO.NDS"),typePartitio);
  path[strlen(path)-9]='\0';
  if (err) return(err);

  fclose(fBackup);
}
/******************End of conversion routine***********/
/******************************************************/

/*******Internal I/O Functions *********/
uint32 str_to_uint32(uint8 *in)
{uint8 Info[11];
 int i;
 Info[0]='0';Info[1]='x';Info[10]='\0';
 for (i=2;i<10;i++) Info[i]=in[i-2];
 return(strtoul(Info,(char **)NULL,16));
}

void uint32_to_str(uint32 in, uint8 *out)
{uint8 Info[9];
 int i;
 sprintf(Info,"%08lx",in);
 for (i=0;i<8;i++) out[i]=Info[i];
}

void pPassHack_to_record(Pan_PassHack *pPassHack,PASSHACK *record)
{short i;

 uint32_to_str(pPassHack->bind,record->bind);
 uint32_to_str(pPassHack->id,record->id);
 uint32_to_str(pPassHack->parentID,record->parentID);
 uint32_to_str(pPassHack->objectID,record->objectID);
 uint32_to_str(pPassHack->pwlen,record->pwlen);
 for(i=0;i<(pPassHack->pwlen);i++)
  {record->pw_first[i]=pPassHack->pw_first[i];
   record->pw_current[i]=pPassHack->pw_current[i];
  }
 for(i=pPassHack->pwlen;i<128;i++)
  {record->pw_first[i]=NULL;
   record->pw_current[i]=NULL;
  }
 record->pw_last[0]=pPassHack->pw_last;
 for (i=1;i<4;i++) record->pw_last[i]=NULL;
 for(i=0;i<16;i++) record->hash[i]=pPassHack->hash[i];
 for(i=0;i<40;i++) record->userOU[i]=pPassHack->userOU[i];
 for(i=0;i<258;i++) record->userCN[i]=pPassHack->userCN[i];
}

void record_to_pPassHack(PASSHACK *record,Pan_PassHack *pPassHack)
{int i;

 pPassHack->bind=str_to_uint32(record->bind);
 pPassHack->id=str_to_uint32(record->id);
 pPassHack->parentID=str_to_uint32(record->parentID);
 pPassHack->objectID=str_to_uint32(record->objectID);
 pPassHack->pwlen=str_to_uint32(record->pwlen);
 for(i=0;i<128;i++)
  {pPassHack->pw_first[i]=record->pw_first[i];
   pPassHack->pw_current[i]=record->pw_current[i];
  }
 pPassHack->pw_last=record->pw_last[0];
 for(i=0;i<16;i++) pPassHack->hash[i]=record->hash[i];
 for(i=0;i<40;i++) pPassHack->userOU[i]=record->userOU[i];
 for(i=0;i<258;i++) pPassHack->userCN[i]=record->userCN[i];
}

void pPassList_to_record(Pan_PassList pPassList,PASSLIST *record)
{int i;

 uint32_to_str(pPassList->bind,record->bind);
 uint32_to_str(pPassList->id,record->id);
 uint32_to_str(pPassList->parentID,record->parentID);
 uint32_to_str(pPassList->objectID,record->objectID);
 uint32_to_str(pPassList->pwlen_known,record->pwlen_known);
 if (pPassList->pwlen_known) uint32_to_str(pPassList->pwlen,record->pwlen);
 else for (i=0;i<8;i++) record->pwlen[i]='0';
 uint32_to_str(pPassList->pwhash_known,record->pwhash_known);
 if (pPassList->pwhash_known)
  for(i=0;i<16;i++) record->hash[i]=pPassList->hash[i];
 else for(i=0;i<16;i++) record->hash[i]=NULL;
 for(i=0;i<40;i++) record->userOU[i]=pPassList->userOU[i];
 for(i=0;i<258;i++) record->userCN[i]=pPassList->userCN[i];
}

void record_to_pPassList(PASSLIST *record,Pan_PassList pPassList)
{int i;

 pPassList->bind=str_to_uint32(record->bind);
 pPassList->id=str_to_uint32(record->id);
 pPassList->parentID=str_to_uint32(record->parentID);
 pPassList->objectID=str_to_uint32(record->objectID);
 pPassList->pwlen_known=str_to_uint32(record->pwlen_known);
 pPassList->pwlen=str_to_uint32(record->pwlen);
 pPassList->pwhash_known=str_to_uint32(record->pwhash_known);
 for(i=0;i<16;i++) pPassList->hash[i]=record->hash[i];
 for(i=0;i<40;i++) pPassList->userOU[i]=record->userOU[i];
 for(i=0;i<258;i++) pPassList->userCN[i]=record->userCN[i];
}
/*************End of internal I/O routine***********/
/*************End of lower level functions**********/

#ifdef __cplusplus
}
#endif

#endif /* PAN_FILE_MED */
