#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "..\pandora\pan_file.h"
#include "..\pandora\pan_hash.h"

/*
 * Print some usage info....
 */
void printHelp(int j)
{
   printf("USAGE: manipul8 <seed> <option>\n\n");
   printf("  seed is password attempt to insert into RESTORE.PAN file.\n");
   printf("  seed is password used to generate test hash with -t option.\n");
   printf("  -h           prints this HELP file.\n");
   printf("  -u <account> create a RESTORE.PAN file for USER using seed\n");
   printf("  -t <account> display the hash for USER using seed as a password\n");
   printf("  -v           VIEW the contents of a PASSWORD.NDS file\n\n");
   printf("EXAMPLES:\n");
   printf("  manipul8 -h  display help\n");
   printf("  manipul8 -v  display content of PASSWORD.NDS file\n");
   printf("  manipul8 TESTSEED  seed the actuall RESTORE.PAN\n");
   printf("  manipul8 TESTSEED -t  Display real hash and TESTSEED hash\n");
   printf("  manipul8 TESTSEED -u  Admin  create a RESTORE.PAN with seed\n\n");
   exit(j);
}

/*
 * Main prog...
 */

int main(int argc, char *argv[])
{
   char *newTry;
   int i,err,t,k,x,choice=0,FOUND,view=FALSE;
   char *c,*account;
   long int j;
   Pan_PassList pPassList,q;
   Pan_PassHack pPassHack;
   uint32 m;

   account=(char *)calloc(1,sizeof(char)*MAX_CHARS);
   newTry=(char *)calloc(1,sizeof(char)*MAX_CHARS);

/* Say hello... */
   printf("MANIPUL8 - seeding of RESTORE.PAN file plus PASSWORD.NDS viewing\n");
   printf("Comments/bugs: pandora@nmrc.org\n");
   printf("http://www.nmrc.org/pandora\n");
   printf("1997,1998 (c) Nomad Mobile Research Centre\n\n");

   if (argc<2) printHelp(1);

   /* process command line switches, if any... */
   for (i=1 ; i<argc ; i++)
   {
      if (argv[i][0]=='-')
	 switch(argv[i][1])
	 {
	    case 'h':
	    case 'H':
            case '?':
	       printHelp(0);
	    case 'u':
	    case 'U':
               if ((i+1>argc) || argv[i+1]==NULL)
	       {
		  printf("No argument given for option -u\n");
		  printHelp(-1);
	       }
               if (argv[i+1][0]=='-')
               {
                  printf("No argument given for option -u\n");
                  printHelp(-1);
               }
               sprintf(account,"%s",argv[i+1]);
               choice=1;
	       break;
	    case 't':
	    case 'T':
               if ((i+1>argc) || argv[i+1]==NULL)
	       {
		  printf("No argument given for option -u\n");
		  printHelp(-1);
	       }
               if (argv[i+1][0]=='-')
               {
                  printf("No argument given for option -u\n");
                  printHelp(-1);
               }
               sprintf(account,"%s",argv[i+1]);
               choice=2;
	       break;
	    case 'v':
	    case 'V':
	       view=TRUE; break;
	    default:
	       printf("Invalid option: %s\n", argv[i]);
	       printHelp(-1);
	 }
   }

 sprintf(newTry, "%s", argv[1]);

 /* if viewing the PASSWORD.NDS file, dump 'em all... */
 if(view==TRUE)
  {
   err=Pan_PassList_read("PASSWORD.NDS",&pPassList);
   if (err) {
             printf("err : %d",err);
             exit(-1);
            }
   for (q=pPassList;q!=NULL;q=q->next)
    {
     printUnicodeName(q->userCN,258);
     printf(" ");
     printUnicodeName(q->userOU,40);
     printf(" %04lx",q->bind);
     if(q->pwlen_known)
      printf(" %08lx %d ",q->objectID,q->pwlen);
     else printf(" * ");
     if(q->pwhash_known)
      for (i=0;i<16;i++) printf("%02x",q->hash[i]);
     else printf(" * ");
     printf("\n");
    }
  }
 else
  {
   for (i=0;i<strlen(newTry);i++)
   newTry[i]=toupper(newTry[i]); /* convert lower case letters
                                    to upper case letters */
   if (choice==1 || choice==2)
    {
     err=Pan_PassList_read("PASSWORD.NDS",&pPassList);
     if (err) {printf("err : %d",err);
               exit(-1);
              }
     for (q=pPassList;q!=NULL;q=q->next)
      {FOUND=TRUE;
       for (i=0;i<strlen(account);i++)
        {t=i*2+6;
         if (account[i]!=q->userCN[t]) FOUND=FALSE;
        }
       if (FOUND==TRUE) break;
      }
     if (!q)
      {printf("%s not found in password file.\n",account);
       Pan_PassList_free(pPassList);
       exit(1);
      }
     Pan_PassList_to_PassHack(q,&pPassHack);
     Pan_PassList_free(pPassList);
     if(pPassHack.pwlen!=strlen(newTry))
      {printf("seed must be %d characters in length.\n",pPassHack.pwlen);
       exit(1);
      }
     if (choice==1)
      {
       for(i=0;i<pPassHack.pwlen;i++) pPassHack.pw_first[i]=newTry[i];
       for(i=0;i<pPassHack.pwlen;i++) pPassHack.pw_current[i]=NULL;
       pPassHack.pw_last=NULL;
       err=Pan_PassHack_write("RESTORE.PAN",&pPassHack);
       if (err) {printf("err : %d",err);
                 exit(-1);
                }
       printf("Created a RESTORE.PAN file containing %s and:\n",newTry);
       printUnicodeName(pPassHack.userCN,258); printf(" ");
       printUnicodeName(pPassHack.userOU,40);
       printf(" id - %08lx parentID - %08lx objectID - %08lx\n pwlen - %d hash - ",
       pPassHack.id,pPassHack.parentID,pPassHack.objectID,pPassHack.pwlen);
       for (i=0;i<16;i++) printf("%02x",pPassHack.hash[i]); printf("\n");
      }
     if (choice==2)
      {
       for(i=0;i<pPassHack.pwlen;i++) pPassHack.pw_first[i]=newTry[i];
       pPassHack.pw_first[pPassHack.pwlen]='\0';

       printUnicodeName(pPassHack.userCN,258); printf(" ");
       printUnicodeName(pPassHack.userOU,40);
       printf(" id-%08lx parentID-%08lx objectID-%08lx pwlen-%d\n\n real hash   - ",
       pPassHack.id,pPassHack.parentID,pPassHack.objectID,pPassHack.pwlen);
       for (i=0;i<16;i++) printf("%02x",pPassHack.hash[i]);

       err=Pan_Hash_Gen(&pPassHack);
       if (err) {printf("err : %d",err);
                 exit(-1);
                }
       else {printf("\n result hash - ");
             for (i=0;i<16;i++) printf("%02x",pPassHack.hash[i]);
             printf("\n");
            }
      }
    }
   if (choice==0)
    {
     err=Pan_PassHack_read("RESTORE.PAN",&pPassHack);
     if (err) {
               printf("err : %d",err);
               exit(-1);
              }
     if(pPassHack.pwlen!=strlen(newTry))
      {
       printf("seed must be %d characters in length.\n",pPassHack.pwlen);
       exit(1);
      }
     printUnicodeName(pPassHack.userCN,258);
     printf(" ");
     printUnicodeName(pPassHack.userOU,40);
     printf(" id - %08lx parentID - %08lx objectID - %08lx\n pwlen - %d hash - ",
     pPassHack.id,pPassHack.parentID,pPassHack.objectID,pPassHack.pwlen);
      for (i=0;i<16;i++) printf("%02x",pPassHack.hash[i]);
     printf("\n");
     printf("First attempt %s ",pPassHack.pw_first);
     printf("Last attempt %s ",pPassHack.pw_current);
     printf("\nNew attempt - %s\n",newTry);
     for(i=0;i<pPassHack.pwlen;i++) pPassHack.pw_current[i]=newTry[i];
     err=Pan_PassHack_write("RESTORE.PAN",&pPassHack);
     if (err) {
               printf("err : %d",err);
               exit(-1);
              }
    }
  }
}
