/********************************************************************
 * lindner
 * 3.51
 * 1994/10/21 04:41:07
 * /home/mudhoney/GopherSrc/CVS/gopher+/gopher/CURcurses.c,v
 * Exp
 *
 * Paul Lindner, University of Minnesota CIS.
 *
 * Copyright 1991, 1992 by the Regents of the University of Minnesota
 * see the file "Copyright" in the distribution for conditions of use.
 *********************************************************************
 * MODULE: CURcurses.c
 * Abstraction of all Curses Functions
 *********************************************************************
 * Revision History:
 * CURcurses.c,v
 * Revision 3.51  1994/10/21  04:41:07  lindner
 * Add ANSI attached printer code..
 *
 * Revision 3.50  1994/06/29  07:06:59  lindner
 * moved gcatd to Locale.[ch] (Coopersmith)
 *
 * Revision 3.49  1994/06/29  05:11:07  lindner
 * None..
 *
 * Revision 3.48  1994/06/12  05:28:17  lindner
 * Fix for locales
 *
 * Revision 3.47  1994/06/09  22:13:35  lindner
 * More language conversions
 *
 * Revision 3.46  1994/05/24  05:49:54  lindner
 * Fix for bad free() in CURrequest()
 *
 * Revision 3.45  1994/04/25  20:43:29  lindner
 * Remove ugly pointer debug statement
 *
 * Revision 3.44  1994/04/25  03:49:41  lindner
 * Fixed ^_ mislabel of the ^- help command.
 *
 * Added prompt for RETURN in VMSExit(), to enable reading of ACCVIO tracebacks.
 *
 * Changed return values of DCLSystem() to be compatible with the
 * for-Unix code.
 *
 * Fixed spawns to work with OpenVMS/AXP v6.1 (still doesn't have the
 * TRUSTED flag).
 *
 * Revision 3.43  1994/04/25  03:37:35  lindner
 * Modifications for Debug() and mismatched NULL arguments, added Debugmsg
 *
 * Revision 3.42  1994/04/13  19:13:20  lindner
 * AskL modifications
 *
 * Revision 3.41  1994/04/01  02:24:41  lindner
 * Remove debugging stuff
 *
 * Revision 3.40  1994/03/31  21:26:43  lindner
 * Mitra's debug routine
 *
 * Revision 3.39  1994/03/08  15:55:02  lindner
 * gcc -Wall fixes
 *
 * Revision 3.38  1994/03/04  23:39:45  lindner
 * Fix for log entries
 *
 * Revision 3.37  1994/03/04  23:36:28  lindner
 * Many, many fixes and enhancements for Beckett and Co.
 *
 * Revision 3.36  1994/02/21  15:47:34  lindner
 * Remove conditional compilation for DEC ALPHAS trusted flag on VMS
 *
 * Revision 3.35  1994/02/20  21:45:18  lindner
 * Better sanity checks for box drawing characters
 *
 * Revision 3.34  1994/01/20  06:46:15  lindner
 * Fix boundary condition
 *
 * Revision 3.33  1994/01/14  16:40:04  lindner
 * Added VMSVersion() for getting the VMS version number, and modified
 * spawn_DCLprocess() so that it includes the TRUSTED flag for VAX v6+
 * and AXP v2+.  If DEC changes AXP v2.0 to v6.1 (I've heard rumors to
 * that affect), remove the __ALPHA conditional compilation in
 * spawn_DCLprocess() so it just checks for v6+.
 *
 * Revision 3.32  1993/12/28  17:29:09  lindner
 * Better method of drawing box characters
 *
 * Revision 3.31  1993/11/04  02:06:50  lindner
 * Add Ben's AIS hack
 *
 * Revision 3.30  1993/10/26  18:24:31  lindner
 * Make sure we cleanup before exiting
 *
 * Revision 3.29  1993/10/26  18:12:56  lindner
 * Fixes for Input routines, screen redrawing, ASK fixes
 *
 * Revision 3.28  1993/10/22  20:22:12  lindner
 * Range checks for lots of things
 *
 * Revision 3.27  1993/10/07  05:10:12  lindner
 * Make TrimmedTitle[] (twice) a larger array (256 elements).  Makes
 * 132-column terminals and huge xterm windows happier.
 *
 * In CURwgetch(), fix vt100 "Help" escape sequence.  Add vt100 "Enter",
 * vt200 "Help", and vt200 "Do" escape sequences.
 *
 * Revision 3.26  1993/09/30  22:41:57  lindner
 * Add option for bolding of searched words
 *
 * Revision 3.25  1993/09/29  22:47:17  lindner
 * Fix for AskBlock memory cruft
 *
 * Revision 3.24  1993/09/29  20:52:47  lindner
 * Add [space to cycle] prompt earlier
 *
 * Revision 3.23  1993/09/26  09:19:19  lindner
 * Add bold #defines
 *
 * Revision 3.22  1993/09/22  19:58:15  lindner
 * Fix for extra cruft on screen from Select/Choose
 *
 * Revision 3.21  1993/09/22  04:13:44  lindner
 * none
 *
 * Revision 3.20  1993/09/22  01:15:44  lindner
 * Add support for DEC HELP key/KEY_HELP
 *
 * Revision 3.19  1993/09/21  02:42:18  lindner
 * Exit on error reading from terminal (kills spinning processes)
 *
 * Revision 3.18  1993/09/21  01:46:06  lindner
 * Implement all remaining ASK block items..
 *
 * Revision 3.17  1993/09/11  06:31:33  lindner
 * spelling correction
 *
 * Revision 3.16  1993/09/11  04:51:00  lindner
 * Fix to skip labels in CURrequest()
 *
 * Revision 3.15  1993/09/03  03:28:59  lindner
 * Modified CURGetOneOption() to have a Title field.  Serveral other
 * routines modified for improved line editing and to show all available
 * commands while answering prompts.  If dialog box has only one prompt,
 * as for search query entries, start user entry on new line so more of
 * the screen is available for the entry (useful for search terms with
 * booleans).
 *
 * Revision 3.14  1993/08/19  20:22:45  lindner
 * Mitra's Debug patch
 *
 * Revision 3.13  1993/08/16  18:17:01  lindner
 * Fixes from F.Macrides:
 *
 * Added temporary code to work around DECC/AXP's problems with screen
 * clearing and cursor homing (we'll get rid of that code if the problem
 * goes away in the next version of DECC/AXP).  It's bolding via
 * standout() or wstandout(win) still doesn't work, but that's not a
 * serious functional problem for gopher users on Alphas.
 *
 * Added exit block to ensure that the terminal characteristics are
 * retored and cleanups are done on VMS.
 *
 * Added code for getting terminal characteristics
 * from the terminal table on VMS.
 *
 * Replaced/modified Cruft for VMS with routines which handle both
 * Control C and Control Y, enable use of ReallyQuit(), and restore all
 * original terminal characteristics for spawns and intentional or
 * unintentional exits.  Did it in a way that should stay transparent to
 * the otherwise "for-Unix" code, and should hold up with future mods or
 * enhancements of that code.  Standout() doesn't work at all and
 * endwin() and delwin() are unreliable on Alphas (due to bugs in the
 * Alpha's Curses library).  Andrew Heyler is looking into workarounds,
 * should DEC not fix the bugs soon.  Code compiles with DECC on Alphas
 * without warnings or error messages, but still get lots of
 * "informational" messages due to incomplete prototyping (no problems or
 * compiler messages with VAXC).
 *
 * Revision 3.12  1993/08/12  06:32:06  lindner
 * Add needed variable
 *
 * Revision 3.11  1993/08/09  20:44:48  lindner
 * Fix for really long strings
 *
 * Revision 3.10  1993/08/09  20:29:50  lindner
 * Get rid of the beep during a ^G in CURwgetstr().
 *
 * Make CURChoice() delete its window when it exits.
 *
 * Revision 3.9  1993/07/30  17:31:34  lindner
 * Mods to support AskP:
 *
 * Revision 3.8  1993/07/27  02:02:47  lindner
 * More comments
 *
 * Revision 3.7  1993/07/23  04:33:48  lindner
 * Mods to curchoice for default
 *
 * Revision 3.6  1993/07/20  23:10:17  lindner
 * none
 *
 * Revision 3.5  1993/04/15  21:23:36  lindner
 * Removed extraneous wattron/wattroff
 *
 * Revision 3.4  1993/03/26  19:42:32  lindner
 * Fix for skip by two problem in CURrequest
 *
 * Revision 3.3  1993/03/18  23:15:24  lindner
 * Mods to support titles inside of a CURrequest.
 *
 * Revision 3.2  1993/02/16  23:26:02  lindner
 * Fixes for SIG_ERR (for Crays)
 *
 * Revision 3.1.1.1  1993/02/11  18:02:56  lindner
 * Gopher+1.2beta release
 *
 * Revision 1.8  1993/01/11  20:25:31  lindner
 * Fixed weird wprintw error on EP/IX.
 *
 * Revision 1.8  1993/01/11  20:25:31  lindner
 * Fixed weird wprintw error on EP/IX.
 *
 * Revision 1.7  1993/01/09  02:16:21  lindner
 * Changed (void*)-1 constructs to SIG_ERR
 *
 * Revision 1.6  1993/01/09  01:28:11  lindner
 * Replaced hosed Log messages (Ooops!)
 *
 * Revision 1.5  1993/01/09  01:24:42  lindner
 * Added CURchoice(), let's you choose one option from [2-9] items.
 *
 * Revision 1.4  1993/01/09  00:49:16  lindner
 * More mods for VMS from jqj.  Looks like better ctrl-y and ctrl-c
 * processing.
 *
 * Revision 1.3  1993/01/06  17:05:46  lindner
 * Added nl() to CURexit() for EP/IX machines.
 *
 * Revision 1.2  1992/12/31  05:55:44  lindner
 * Mods for VMS
 *
 * Revision 1.1  1992/12/10  06:16:51  lindner
 * Initial revision
 *
 *
 *********************************************************************/

#include "CURcurses.h"
#include "Malloc.h"

#include <signal.h>
#ifndef SIG_ERR
#define SIG_ERR ((void *) -1)
#endif
#include "Stdlib.h"
#include "compatible.h"
#include "Debug.h"

#ifdef VMS
static int w_getch();
#undef wgetch
#define wgetch w_getch
void setterm_pas();
void resetterm();
void VMSCURinit(/* CursesObj* */);
void VMSinit();
int VMSVersion(/* char *, int */);
void VMSexit();
int spawn_DCLprocess();
int DCLspawn_exception();
#endif /* VMS */
 

/*
 * Initialize data space for various screen information
 */

CursesObj *
CURnew()
{
     CursesObj *cur;

     cur = (CursesObj *) malloc(sizeof(CursesObj));

     cur->Screen       = NULL;
     cur->Termtype     = STRnew();
     cur->Clearscreen  = STRnew();
     cur->AudibleBell  = STRnew();
     cur->Highlighton  = STRnew();
     cur->Highlightoff = STRnew();

     cur->canUseACS    = FALSE;
     cur->inCurses     = FALSE;
     cur->sigtstp      = SIG_ERR;
     cur->sigwinch     = SIG_ERR;

     CURinit(cur);
     
     return(cur);

}


/*
 * Initialize various strings and such. 
 */

void
CURinit(cur)
  CursesObj *cur;
{
#ifdef VMS
     VMSCURinit(cur);
#else
     int err;
     static char terminal[1024];
     static char capabilities[1024];   /* String for cursor motion */
     static char *ptr = capabilities;  /* for buffering         */
     char *cp;


     /*** Set the terminal type ***/
     if (getenv("TERM") != NULL)
	  CURsetTerm(cur, getenv("TERM"));
     else 
	  CURsetTerm(cur, "unknown");

     err = tgetent(terminal, CURgetTerm(cur));
     
     if (err !=1)
	  CURsetTerm(cur, "unknown");

     /*** Get the clearscreen code ***/
     if ((cp = (char *)tgetstr("cl", &ptr)) != NULL)
	  CURsetCLS(cur, cp);
     else
	  CURsetCLS(cur, "");

     /*** Set the bell ***/
     if ((cp = (char *) tgetstr("bl", &ptr)) != NULL)
	  CURsetBell(cur, cp);
     else
	  CURsetBell(cur, "\007");

     /*** Set the highlight codes ***/
     if ((cp = (char *) tgetstr("so", &ptr)) != NULL) {
	  CURsetHighon(cur, cp);
	  if ((cp = (char *) tgetstr("se", &ptr)) != NULL)
	       CURsetHighoff(cur, cp);
     } else {
	  CURsetHighon(cur, "");
	  CURsetHighoff(cur, "");
     }

     /*** Does terminal support alternate character set? ***/
     if ((char *) tgetstr("as", &ptr) != NULL) 
	  cur->canUseACS = TRUE;

     CURsetScreen(cur,initscr());
#endif
     cur->inCurses = FALSE;

     CURsetGraphicsChars(cur, CURgetTerm(cur));
}

/*
 * Set the characters to output depending on the terminal type...
 * 
 * Most systems don't do it right..
 */

static char *CURgraphicChars[] = {
     "vtxxx",  "qxlkmjwvtun",
     "xterm",  "qxlkmjwvtun",
     "z29",    "aqfcedsuvtb",
     "wyse50", "zvrsqupwtyx",
     "isc",    "D3Z?@Y+++++",
     "sun-cmd","-|+++++++++",
     NULL,     NULL
};

void
CURsetGraphicsChars(cur, termtype)
  CursesObj *cur;
  char *termtype;
{
     cur->Box_hline  = '-';
     cur->Box_vline  = '|';
     cur->Box_ul     = '+';
     cur->Box_ur     = '+';
     cur->Box_ll     = '+';
     cur->Box_lr     = '+';
     cur->Box_tt     = '+';
     cur->Box_bt     = '+';
     cur->Box_lt     = '+';
     cur->Box_rt     = '+';
     cur->Box_ct     = '+';

#if defined(A_ALTCHARSET) && !defined(ultrix) && !defined(__osf__)
     /** use ALTCHARSET if termcap or terminfo knows how **/
     if (cur->canUseACS) {

	  char *term, *chars;
	  char termname[20];
	  int count=0;

	  strcpy(termname, termtype);

	  /** VT100 terminals and above support alternate character set **/
	  if (strncasecmp(termname, "vt1", 3) == 0 ||
	      strncasecmp(termname, "vt2", 3) == 0 ||
	      strncasecmp(termname, "vt3", 3) == 0)
	       strcpy(termname, "vtxxx");  /* name in CURgraphicChars[] */

	  while ((term = CURgraphicChars[count++]) != NULL) {
	       chars = CURgraphicChars[count++];
	       if (strcmp(termname, term) == 0) {
		    cur->Box_hline  = A_ALTCHARSET|chars[0];
		    cur->Box_vline  = A_ALTCHARSET|chars[1];
		    cur->Box_ul     = A_ALTCHARSET|chars[2];
		    cur->Box_ur     = A_ALTCHARSET|chars[3];
		    cur->Box_ll     = A_ALTCHARSET|chars[4];
		    cur->Box_lr     = A_ALTCHARSET|chars[5];
		    cur->Box_tt     = A_ALTCHARSET|chars[6];
		    cur->Box_bt     = A_ALTCHARSET|chars[7];
		    cur->Box_lt     = A_ALTCHARSET|chars[8];
		    cur->Box_rt     = A_ALTCHARSET|chars[9];
		    cur->Box_ct     = A_ALTCHARSET|chars[10];
	       }
	  }
     }
#endif
}



/* 
 * Given a properly "CURnew" cursesobj, initialize the screen..
 */

void
CURenter(cur)
  CursesObj *cur;
{
     /* for safety */
     if (cur->inCurses == TRUE)
	  return;

#ifdef VMS
     (void)setterm_pas();
     CURsetScreen(cur,initscr());
#else
     tputs(CURgetCLS(cur),1,CURoutchar);
     fflush(stdout); 
#endif

     cur->inCurses = TRUE;

     CURwenter(cur,stdscr);

#ifdef SIGWINCH
     if (cur->sigwinch != SIG_ERR)
	  signal(SIGWINCH, cur->sigwinch);
#endif
#ifndef VMS
     if (cur->sigtstp != SIG_ERR)
	  signal(SIGTSTP, cur->sigtstp);
#endif
}

/*
 * Set up processing for the window (especially for system V curses!
 */

void
CURwenter(cur, win)
  CursesObj *cur;
  WINDOW *win;
{
     cbreak();
     noecho();
     nonl();
#ifdef SYSVCURSES
     intrflush(win, FALSE);
     nodelay(win, FALSE);
#ifndef ultrix			/** Causes wgetch to dump core in ultrix **/
#ifndef _SEQUENT_     
     keypad(win, TRUE);
#endif
#endif
#endif
}     
/*
 * Exit curses system.
 */

void
CURexit(cur)
  CursesObj *cur;
{
     
     if (!cur->inCurses)
	return;
     cur->inCurses = FALSE;
     echo();
     nl();
     endwin();

#ifdef SYSVCURSES
#ifndef  _SEQUENT_
     keypad(stdscr, FALSE);
#endif
#endif

#ifdef VMS
     (void)resetterm();
#else
     tputs(CURgetCLS(cur),1,CURoutchar);
     fflush(stdout);
 
     cur->sigtstp = signal(SIGTSTP, SIG_DFL);
#endif

#ifdef SIGWINCH
     cur->sigwinch = signal(SIGWINCH, SIG_DFL);
#endif

}



/*
 * send a character to stdout, not really curses, but we do use it...
 */

int
CURoutchar(c)
  char c;
{
     /** output the given character.  From tputs... **/
     /** Note: this CANNOT be a macro!              **/
     
     putc(c, stdout);
     return(c);
}


/*
 * Centerline, uses curses routines to center a line.
 */
void CURcenterline(cur, win, theline, yval, windowidth, bright)
  CursesObj *cur;
  WINDOW    *win;
  char      *theline;
  int       yval, windowidth;
  boolean   bright;
{
     char TrimmedLine[256];

     strcpy(TrimmedLine, theline);

     /** Make sure theline fits in the window **/
     if (strlen(theline) > windowidth) {
	  TrimmedLine[windowidth-3] = '.';
	  TrimmedLine[windowidth-2] = '.';
	  TrimmedLine[windowidth-1] = '.';
	  TrimmedLine[windowidth] = '\0';
     }

     wmove(win, yval, (windowidth - strlen(TrimmedLine))/2);

     if (bright)
	  wstandout(win);

     waddstr(win, TrimmedLine);

     if (bright)
	  wstandend(win);
}


/*
 * CURwgetstr is a replacement of getstr that allows editing of the string
 * if the user types control codes we don't recognize, it's returned instead
 * We assume that the incoming string is shorter than the max..
 */


int
CURwgetstr(cur, win, inputline, maxlength, hidden)
  CursesObj *cur;
  WINDOW    *win;
  char      *inputline;
  int       maxlength;
  boolean   hidden;
{
     int pointer = 0;
     int curpointer = 0;
     int ch;
     int y,x;

     wstandout(win);

     /*** Check to see if there's something in the inputline already ***/
     while (inputline[pointer] != '\0') {
	  if (hidden)
	       waddch(win, '*');
	  else
	       waddch(win, inputline[pointer]);
	  pointer ++;
	  curpointer ++;
     }

     wrefresh(win);

     for (;;) {
	  ch = CURwgetch(cur,win);

	  switch (ch) {

	  case '\n':
	       inputline[pointer] = '\0';
	       wstandend(win);
	       return(ch);
	       break;

	  case '\b':  /*** backspace and delete ***/
	       if (curpointer > 0) {
		    char *cp;

		    getyx(win, y, x);
		    wmove(win, y, x-1);
		    
		    /* Update the string */

		    for (cp = inputline + curpointer - 1; *cp != '\0'; cp++) {
			 *cp = *(cp + sizeof(char));
			 if (*cp != '\0') {
			      if (hidden)
				   waddch(win, '*');
			      else
				   waddch(win, *cp);
			 }
		    }
		    *cp = '\0';
		    waddch(win, ' ');

		    pointer--;
		    curpointer--;

		    wmove(win, y, x-1);
		    wrefresh(win);
	       }
	       break;

	  case '\001':  /*** ^A go to beginning of line ***/
	       getyx(win, y, x);
	       wmove(win, y, x-curpointer);
	       curpointer = 0;
	       wrefresh(win);
	       break;

	  case '\005':  /*** ^E go to end of line ***/
	       getyx(win, y, x);
	       wmove(win, y, x+pointer-curpointer);
	       curpointer = pointer;
	       wrefresh(win);
	       break;

	  case '\007':  /*** ^G cancel... ***/
	       wstandend(win);
	       return(-1);
	       break;
       
	  case '\013':  /*** ^K delete to end of line ***/
	       getyx(win, y, x);

	       while (curpointer < pointer) {
		    waddch(win, ' ');
		    pointer--;
	       }
	       inputline[pointer] = '\0';
	       wmove(win, y, x);
	       wrefresh(win);
	       break;

	  case '\025':  /*** ^U erase whole line ***/
	       getyx(win, y, x);
	       wmove(win, y, x-curpointer);

	       while (pointer > 0) {
		    waddch(win, ' ');
		    pointer--;
	       }
	       inputline[pointer] = '\0';
	       wmove(win, y, x-curpointer);
	       curpointer = 0;
	       wrefresh(win);
	       break;

	  case KEY_LEFT:
	       if (curpointer > 0) {
		    curpointer--;
		    getyx(win, y, x);
		    wmove(win, y, x-1);
		    wrefresh(win);
	       }
	       break;

	  case KEY_RIGHT:
	       if (curpointer < pointer) {
		    curpointer++;
		    getyx(win, y, x);
		    wmove(win, y, x+1);
		    wrefresh(win);
	       }
	       break;

	  default:
	       if (ch < 256 && isprint(ch) && curpointer == maxlength) {
		    CURBeep(cur);
	       }
	       else if (ch < 256 && isprint(ch)) {

		    inputline[curpointer++] = ch;

		    if (curpointer > pointer) {
			 pointer = curpointer;
			 inputline[curpointer+1] = '\0';
		    }
		    if (hidden)
			 waddch(win, '*');
		    else
			 waddch(win, ch);
		    wrefresh(win);
	       }
	       else {
		    wstandend(win);
		    return(ch);
	       }
	  } /* switch */
     } /* for */
}


/*
 * This stuff is stolen and modified from hytelnet  Thanks Earl!
 */

int
CURwgetch(cur, window)
  CursesObj *cur;
  WINDOW *window;
{
     int a, b, c;
     
     while (1) {

	  c = wgetch(window);

	  switch (c) {

	  case -1:  /* error usually means connection was closed.. */
	       CleanupandExit(-1);
	       break;

	  case 12:  /* ^L */
	  case 18:  /* ^R */
	  case 23:  /* ^W */
	       /* redraw the screen */
#ifdef VMS
	       clearok(curscr, TRUE);
	       wrefresh(window);
#else
	       wrefresh(curscr);
#endif
	       /* don't return yet, get another keystroke */
	       break;

	  case 27:  /* handle escape sequence */
	       b = wgetch(window);
	       if (b == '[' || b == 'O')
		    a = wgetch(window);
	       else
		    a = b;

	       switch (a) {
	       case 'A': c = KEY_UP; break;
	       case 'B': c = KEY_DOWN; break;
	       case 'C': c = KEY_RIGHT; break;
	       case 'D': c = KEY_LEFT; break;

	       case 'M':                   /* vt100 enter */
		    if (b == 'O')
			c = KEY_ENTER;
		    break;

	       case 'Q':                   /* vt100 Help */
		    if (b == 'O')
			c = KEY_HELP;
		    break;

	       case '2':
		    if (b == '[')
			b = wgetch(window);
		    switch(b) {
		    case '8':             /* vt200 Help */
			if (wgetch(window) == '~')
			    c = KEY_HELP;
			break;
		    case '9':             /* vt200 Do */
			if (wgetch(window) == '~')
			    c = KEY_ENTER;
			break;
		    }
	       
	       case '5':                       /* vt 200 prev. screen */
		    if (b == '[' && wgetch(window) == '~')
			c = KEY_PPAGE;
		    break;
	       case '6':                       /* vt 200 next screen */
		    if (b == '[' && wgetch(window) == '~')
			c = KEY_NPAGE;
		    break;
	       }
	       /* fall through to default to reassign certain keys */

	  default:
	  /* The many forms of the return key... */
	  if ((c == KEY_ENTER)|| (c=='\r')) 
	       c = '\n'; /** SYSV curses Gack! **/

	  /* The many forms of backspace */
	  if (c == '\010' || c == '\177' || c == KEY_BACKSPACE)
	       return('\b');

	  return(c);
	  break;

	  }  /* switch(c) */
     }  /* while(1) */
}

int
CURgetch(cur)
  CursesObj *cur;
{
   return(CURwgetch(cur, stdscr));
}  

/*
 * Resets the screen when a size change has happened
 */

void
CURresize(cur)
  CursesObj *cur;
{
     if (cur->inCurses) {
	  CURexit(cur);
#ifdef VMS
	  CURsetScreen(cur, initscr());
#endif
	  CURenter(cur);
     }
}

/*
 * Get one option displays a message, and gets a response
 *
 * If the Response has something in it, it is displayed and editable
 * 
 * If the user wants to abort, GetOneOption returns a -1, otherwise it
 * returns a 0
 */

int
CURGetOneOption(cur, Title, OptionName, Response)
  CursesObj *cur;
  char *Title, *OptionName, *Response;
{
     int i;
     Requestitem *items[2], item;

     items[0] = &item;
     items[1] = NULL;

     item.prompt = OptionName;
     item.stowage = Response;
     item.thing = CUR_PROMPT;

     i = CURrequester(cur, Title, items);
     
     refresh();
     return(i);
}

/*
 * This is the old version of GetOneOption, for those times when the
 * garsh darn terminal is just too gadblam slow :-)
 */
int
CUROldGetOneOption(cur, OptionName, Response)
  CursesObj *cur;
  char *OptionName, *Response;
{
     int i;
     
     mvaddstr(LINES-1, 0, OptionName);
     standout();
     addstr("    ");
     standend();
     clrtoeol();
     move(LINES-1, strlen(OptionName));
     
     refresh();
     i = CURwgetstr(cur, stdscr, Response, 4, FALSE);
     
     return(i);
}



/*
 * Fills in the Response with either a lowercase 'y' or 'n'
 */

void
CURgetYesorNo(cur, OptionName, Response)
  CursesObj *cur;
  char *OptionName, *Response;
{
     int c;
     int posx, posy;

     mvaddstr(LINES-1, 0, OptionName);
     clrtoeol();
     getyx(cur->Screen, posy, posx);
     addch(' ');

     if (*Response == 'y')
	  mvaddstr(posy, posx+1, "y");
     else {
	  *Response = 'n';
	  mvaddstr(posy, posx+1, "n ");
     }
     move(posy, posx+1);

     refresh();

     while (1) {
	  c = CURgetch(cur);

	  if (c == 'y') {
	       mvaddstr(posy, posx+1, Gtxt("Yes",180));
	       move(posy, posx+1);
	       refresh();
	       *Response = 'y';
	       *(Response +1) = '\0';
	       return;
	  }
	  else if (c == 'n') {
	       mvaddstr(posy, posx+1, Gtxt("No ",111));
	       move(posy, posx+1);
	       refresh();
	       *Response = 'n';
	       *(Response +1) = '\0';
	       return;
	  }
	  
	  else if ((c == '\n')||(c=='\r')) {
	       return;
	  }
#ifdef VMS
	  else if ( c == '\032' ) {	/* control-Z */
		return;
	  }
#endif
	  else {
	       Debugmsg("CURgetYesorNo beep\r\n")
	       CURBeep(cur);
	  }
     }
}
	  
void 
CURBeep(cur)
  CursesObj *cur;
{
	Debugmsg("CURBeep\r\n")
#ifdef SYSVCURSES
     beep();
#else
/*   CURcenterline(cur, stdscr, CURgetBell(cur), 1, COLS, FALSE); */
     tputs(CURgetBell(cur), 1, CURoutchar);
     fflush(stdout);
#endif
}


void
CURbox(cur, win, height, width)
  CursesObj *cur;
  WINDOW *win;
  int width, height;
{
     int i;

     wmove(win, 0, 0);
     waddch(win, CURgetBox_ul(cur));
     for (i=0; i<width-2; i++)
	  waddch(win, CURgetBox_hline(cur));
     waddch(win, CURgetBox_ur(cur));

     for (i=1; i<height-1; i++) {
	  wmove(win, i, 0);
	  waddch(win, CURgetBox_vline(cur));
	  wmove(win, i, width-1);
	  waddch(win, CURgetBox_vline(cur));
     }

     wmove(win, height-1, 0);
     waddch(win, CURgetBox_ll(cur));
     for (i=0; i<width-2; i++)
	  waddch(win, CURgetBox_hline(cur));
     waddch(win, CURgetBox_lr(cur));
}


void
CURbutton(cur, win, Label, bright)
  CursesObj *cur;
  WINDOW *win;
  char *Label;
  boolean bright;
{
/*     wboldout(win);*/

     if (bright)
	  wstandout(win);

     waddstr(win, "[");
     waddstr(win, Label);
     waddstr(win, "]");

     if (bright)
	  wstandend(win);

/*     wboldend(win);*/
}     



int
CURDialog(cur, Wintitle, Message)
  CursesObj *cur;
  char **Message;
  char *Wintitle;
{
     int i;
     int messheight=0;
     int messlength=0;
     WINDOW *tempwin;
     int winwidth;

     while (Message[messheight] != NULL) {
	  if (strlen(Message[messheight]) > messlength)
	      messlength = strlen(Message[messheight]);
	  messheight++;
     }

     winwidth = max(31, messlength+6);
     winwidth = max(winwidth, strlen(Wintitle)+6);
     winwidth = min(winwidth, COLS-2);

     tempwin = newwin(5+messheight, winwidth, (LINES-(5+messheight))/2,
     			(COLS-winwidth)/2);
     CURwenter(cur,tempwin);
     CURbox(cur, tempwin, 5+messheight, winwidth);

     /** Add the message **/
     for (i=0; i<messheight; i++) {
	  int len = strlen(Message[i]), j;

          wmove(tempwin, 2+i,(winwidth - messlength)/2);

	  if (len > messlength) {
	       for (j=0; j < messlength; j++)
		    waddch(tempwin, Message[i][j]);
	  }
	  else
	       waddstr(tempwin, Message[i]);

     }



     /** Add the window title, centered **/
     if (Wintitle != NULL)
	  CURcenterline(cur, tempwin, Wintitle, 0, winwidth, TRUE);

     /** Add the keyboard labels **/
     wmove(tempwin, 3+messheight, winwidth - 28);
     CURbutton(cur, tempwin, Gtxt("Cancel: ^G",211), FALSE);
     waddch(tempwin, ' ');
     CURbutton(cur, tempwin, Gtxt("OK: Enter",191), FALSE);

     wrefresh(tempwin);

     switch(CURwgetch(cur, tempwin)) {
     case -1:
     case '\007':
	  delwin(tempwin);
	  return(-1);
     default:
	  delwin(tempwin);
	  return(0);
     }
}


int
CURRequest(cur,Wintitle,Prompts,Stowages)
  CursesObj *cur;
  char *Wintitle;
  char **Prompts;
  char **Stowages;
{
     Requestitem **items;
     int i, choice, numprompts = 0;

     while (Prompts[numprompts] != NULL)
	  numprompts++;

     items = (Requestitem **) malloc(sizeof(Requestitem *) * (numprompts+1));

     for (i = 0; i < numprompts; i++) {
	  items[i] = (Requestitem*) malloc(sizeof(Requestitem));
	  items[i]->prompt  = Prompts[i];
	  items[i]->stowage = Stowages[i];

	  if (Stowages[i] == NULL)
	       items[i]->thing = CUR_LABEL;
	  else
	       items[i]->thing = CUR_PROMPT;
     }
     items[i] = NULL;
     
     choice = CURrequester(cur, Wintitle, items);

     /** Free memory **/
     for (i=0; i <= numprompts; i++)
	  if (items[i])
	       free(items[i]);
     free(items);

     return(choice);
}

/* 
 * CURrequester takes an array of requestitems and does the right
 * things with it..  
 */

int
CURrequester(cur, Wintitle, items)
  CursesObj   *cur;
  char        *Wintitle;
  Requestitem **items;
{
     int         BottomField;
     int         ch;
     Requestitem *curitem;
     int         currentfield = 0;
     int         FieldsPerPage;
     boolean     Found;
     int         i,j,k;
     int         maxlength;
     int         maxpromptwidth = 0;
     int         numprompts = 0;
     WINDOW      *tempwin;
     int         TopField;
     int         WinLines;
     int         WinWidth = COLS - 1;
     static char **RequestHelp = NULL;
     

     if (RequestHelp == NULL) {
	  RequestHelp = (char**) malloc(sizeof(char*) * 8);
	  RequestHelp[0] = Gtxt("^G      : Cancel",190);
	  RequestHelp[1] = Gtxt("Tab, ^N : Move to next field",192);
	  RequestHelp[2] = Gtxt("^P      : Move to previous field",193);
	  RequestHelp[3] = Gtxt("^F      : Display next page",194);
	  RequestHelp[4] = Gtxt("^B      : Display previous page",195);
	  RequestHelp[5] = Gtxt("^-      : Help (^/ or ^7 may work)",196);
	  RequestHelp[6] = Gtxt("Enter   : Accept",197);
	  RequestHelp[7] = NULL;
     }

     /*** Find the number of prompts... and the max width ***/
     while ((curitem = items[numprompts++]) != NULL) {

	  /*** Skip non editable prompts ***/
	  if (curitem->thing != CUR_LABEL) {
	       if (strlen(curitem->prompt) > maxpromptwidth)
		    maxpromptwidth = strlen(curitem->prompt);
	  } else {
	       if (currentfield == numprompts-1)
		    currentfield++;
	  }
     }

     numprompts--;
     if (numprompts == 0)
	  return(-1);

     TopField = 0;     
     FieldsPerPage = min(numprompts, LINES - 5); 
     BottomField = min(TopField + FieldsPerPage, numprompts) - 1;

     /** If only one prompt, offer an entire line for input **/
     if (numprompts == 1 && items[0]->thing == CUR_PROMPT) {
          WinLines = 8;
          maxlength = WinWidth - 4;
     }
     else {
          WinLines = FieldsPerPage + 5;
          maxlength = WinWidth - maxpromptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window ***/
     tmptwidth - 6;
     }

     /*** Create the new window **                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              