// scenemen.cpp : handles all menu events
// written in June 1995
// Gerbert Orasche
// copyright: (c) 1994-95
// Institute For Information Processing And Computer Supported New Media (IICM)
// Graz University Of Technology


#include "stdafx.h"
#include "scenedoc.h"
#include <hgapp.h>
#include "mainfrm.h"
#include "scenevw.h"                                                                                                
#include "scene3d.h"
#include <ge3d/ge3d.h>

/////////////////////////////////////////////////////////////////////////////
// handling of menu events


void CSceneView::OnNavigationFly() 
{
  m_iNavigationMode=CSceneView::FLY;
  m_csStatText.LoadString(IDS_STR_HELP_FLY);
  ((CMainFrame*)AfxGetMainWnd())->m_wndStatusBar.SetPaneText(0,m_csStatText,TRUE);
  m_iPoiset=0;
  if(m_iDrawMode!=m_iInteractiveMode)
    GetDocument()->GetScene()->mode(m_iDrawMode);
  DoDraw(NONE,CPoint(0,0));  
}

void CSceneView::OnNavigationFlyto() 
{
  m_iNavigationMode=CSceneView::FLYTO;
  m_csStatText.LoadString(IDS_STR_HELP_FLYTO);
  ((CMainFrame*)AfxGetMainWnd())->m_wndStatusBar.SetPaneText(0,m_csStatText,TRUE);
  m_iPoiset=0;
  if(m_iDrawMode!=m_iInteractiveMode)
    GetDocument()->GetScene()->mode(m_iDrawMode);
  DoDraw(NONE,CPoint(0,0));  
}

void CSceneView::OnNavigationFlip() 
{
  m_iNavigationMode=CSceneView::FLIP;
  m_csStatText.LoadString(IDS_STR_HELP_FLIP);
  ((CMainFrame*)AfxGetMainWnd())->m_wndStatusBar.SetPaneText(0,m_csStatText,TRUE);
  m_iPoiset=0;
  if(m_iDrawMode!=m_iInteractiveMode)
    GetDocument()->GetScene()->mode(m_iDrawMode);
  DoDraw(NONE,CPoint(0,0));  
}

void CSceneView::OnNavigationWalk() 
{
  m_iNavigationMode=CSceneView::WALK;
  m_csStatText.LoadString(IDS_STR_HELP_WALK);
  ((CMainFrame*)AfxGetMainWnd())->m_wndStatusBar.SetPaneText(0,m_csStatText,TRUE);
  m_iPoiset=0;
  if(m_iDrawMode!=m_iInteractiveMode)
    GetDocument()->GetScene()->mode(m_iDrawMode);
  DoDraw(NONE,CPoint(0,0));  
}

void CSceneView::OnNavigationHeadsup() 
{
  m_iNavigationMode=CSceneView::HEADSUP;
  m_csStatText.LoadString(IDS_STR_HELP_HEADUP);
  ((CMainFrame*)AfxGetMainWnd())->m_wndStatusBar.SetPaneText(0,m_csStatText,TRUE);
  m_iPoiset=0;
  if(m_iDrawMode!=m_iInteractiveMode)
    GetDocument()->GetScene()->mode(m_iDrawMode);
  DoDraw(NONE,CPoint(0,0));  
}

// 17.3.95
// resets the camera
void CSceneView::OnViewReset() 
{
  CSceneDoc* pDoc = GetDocument();

  pDoc->GetScene()->restoreCamera();
  // if we draw last scene with interactive mode reset...
  if(m_iDrawMode!=m_iInteractiveMode)
    GetDocument()->GetScene()->mode(m_iDrawMode);
  DoDraw(CSceneView::NONE,CPoint(0,0));
  m_fktran=0.0F;
  m_fkrot=0.0F;
  m_iPoiset=0;
  if(m_iNavigationMode!=FLY)
    m_bFlying=FALSE;
}

void CSceneView::OnUpdateNavigationKeepturning(CCmdUI* pCmdUI) 
{
  if(m_bKeep)
  {
    // uncheck menu item
    pCmdUI->SetCheck(TRUE);
  }
  else
  {
    // check menu item
    pCmdUI->SetCheck(FALSE);
  }
}

void CSceneView::OnNavigationKeepturning() 
{
  if(m_bKeep)
  {
    m_bKeep=FALSE;
  }
  else
  {
    m_bKeep=TRUE;
  }
}

void CSceneView::OnNavigationInteractiveFlatshading() 
{
  m_iInteractiveMode=ge3d_flat_shading;
}

void CSceneView::OnNavigationInteractiveHiddenline() 
{
  m_iInteractiveMode=ge3d_hidden_line;
}

void CSceneView::OnNavigationInteractiveSmoothshading() 
{
  m_iInteractiveMode=ge3d_smooth_shading;
}

void CSceneView::OnNavigationInteractiveWireframe() 
{
  m_iInteractiveMode=ge3d_wireframe;
}

void CSceneView::OnUpdateNavigationInteractiveFlatshading(CCmdUI* pCmdUI) 
{
  //
}

void CSceneView::OnUpdateNavigationInteractiveHiddenline(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	
}

void CSceneView::OnUpdateNavigationInteractiveSmoothshading(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	
}

void CSceneView::OnUpdateNavigationInteractiveWireframe(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	
}

// sets the drawing mode for flatshading
void CSceneView::OnFlatshading() 
{
  m_iDrawMode=ge3d_flat_shading;
  m_iInteractiveMode=ge3d_flat_shading;
  GetDocument()->GetScene()->mode(m_iDrawMode);
  Invalidate();
}

// sets the drawing mode for hidden line
void CSceneView::OnHiddenline() 
{
  m_iDrawMode=ge3d_hidden_line;
  m_iInteractiveMode=ge3d_hidden_line;
  GetDocument()->GetScene()->mode(m_iDrawMode);
  Invalidate();
}

// sets the drawing mode for gouraud shading
void CSceneView::OnSmoothshading() 
{
  m_iDrawMode=ge3d_smooth_shading;
  m_iInteractiveMode=ge3d_smooth_shading;
  GetDocument()->GetScene()->mode(m_iDrawMode);
  Invalidate();
}

// sets the drawing mode for wireframe
void CSceneView::OnWireframe() 
{
  m_iDrawMode=ge3d_wireframe;
  m_iInteractiveMode=ge3d_wireframe;
  GetDocument()->GetScene()->mode(m_iDrawMode);
  Invalidate();
}
