// scenedoc.cpp : Document class for VRweb
// written in December 1994
// Gerbert Orasche
// copyright: (c) 1994-95
// Institute For Information Processing And Computer Supported New Media (IICM)
// Graz University Of Technology

#include "stdafx.h"
#include <ge3d/ge3d.h>
#include <hgapp.h>
#include "camera.h"

#include "scenedoc.h"
#include "scene3d.h"
#include "scenevw.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSceneDoc

IMPLEMENT_DYNCREATE(CSceneDoc, CDocument)

BEGIN_MESSAGE_MAP(CSceneDoc, CDocument)
	//{{AFX_MSG_MAP(CSceneDoc)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSceneDoc construction/destruction

CSceneDoc::CSceneDoc()
{
	// create scene class
  m_pScene=new Scene3D();
  //SetMode(m_iDrawMode);
}

CSceneDoc::~CSceneDoc()
{
  m_pScene->clear();
  delete(m_pScene);
}

/////////////////////////////////////////////////////////////////////////////
// CSceneDoc serialization

void CSceneDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: add storing code here
	}
	else
	{
		// TODO: add loading code here
	}
}

/////////////////////////////////////////////////////////////////////////////
// CSceneDoc diagnostics

#ifdef _DEBUG
void CSceneDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CSceneDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CSceneDoc commands


BOOL CSceneDoc::OnOpenDocument(LPCTSTR lpszPathName) 
{
	if (!CDocument::OnOpenDocument(lpszPathName))
		return(FALSE);
	
	// read scene file from disk!
  TRACE("reading scene from %s\n",lpszPathName);
	int iRet=m_pScene->readScene(lpszPathName);
  if(iRet)
  {
    AfxMessageBox("Error Reading Scene",MB_ICONSTOP|MB_OK);
    return(FALSE);
  }

  // save filename for saving
  strcpy(m_szFileName,lpszPathName);

	return(TRUE);
}

Scene3D* CSceneDoc::GetScene()
{
  return(m_pScene);
}

Camera* CSceneDoc::GetCamera()
{
  return(m_pScene->getCamera());
}


// 140395
// Gerbert Orasche
// copies actual file to an alternate user defined
BOOL CSceneDoc::OnSaveDocument(LPCTSTR lpszPathName) 
{
  TRACE("On Save Document: %s\n",lpszPathName);

  CFileDialog saveDlg(FALSE,NULL,NULL, 
                OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT | OFN_PATHMUSTEXIST,
                "VRML files (*.wrl) | *.wrl | Hyper-G scenes (*.sdf) | *.sdf | All Files (*.*) | *.* ||",
                NULL );
    
  if(saveDlg.DoModal()==IDCANCEL)
    return(FALSE);

  CString csFName = saveDlg.GetPathName();

  TRACE("output filename:%s\n",csFName.GetBuffer(1));

  BeginWaitCursor();

  // we have only to copy 
  // conversion must be supplied in future
  BOOL bResult=CopyFile(m_szFileName,lpszPathName,FALSE);

  if(!bResult)
  {
    ;//
  }

  EndWaitCursor();
  return(bResult);
}
