// This may look like C code, but it is really -*- C++ -*-

//<copyright>
// 
// Copyright (c) 1992,93,94,95
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
// 
//</copyright>

//<file>
//
// Name:        scenedata.h
//
// Purpose:     interface to 3D scene data (abstract)
//              (no implementation associated with class SceneData)
//
// Created:     24 Apr 95   Michael Pichler (extracted from scene3d.h)
//
// Changed:     27 Jun 95   Michael Pichler
//
//
//</file>


#ifndef harmony_scene_scenedata_h
#define harmony_scene_scenedata_h

class Camera;
class GeometricObject;
class Material;
class Scene3D;
class StringArray;
class QvWWWInline;


#include <ge3d/vectors.h>

#include <stdio.h>
class ostream;


class SceneData
{ 
  public:
    SceneData (Scene3D* scene)
    { scene_ = scene; }
    virtual ~SceneData ()  { }

    // *** input ***
    // readInput arguments format dependent (no virtual function)
    virtual void loadTextures () = 0;   // request all textures
    virtual const char* formatName () const = 0;  // "SDF", "VRML" etc.
    virtual int readInlineVRML (QvWWWInline*, const char*)  { return 0; }

    // *** output ***
    virtual int writeData (ostream& /*os*/, int /*format*/)  { return 0; }
    // write SDF file to output stream
    virtual void printInfo (int /*all*/)  { }   // print scene information
    virtual unsigned long getNumFaces () const = 0;  // number of faces (polygons)

    // *** drawing ***
    virtual void draw (int mode) = 0;   // draw whole scene

    // *** picking ***
    // TODO: abstract return type
    virtual GeometricObject* pickObject (
      float fx, float fy,               // picking coordinates (fraction of window width and height)
      point3D* hitpoint = 0,            // optionally calculates hit point
      vector3D* normal = 0,             // and face normal vector (normalized)
      const StringArray** groups = 0,   // optionally determines groups hit
      float* hittime = 0                // optionally returns the hit time
    ) = 0;

    // *** find objects ***
    // TODO: abstract return types
    virtual GeometricObject* findObject (const char* /*objname*/)  { return 0; }
    virtual GeometricObject* findObject (int /*objnum*/)  { return 0; }
    virtual Material* findMaterial (const char* /*matname*/) { return 0; }

    // *** anchors ***
    virtual void clearAnchors ()  { }   // clear all anchor definitions

    // *** camera ***
    virtual Camera* getCamera () const = 0;     // get active camera
    virtual void storeCamera () = 0;            // store active camera
    virtual void restoreCamera () = 0;          // reset camera (to one read from file or latest stored)

  protected:
    Scene3D* scene_;

}; // SceneData


#endif
