// scenedoc.cpp : implementation file
// written in December 1994
// Gerbert Orasche
// copyright: (c) 1994-95
// Institute For Information Processing And Computer Supported New Media (IICM)
// Graz University Of Technology

#include "stdafx.h"
#include <hgapp.h>
#include <mainfrm.h>

//#include "scene.h"
#include "scviewer.h"
#include "scenedoc.h"
#include "scenevw.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSceneApp

BEGIN_MESSAGE_MAP(CSceneApp, CApplication)
	//{{AFX_MSG_MAP(CSceneApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
	// Standard file based document commands
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
	// Standard print setup command
	ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSceneApp construction

CSceneApp::CSceneApp()
{
  // for making integration easier we put code to an extra class...
  scViewer_=new CSceneViewer;
}

CSceneApp::~CSceneApp()
{
  // so we created it, now its time to delete!
  delete scViewer_;
}


/////////////////////////////////////////////////////////////////////////////
// The one and only CSceneApp object

CSceneApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CSceneApp initialization

BOOL CSceneApp::InitInstance()
{
  SetPrivateProfileName("VRweb");
  if(!CApplication::InitInstance())
    return(FALSE);

	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

	Enable3dControls();

	LoadStdProfileSettings();  // Load standard INI file options (including MRU)

	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.

	CMultiDocTemplate* pDocTemplate;
	pDocTemplate = new CMultiDocTemplate(
		IDR_SCENEVRMLTYPE,
		RUNTIME_CLASS(CSceneDoc),
		RUNTIME_CLASS(CMDIChildWnd),          // VRML child frame
		RUNTIME_CLASS(CSceneView));
	AddDocTemplate(pDocTemplate);

  // the second one for the second input filter
	pDocTemplate = new CMultiDocTemplate(
		IDR_SCENESDFTYPE,
		RUNTIME_CLASS(CSceneDoc),
		RUNTIME_CLASS(CMDIChildWnd),          // SDF child frame
		RUNTIME_CLASS(CSceneView));
	AddDocTemplate(pDocTemplate);

	// create main MDI Frame window
	CMainFrame* pMainFrame = new CMainFrame;
	if (!pMainFrame->LoadFrame(IDR_MAINFRAME))
		return FALSE;
	m_pMainWnd = pMainFrame;

	if (m_lpCmdLine[0] != '\0')
	{
    if(!OpenDocumentFile(m_lpCmdLine))
    {
      AfxMessageBox("Error opening file!",MB_OK);;
    }
	}

  // call the encapsulated init code of CPSViewer
  scViewer_->InitInstance();


	// The main window has been initialized, so show and update it.
	pMainFrame->ShowWindow(m_nCmdShow);
	pMainFrame->UpdateWindow();

	return TRUE;
}

int CSceneApp::ExitInstance() 
{
  // call the encapsulated exit code of CPSViewer
  int scRet = scViewer_->ExitInstance();

  CApplication::ExitInstance();

  return scRet;
}


/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//{{AFX_MSG(CAboutDlg)
		// No message handlers
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void CSceneApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// CSceneApp commands

// 17.5.1995
// calls the actual view OnIdle function
BOOL CSceneApp::OnIdle(LONG lCount) 
{
	if(CWinApp::OnIdle(lCount))
	  return(TRUE);

  // call active view OnIdle()
  CMDIChildWnd* pMDIChildWnd=((CMDIFrameWnd*)m_pMainWnd)->MDIGetActive();
  if(pMDIChildWnd==NULL)
    // no active MDI child frame
    return(FALSE); 
  CSceneView* pView=(CSceneView*)pMDIChildWnd->GetActiveView();
  if(pView)
    return(pView->OnIdle(lCount));
  else
    return(FALSE);
}

//
// This bit of code catches control-c's, it cleans up everything.
//

int cleanupDone = 0;

void cleanup(int i)
{
    if (cleanupDone)
        _exit(i);
    cleanupDone = 1;

    theApp.ExitInstance();

    if (i)
       TRACE("Program stopped (caught signal %d).\n",i);
    exit(i);
}


extern "C" void _cleanup(int i)
{
    cleanup(i);
}

