//<copyright>
// 
// Copyright (c) 1993,94
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
// 
//</copyright>

//<file>
//
// Name:        object.C
//
// Purpose:     implementation of class object3D
//
// Created:     12 Mar 92   Michael Hofer and Michael Pichler
//
// Changed:      1 Aug 94   Michael Pichler
//
//
//</file>



#include "object3d.h"

#include <string.h>
#include <iostream.h>



Object3D::Object3D (int obj_n, int par, const char* name)
{
  obj_num_ = obj_n;
  parent_ = par;
  if (name)
  { strncpy (name_, name, 31);  // assuming char name_ [32]
    name_ [31] = '\0';
  }
  else  *name_ = '\0';  // ""

  channel_ [ch_xtran] = channel_ [ch_ytran] = channel_ [ch_ztran] = 0.0;
  channel_ [ch_xrot] = channel_ [ch_yrot] = channel_ [ch_zrot] = 0.0;
  channel_ [ch_xscale] = channel_ [ch_yscale] = channel_ [ch_zscale] = channel_ [ch_scale] = 1.0;

  strcpy (transfprior_, "trs");
  strcpy (rotprior_, "xyz");
}


static const char* channel_name [Object3D::num_channels] =
{ "XTRAN", "YTRAN", "ZTRAN", "XROT", "YROT", "ZROT",
  "XSCALE", "YSCALE", "ZSCALE", "SCALE"
};

const char* Object3D::channelName (int i)
{
  return channel_name [i];
}



// printobj prints name, number and channel values of an object
// designed for call in print () of derived classes


void Object3D::printobj ()
{
  cout << "name: '" << name_ << "', objectnumber: " << obj_num_;
  if (parent_)
    cout << ", parent: " << parent_;
  cout << endl;

  cout << "  channelvalues (TRS):";
  for (int i = 0; i < 10; i++)
     cout << "  " << channel_ [i];
  cout << endl;
}
