// This may look like C code, but it is really -*- C++ -*-

//<copyright>
// 
// Copyright (c) 1993,94,95
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
// 
//</copyright>

//<file>
//
// Name:        camera.h
//
// Purpose:     interface to Camera base object
//
// Created:      4 May 95   Michael Pichler (extracted from SDFCamera)
//
// Changed:      4 May 95   Michael Pichler
//
//
//</file>



#ifndef harmony_scene_camera_h
#define harmony_scene_camera_h

#include <ge3d/vectors.h>



class Camera
{
  public:
    Camera ();
    virtual ~Camera ()  { }

    void setCamera (float winasp);      // set ge3d's camera

    virtual void print ();  // write camera information

    // *** movement of the scene/camera ***
    void translate (const vector3D&);   // translate along vector
    void translate (float x, float y, float winasp, float flen);
                                        // translate parallel to viewplane
    void zoom_in (float);               // zoom in
    void rotate_camera_right (float);   // rotate left to right (around position)
    void rotate_camera_up (float);      // rotate bottom to top ("      "       )
    void rotate (float l2r, float b2t, const point3D& center);  // arbitrary center
                                        // (angles: left to right and bottom to top)

    void rotate (float, const point3D& center, char axis);  // anachronism

    void makeHoricontal ();

    // *** set camera parameters ***
    void setposlook (const point3D&, const point3D&);
    void setposition (const point3D& pos)  { position_ = pos; }
    void setlookat (const point3D& lkat)   { lookat_ = lkat; }

    // *** get camera parameters ***
    void getposition (point3D& pos) const  { pos = position_; }
    void getlookat (point3D& lkat) const   { lkat = lookat_; }
    void getupvector (vector3D& upv) const { upv = up_; }

    float getfocallen () const          // distance from camera to viewplane
    { return focallen_; }
    float getaper () const              // height of the camera window (on viewplane)
    { return aper_; }
    float getaspect () const            // ratio width/height of camera window
    { return aspect_; }                 // (should always match window aspect)
    float gethither () const            // near clipping plane
    { return hither_; }
    float getyon () const               // far clipping plane
    { return yon_; }
    void setyon (float value)
    { yon_ = value; }

  protected:
    point3D position_, lookat_;
    vector3D up_;
    char projtype_;  // 'O' or 'P'
    float focallen_,
          aper_,     // viewport height
          aspect_,
          left_, top_, right_, bottom_,
          hither_, yon_;
    int pos_look_set_;

}; // Camera


inline void Camera::setposlook (const point3D& pos, const point3D& look)
{ position_ = pos;
  lookat_ = look;
  pos_look_set_ = 1;
}


#endif
