#!/usr/bin/perl

use SOAP::Lite;

$wsdl = 'http://soap.genome.jp/KEGG.wsdl';

$serv = SOAP::Lite->service($wsdl);


print "get_pathways_by_genes\n";

$genes = SOAP::Data->type(array => ['eco:b0077' , 'eco:b0078']);
#$els = $serv->get_pathways_by_genes($genes);

$genes = SOAP::Data->type(array => ["ec:1.3.99.1"]);
$els = $serv->get_pathways_by_enzymes($genes);

print join(', ', @{$els}), "\n";

print "Done\n";

$start = 1;
$max_results = 5;

$top5 = $serv->get_best_neighbors_by_gene('eco:b0002', $start, $max_results);

foreach $hit (@{$top5}) {
  print "$hit->{genes_id1}\t$hit->{genes_id2}\t$hit->{sw_score}\n";
}
