### Name: stat.bay.est
### Title: Calculates an Odds Ratio for Each Gene in a Multi-slide
###   Microarray Experiment.
### Aliases: stat.bay.est
### Keywords: models

### ** Examples

data(MouseArray)
## mouse.setup <- init.grid() 
## mouse.data <- init.data() ## see \emph{init.data} 
## mouse.lratio <- stat.ma(mouse.data, mouse.setup)

mouse.bayesian<-stat.bay.est(M=mouse.lratio$M)
plot(mouse.bayesian$Xprep$Mbar, mouse.bayesian$lods)

#alternatively

mouse.est<-apply(mouse.lratio$M,1,mean.na)
mouse.Vest<-apply(mouse.lratio$M,1,var.na)
n<-ncol(mouse.lratio$M)
k<-n
f<-n-1
mouse.Xprep<-list(Mbar=mouse.est,Vest=mouse.Vest,k=k,f=f)

mouse.bayest<-stat.bay.est(Xprep=mouse.Xprep)
plot(mouse.bayest$Xprep$Mbar, mouse.bayest$lods)




