### Name: smoothScatter
### Title: Scatterplots with smoothed densities color representation
### Aliases: smoothScatter densCols
### Keywords: hplot

### ** Examples

sampdat <- readFCS(system.file("extdata","fas Bcl2 plate323-04-04.A01",package="prada"))
x       <- exprs(sampdat[,1:2])

if(interactive()) {
  layout(matrix(1:4, ncol=2, byrow=TRUE))
  smoothScatter(x, nrpoints=0)
  smoothScatter(x)
  smoothScatter(x, nrpoints=Inf, colramp=colorRampPalette(brewer.pal(9, "YlOrRd")), bandwidth=40)  

  colors  <- densCols(x)
  plot(x, col=colors, pch=20)
}



