### Name: mclustDAtrain
### Title: MclustDA Training
### Aliases: mclustDAtrain
### Keywords: cluster

### ** Examples

n <- 250 ## create artificial data
set.seed(0)
par(pty = "s")
x <- rbind(matrix(rnorm(n*2), n, 2) %*% diag(c(1,9)),
           matrix(rnorm(n*2), n, 2) %*% diag(c(1,9))[,2:1])
xclass <- c(rep(1,n),rep(2,n))
## Not run: 
##D mclust2Dplot(x, classification = xclass, type="classification", ask=FALSE)
## End(Not run)

odd <- seq(1, 2*n, 2)
train <- mclustDAtrain(x[odd, ], labels = xclass[odd]) ## training step
summary(train)

even <- odd + 1
test <- mclustDAtest(x[even, ], train) ## compute model densities
clEven <- summary(test)$class ## classify training set
compareClass(clEven,xclass[even])



