### Name: mclust2Dplot
### Title: Plot two-dimensional data modelled by an MVN mixture.
### Aliases: mclust2Dplot
### Keywords: cluster

### ** Examples

n <- 250 ## create artificial data
set.seed(0)
x <- rbind(matrix(rnorm(n*2), n, 2) %*% diag(c(1,9)),
           matrix(rnorm(n*2), n, 2) %*% diag(c(1,9))[,2:1])
xclass <- c(rep(1,n),rep(2,n))

xEMclust <- summary(EMclust(x),x)

mclust2Dplot(x, truth = xclass, z = xEMclust$z, ask=FALSE,
                mu = xEMclust$mu, sigma = xEMclust$sigma)

do.call("mclust2Dplot", c(list(data = x, truth = xclass, ask=FALSE), xEMclust))




