### Name: decomp2sigma
### Title: Convert mixture component covariances to matrix form.
### Aliases: decomp2sigma
### Keywords: cluster

### ** Examples

data(iris)
irisMatrix <- as.matrix(iris[,1:4])
irisClass <- iris[,5]

meEst <- meVEV(irisMatrix, unmap(irisClass)) 
names(meEst)
meEst$decomp
meEst$sigma

dec <- meEst$decomp
decomp2sigma(d=dec$d, G=dec$G, shape=dec$shape, scale=dec$scale,
             orientation = dec$orientation)
## Not run: 
##D do.call("decomp2sigma", meEst$decomp)  ## alternative call
## End(Not run)



