### Name: hgu133aPMID
### Title: Mappings between probe identifiers and PubMed identifiers
### Aliases: hgu133aPMID
### Keywords: datasets

### ** Examples

    # Convert the environment to a list
    xx <- as.list(hgu133aPMID)
    if(length(xx) > 0){
        # The probe ids for the first two elements of XX
        xx[1:2]
        # Get the first one
        xx[[1]]
        if(interactive() && !is.null(xx[[1]]) && !is.na(xx[[1]])
           && require(annotate)){
            # Gets article information as XML files
            xmls <- pubmed(xx[[1]], disp = "data")
            # Views article information using a browser
            pubmed(xx[[1]], disp = "browser")
        }
    }



