### Name: knnB
### Title: An interface to various machine learning methods for exprSets
### Aliases: allClass balKfold stat.diag.daB chkMLInterfaceProc claraB
###   confuMat cvB distMat fannyB getGrid isoMDSB knn1B knn.cvB knnP lcaB
###   logitboostB lvq2B lvq3B makeCVFunc newGroupIndex newMembMat
###   newPredClass newProbArray newProbMat newQualScore newSilhouetteVec
###   olvq1B predict.knnP predLabels print.knnP RObject silhouetteB somB
###   SOMB trainInds wrapClust xval knnB nnetB lvq1B agnesB dianaB pamB
###   bclustB cmeansB cshellB naiveBayesB svmB baggingB ipredknnB sldaB
###   ldaB qdaB pamrB kmeansB rpartB randomForestB hclustB gbmB
###   agnesB,exprSet,numeric-method allClass,classifOutput-method
###   baggingB,exprSet,character,integer-method
###   bclustB,exprSet,numeric-method claraB,exprSet,numeric-method
###   cmeansB,exprSet,numeric-method confuMat,classifOutput-method
###   cshellB,exprSet,numeric-method cvB,exprSet,character-method
###   dianaB,exprSet,numeric-method distMat,MLOutput-method
###   fannyB,exprSet,numeric-method gbmB,exprSet,character,integer-method
###   hclustB,exprSet,numeric,missing-method
###   hclustB,exprSet,numeric,ANY-method
###   hclustB,exprSet,missing,numeric-method
###   ipredknnB,exprSet,character,integer-method
###   kmeansB,exprSet,numeric-method knn1B,exprSet,character,integer-method
###   knnB,exprSet,character,integer-method
###   knn.cvB,exprSet,character-method lcaB,exprSet,numeric-method
###   ldaB,exprSet,character,integer-method
###   logitboostB,exprSet,character,integer,numeric-method
###   lvq1B,exprSet,character,integer-method
###   lvq2B,exprSet,character,integer-method
###   lvq3B,exprSet,character,integer-method
###   naiveBayesB,exprSet,character,integer-method
###   nnetB,exprSet,character,integer-method
###   olvq1B,exprSet,character,integer-method pamB,exprSet,numeric-method
###   pamrB,exprSet,character,integer-method predLabels,MLOutput-method
###   predLabels,classifOutput-method last.warning
###   qdaB,exprSet,character,integer-method
###   randomForestB,exprSet,character,integer-method
###   RObject,MLOutput-method rpartB,exprSet,character,integer-method
###   show,probMat-method show,probArray-method show,membMat-method
###   show,qualScore-method show,silhouetteVec-method show,MLOutput-method
###   show,SOMBout-method sldaB,exprSet,character,integer-method
###   somB,exprSet,character-method SOMB,exprSet,character-method
###   svmB,exprSet,character,integer-method trainInds,classifOutput-method
###   xval,exprSet,character,nonstandardGeneric,character,missing-method
### Keywords: classif

### ** Examples

##get these from the source files
library(golubEsets)
data(golubMerge)
smallG <- golubMerge[1:60,]
knnB( smallG, "ALL.AML", 1:40 )
set.seed(1234) # needed for nnet initialization
nnetB( smallG, "ALL.AML", 1:40, size=5, decay=.01 )
lvq1B( smallG, "ALL.AML", 1:40 )
agnesB( smallG, k=5, height=0, FALSE )
dianaB( smallG, k=5, height=0, FALSE )
pamB( smallG, k=5, height=0, FALSE )
bclustB( smallG, k=5, height=0 )
cmeansB( smallG, k=5, height=0 )
cshellB( smallG, k=5, height=0 , iter.max=1)
#lcaB( BsmG, k=3 )
naiveBayesB( smallG, "ALL.AML", 1:40 )
svmB( smallG, "ALL.AML", 1:40 )
baggingB( smallG, "ALL.AML", 1:40 )
ipredknnB( smallG, "ALL.AML", 1:40 )
sldaB( smallG, "ALL.AML", 1:40 )
ldaB( smallG, "ALL.AML", 1:40 )
qdaB( smallG[1:10,], "ALL.AML", 1:40 )
pamrB( smallG, "ALL.AML", 1:40 )
LOO1 <- xval(smallG, "ALL.AML", knnB, "LOO", 0:0)
LOO2 <- xval(smallG, "ALL.AML", knnB, "FUN", 0:0, function(x,y,i) {
  (1:ncol(exprs(x)))[-i] }, niter=72 )
table(LOO1, LOO2)
kmeansB( smallG, k=4 )
rpartB( smallG, "ALL.AML", 1:35 )
randomForestB( smallG, "ALL.AML", 1:35 )
hclustB( smallG, k=4 )
hclustB( smallG, height=40000 )
gbmB( smallG, "ALL.AML", 1:40, n.minobsinnode=3 , n.trees=6000)
if (require(LogitBoost)) logitboostB( smallG, "ALL.AML", 1:40, 200 ) # summarize won't work with polych
stat.diag.daB( smallG, "ALL.AML", 1:40 )



