### Name: GOLOCUSID
### Title: Annotation of GO identifiers by the corresponding LocusLink
###   identifiers
### Aliases: GOLOCUSID
### Keywords: datasets

### ** Examples

    require("GO") || stop("GO unavailable")
    # Convert the environment object to a list
    xx <- as.list(GOLOCUSID)
    # Remove GO ids that are not mapped to any LocusLink id
    xx <- xx[!is.na(xx)]
    if(length(xx) > 0){
        # Get the LocusLink ids for the first two elents of xx
        llids  <- xx[1:2]
        # Get the evidence code llids
        evds <- sapply(llids, names)
    }



