### Name: phenoData-class
### Title: Class phenoData, a class for patient or experiment level data.
### Aliases: phenoData-class phenoData $.phenoData phenoData<-,pheno
###   [,phenoData-method pData,phenoData-method pData<-,phenoData-method
###   show,phenoData-method split,phenoData,vector-method
###   varLabels,phenoData-method [[,phenoData-method [[<-,phenoData-method
###   convertVarLabels,phenoData-method getUnits,phenoData,character-method
###   getVarMetadata,phenoData,character,character-method
###   addVarMetadataEntry,phenoData,character,character-method
###   getVarMetadata,phenoData,character,missing-method
###   varMetadata,phenoData-method addVarMetadataEntry convertVarLabels
###   getUnits getVarMetadata varMetadata
### Keywords: methods

### ** Examples

data(eset)
pes <- phenoData(eset)
pes <- convertVarLabels(pes)
varMetadata(pes)
pes <- addVarMetadataEntry(pes, "cov1", "units", "inches")
getUnits(pes, "cov1")



