### Name: eSet-class
### Title: Class "eSet": a new exprSet class
### Aliases: eSet-class [,eSet-method $.eSet getExpData
###   combine,eSet,eSet-method combine,eSet,ANY-method eList eList<-
###   eList,eSet-method eList<-,eSet,environment-method
###   eList<-,eSet,list-method exprs,eSet-method
###   getExpData,eSet,character-method pData,eSet-method
###   pData<-,eSet-method phenoData,eSet-method
###   phenoData<-,eSet,phenoData-method show,eSet-method eMetadata
###   exprListNM-class eMetadata<- eMetadata<-,eSet,data.frame-method
###   eMetadata,exprList-method eMetadata,eSet-method
###   show,exprListNM-method show,exprList-method
### Keywords: classes

### ** Examples

##---- Should be DIRECTLY executable !! ----
data(eset)
newe <- new("exprList", .Data=list(exprs=exprs(eset)),
        eMetadata=data.frame())
es1 <- new("eSet", eList=newe, phenoData=phenoData(eset))  
es1
dim(exprs(es1))
md <- data.frame(name="exprs", etype="random numbers")
eMetadata(es1) <- md
eList(es1)
newe <- new("exprList", .Data=list(exprs=exprs(eset), se=exprs(eset)/1.96),
        eMetadata=data.frame(name=c("exprs", "se"),
                etype=c("RNG output", "S.E. of expression"),
                method=c("rnorm", "scaling")))
es2 <- new("eSet", eList=newe, phenoData=phenoData(eset))
es2
eList(es2)
phenoData(es2)@varMetadata <- 
        data.frame(varName=c("cov1", "cov2", "cov3"),
                units=c("cm", "in", NA))
getUnits(phenoData(es2), "cov1")



